/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GeneralCommands {
    private final WorldGuardPlugin plugin;

    public GeneralCommands(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"god"}, usage="[player]", desc="Enable godmode on a player", flags="s", max=1)
    public void god(CommandContext args, CommandSender sender) throws CommandException {
        ConfigurationManager config = this.plugin.getGlobalStateManager();
        Iterable<Player> targets = null;
        boolean included = false;
        if (args.argsLength() == 0) {
            targets = this.plugin.matchPlayers(this.plugin.checkPlayer(sender));
            this.plugin.checkPermission(sender, "worldguard.god");
        } else if (args.argsLength() == 1) {
            targets = this.plugin.matchPlayers(sender, args.getString(0));
            this.plugin.checkPermission(sender, "worldguard.god.other");
        }
        for (Player player : targets) {
            config.enableGodMode(player);
            player.setFireTicks(0);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0436\u0438\u043c \u0411\u043e\u0433\u0430 \u0432\u043a\u043b\u044e\u0447\u0451\u043d! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439 /ungod \u0447\u0442\u043e \u0431\u044b \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c.");
                included = true;
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0436\u0438\u043c \u0411\u043e\u0433\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0438\u0433\u0440\u043e\u043a\u043e\u043c " + this.plugin.toName(sender) + ".");
        }
        if (!included && args.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0438\u043c\u0435\u044e\u0442 \u0440\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430.");
        }
    }

    @Command(aliases={"ungod"}, usage="[player]", desc="Disable godmode on a player", flags="s", max=1)
    public void ungod(CommandContext args, CommandSender sender) throws CommandException {
        ConfigurationManager config = this.plugin.getGlobalStateManager();
        Iterable<Player> targets = null;
        boolean included = false;
        if (args.argsLength() == 0) {
            targets = this.plugin.matchPlayers(this.plugin.checkPlayer(sender));
            this.plugin.checkPermission(sender, "worldguard.god");
        } else if (args.argsLength() == 1) {
            targets = this.plugin.matchPlayers(sender, args.getString(0));
            this.plugin.checkPermission(sender, "worldguard.god.other");
        }
        for (Player player : targets) {
            config.disableGodMode(player);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0436\u0438\u043c \u0411\u043e\u0433\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                included = true;
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0433\u0440\u043e\u043a\u043e\u043c " + this.plugin.toName(sender) + ".");
        }
        if (!included && args.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0438\u043c\u0435\u044e\u0442 \u0440\u0435\u0436\u0438\u043c \u0431\u043e\u0433\u0430.");
        }
    }

    @Command(aliases={"heal"}, usage="[player]", desc="Heal a player", flags="s", max=1)
    public void heal(CommandContext args, CommandSender sender) throws CommandException {
        Iterable<Player> targets = null;
        boolean included = false;
        if (args.argsLength() == 0) {
            targets = this.plugin.matchPlayers(this.plugin.checkPlayer(sender));
            this.plugin.checkPermission(sender, "worldguard.heal");
        } else if (args.argsLength() == 1) {
            targets = this.plugin.matchPlayers(sender, args.getString(0));
            this.plugin.checkPermission(sender, "worldguard.heal.other");
        }
        for (Player player : targets) {
            player.setHealth(20);
            player.setFoodLevel(20);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "\u0418\u0441\u0446\u0435\u043b\u0435\u043d!");
                included = true;
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "\u0418\u0441\u0446\u0435\u043b\u0435\u043d \u0438\u0433\u0440\u043e\u043a\u043e\u043c " + this.plugin.toName(sender) + ".");
        }
        if (!included && args.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u0438\u0441\u0446\u0435\u043b\u0435\u043d\u044b");
        }
    }

    @Command(aliases={"slay"}, usage="[player]", desc="Slay a player", flags="s", max=1)
    public void slay(CommandContext args, CommandSender sender) throws CommandException {
        Iterable<Player> targets = null;
        boolean included = false;
        if (args.argsLength() == 0) {
            targets = this.plugin.matchPlayers(this.plugin.checkPlayer(sender));
            this.plugin.checkPermission(sender, "worldguard.slay");
        } else if (args.argsLength() == 1) {
            targets = this.plugin.matchPlayers(sender, args.getString(0));
            this.plugin.checkPermission(sender, "worldguard.slay.other");
        }
        for (Player player : targets) {
            player.setHealth(0);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "\u041a\u043e\u0446\u043d\u0443\u0442!");
                included = true;
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "\u041a\u043e\u0446\u043d\u0443\u0442 \u0438\u0433\u0440\u043e\u043a\u043e\u043c " + this.plugin.toName(sender) + ".");
        }
        if (!included && args.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW.toString() + "\u0418\u0433\u0440\u043e\u043a\u0438 \u043a\u043e\u0446\u043d\u0443\u0442\u044b.");
        }
    }

    @Command(aliases={"locate"}, usage="[player]", desc="Locate a player", max=1)
    @CommandPermissions(value={"worldguard.locate"})
    public void locate(CommandContext args, CommandSender sender) throws CommandException {
        Player player = this.plugin.checkPlayer(sender);
        if (args.argsLength() == 0) {
            player.setCompassTarget(player.getWorld().getSpawnLocation());
            sender.sendMessage(ChatColor.YELLOW.toString() + "\u041a\u043e\u043c\u043f\u0430\u0441 \u0441\u0431\u0440\u043e\u0448\u0435\u043d \u043d\u0430 \u0441\u043f\u0430\u0443\u043d.");
        } else {
            Player target = this.plugin.matchSinglePlayer(sender, args.getString(0));
            player.setCompassTarget(target.getLocation());
            sender.sendMessage(ChatColor.YELLOW.toString() + "Compass repointed.");
        }
    }

    @Command(aliases={"stack", ";"}, usage="", desc="Stack items", max=0)
    @CommandPermissions(value={"worldguard.stack"})
    public void stack(CommandContext args, CommandSender sender) throws CommandException {
        Player player = this.plugin.checkPlayer(sender);
        boolean ignoreMax = this.plugin.hasPermission((CommandSender)player, "worldguard.stack.illegitimate");
        boolean ignoreDamaged = this.plugin.hasPermission((CommandSender)player, "worldguard.stack.damaged");
        ItemStack[] items = player.getInventory().getContents();
        int len = items.length;
        int affected = 0;
        block0: for (int i = 0; i < len; ++i) {
            int max;
            ItemStack item = items[i];
            if (item == null || item.getAmount() <= 0 || !ignoreMax && item.getMaxStackSize() == 1) continue;
            int n = max = ignoreMax ? 64 : item.getMaxStackSize();
            if (item.getAmount() >= max) continue;
            int needed = max - item.getAmount();
            for (int j = i + 1; j < len; ++j) {
                ItemStack item2 = items[j];
                if (item2 == null || item2.getAmount() <= 0 || !ignoreMax && item.getMaxStackSize() == 1 || item2.getTypeId() != item.getTypeId() || (ItemType.usesDamageValue((int)item.getTypeId()) || !ignoreDamaged) && item.getDurability() != item2.getDurability() || !item.getEnchantments().equals(item2.getEnchantments())) continue;
                if (item2.getAmount() > needed) {
                    item.setAmount(64);
                    item2.setAmount(item2.getAmount() - needed);
                    continue block0;
                }
                items[j] = null;
                item.setAmount(item.getAmount() + item2.getAmount());
                needed = 64 - item.getAmount();
                ++affected;
            }
        }
        if (affected > 0) {
            player.getInventory().setContents(items);
        }
        player.sendMessage(ChatColor.YELLOW + "\u0412\u0435\u0449\u0438 \u0443\u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442\u043e\u0432\u0430\u043d\u044b \u0432 \u0441\u0442\u0430\u043a\u0438!");
    }
}

