/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import com.sk89q.worldedit.bukkit.selections.Polygonal2DSelection;
import com.sk89q.worldedit.bukkit.selections.Selection;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.databases.ProtectionDatabaseException;
import com.sk89q.worldguard.protection.databases.RegionDBUtil;
import com.sk89q.worldguard.protection.databases.migrators.AbstractDatabaseMigrator;
import com.sk89q.worldguard.protection.databases.migrators.MigrationException;
import com.sk89q.worldguard.protection.databases.migrators.MigratorKey;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.GlobalProtectedRegion;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionCommands {
    private final WorldGuardPlugin plugin;
    private MigratorKey migrateDBRequest;
    private Date migrateDBRequestDate;

    public RegionCommands(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    @Command(aliases={"define", "def", "d"}, usage="<id> [<owner1> [<owner2> [<owners...>]]]", desc="Defines a region", min=1)
    @CommandPermissions(value={"worldguard.region.define"})
    public void define(CommandContext args, CommandSender sender) throws CommandException {
        ProtectedRegion region;
        Player player = this.plugin.checkPlayer(sender);
        WorldEditPlugin worldEdit = this.plugin.getWorldEdit();
        String id = args.getString(0);
        if (!ProtectedRegion.isValidId(id)) {
            throw new CommandException("\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 ID \u0440\u0435\u0433\u0438\u043e\u043d\u0430!");
        }
        if (id.equalsIgnoreCase("__global__")) {
            throw new CommandException("A region cannot be named __global__");
        }
        Selection sel = worldEdit.getSelection(player);
        if (sel == null) {
            throw new CommandException("\u0412\u044b\u0434\u0435\u043b\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e WorldEdit.");
        }
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(sel.getWorld());
        if (mgr.hasRegion(id)) {
            throw new CommandException("That region is already defined. Use redefine instead.");
        }
        if (sel instanceof Polygonal2DSelection) {
            Polygonal2DSelection polySel = (Polygonal2DSelection)sel;
            int minY = polySel.getNativeMinimumPoint().getBlockY();
            int maxY = polySel.getNativeMaximumPoint().getBlockY();
            region = new ProtectedPolygonalRegion(id, polySel.getNativePoints(), minY, maxY);
        } else if (sel instanceof CuboidSelection) {
            BlockVector min = sel.getNativeMinimumPoint().toBlockVector();
            BlockVector max = sel.getNativeMaximumPoint().toBlockVector();
            region = new ProtectedCuboidRegion(id, min, max);
        } else {
            throw new CommandException("The type of region selected in WorldEdit is unsupported in WorldGuard!");
        }
        if (args.argsLength() > 1) {
            region.setOwners(RegionDBUtil.parseDomainString(args.getSlice(1), 1));
        }
        mgr.addRegion(region);
        try {
            mgr.save();
            sender.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0433\u0438\u043e\u043d \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u043a\u0430\u043a " + id + ".");
        }
        catch (ProtectionDatabaseException e) {
            throw new CommandException("Failed to write regions: " + e.getMessage());
        }
    }

    @Command(aliases={"redefine", "update", "move"}, usage="<id>", desc="Re-defines the shape of a region", min=1, max=1)
    public void redefine(CommandContext args, CommandSender sender) throws CommandException {
        ProtectedRegion region;
        Player player = this.plugin.checkPlayer(sender);
        World world = player.getWorld();
        WorldEditPlugin worldEdit = this.plugin.getWorldEdit();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        String id = args.getString(0);
        if (id.equalsIgnoreCase("__global__")) {
            throw new CommandException("The region cannot be named __global__");
        }
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
        ProtectedRegion existing = mgr.getRegion(id);
        if (existing == null) {
            throw new CommandException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u044d\u0442\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c.");
        }
        if (existing.isOwner(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.redefine.own");
        } else if (existing.isMember(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.redefine.member");
        } else {
            this.plugin.checkPermission(sender, "worldguard.region.redefine");
        }
        Selection sel = worldEdit.getSelection(player);
        if (sel == null) {
            throw new CommandException("\u0412\u044b\u0434\u0435\u043b\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e WorldEdit.");
        }
        if (sel instanceof Polygonal2DSelection) {
            Polygonal2DSelection polySel = (Polygonal2DSelection)sel;
            int minY = polySel.getNativeMinimumPoint().getBlockY();
            int maxY = polySel.getNativeMaximumPoint().getBlockY();
            region = new ProtectedPolygonalRegion(id, polySel.getNativePoints(), minY, maxY);
        } else if (sel instanceof CuboidSelection) {
            BlockVector min = sel.getNativeMinimumPoint().toBlockVector();
            BlockVector max = sel.getNativeMaximumPoint().toBlockVector();
            region = new ProtectedCuboidRegion(id, min, max);
        } else {
            throw new CommandException("The type of region selected in WorldEdit is unsupported in WorldGuard!");
        }
        region.setMembers(existing.getMembers());
        region.setOwners(existing.getOwners());
        region.setFlags(existing.getFlags());
        region.setPriority(existing.getPriority());
        try {
            region.setParent(existing.getParent());
        }
        catch (ProtectedRegion.CircularInheritanceException ignore) {
            // empty catch block
        }
        mgr.addRegion(region);
        sender.sendMessage(ChatColor.YELLOW + "Region updated with new area.");
        try {
            mgr.save();
        }
        catch (ProtectionDatabaseException e) {
            throw new CommandException("Failed to write regions: " + e.getMessage());
        }
    }

    @Command(aliases={"claim"}, usage="<id> [<owner1> [<owner2> [<owners...>]]]", desc="Claim a region", min=1)
    @CommandPermissions(value={"worldguard.region.claim"})
    public void claim(CommandContext args, CommandSender sender) throws CommandException {
        int maxRegionCount;
        ProtectedRegion region;
        Player player = this.plugin.checkPlayer(sender);
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        WorldEditPlugin worldEdit = this.plugin.getWorldEdit();
        String id = args.getString(0);
        if (!ProtectedRegion.isValidId(id)) {
            throw new CommandException("\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 ID \u0440\u0435\u0433\u0438\u043e\u043d\u0430!");
        }
        if (id.equalsIgnoreCase("__global__")) {
            throw new CommandException("A region cannot be named __global__");
        }
        Selection sel = worldEdit.getSelection(player);
        if (sel == null) {
            throw new CommandException("\u0412\u044b\u0434\u0435\u043b\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e WorldEdit.");
        }
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(sel.getWorld());
        if (mgr.hasRegion(id)) {
            throw new CommandException("That region already exists. Please choose a different name.");
        }
        if (sel instanceof Polygonal2DSelection) {
            Polygonal2DSelection polySel = (Polygonal2DSelection)sel;
            int minY = polySel.getNativeMinimumPoint().getBlockY();
            int maxY = polySel.getNativeMaximumPoint().getBlockY();
            region = new ProtectedPolygonalRegion(id, polySel.getNativePoints(), minY, maxY);
        } else if (sel instanceof CuboidSelection) {
            BlockVector min = sel.getNativeMinimumPoint().toBlockVector();
            BlockVector max = sel.getNativeMaximumPoint().toBlockVector();
            region = new ProtectedCuboidRegion(id, min, max);
        } else {
            throw new CommandException("The type of region selected in WorldEdit is unsupported in WorldGuard!");
        }
        if (args.argsLength() > 1) {
            region.setOwners(RegionDBUtil.parseDomainString(args.getSlice(1), 1));
        }
        WorldConfiguration wcfg = this.plugin.getGlobalStateManager().get(player.getWorld());
        if (!this.plugin.hasPermission(sender, "worldguard.region.unlimited") && (maxRegionCount = wcfg.getMaxRegionCount(player)) >= 0 && mgr.getRegionCountOfPlayer(localPlayer) >= maxRegionCount) {
            throw new CommandException("\u0423 \u0442\u0435\u0431\u044f \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u0432, \u0443\u0434\u0430\u043b\u0438 \u043e\u0434\u0438\u043d \u0447\u0442\u043e \u0431\u044b \u0437\u0430\u043f\u0440\u0438\u0432\u0430\u0442\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439.");
        }
        ProtectedRegion existing = mgr.getRegion(id);
        if (existing != null && !existing.getOwners().contains(localPlayer)) {
            throw new CommandException("\u0420\u0435\u0433\u0438\u043e\u043d \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438 \u0442\u044b \u043d\u0435 \u0435\u0433\u043e \u0432\u043b\u0430\u0434\u0435\u043b\u0435\u0446.");
        }
        ApplicableRegionSet regions = mgr.getApplicableRegions(region);
        if (regions.size() > 0) {
            if (!regions.isOwnerOfAll(localPlayer)) {
                throw new CommandException("\u0420\u0435\u0433\u0438\u043e\u043d \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u0447\u0443\u0436\u0438\u043c \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u043c.");
            }
        } else if (wcfg.claimOnlyInsideExistingRegions) {
            throw new CommandException("You may only claim regions inside existing regions that you or your group own.");
        }
        if (!this.plugin.hasPermission(sender, "worldguard.region.unlimited") && region.volume() > wcfg.maxClaimVolume) {
            player.sendMessage(ChatColor.RED + "\u0420\u0435\u0433\u0438\u043e\u043d \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u0447\u0442\u043e \u0431\u044b \u0437\u0430\u043f\u0440\u0438\u0432\u0430\u0442\u0438\u0442\u044c.");
            player.sendMessage(ChatColor.RED + "\u041c\u0430\u043a\u0441. \u0440\u0430\u0437\u043c\u0435\u0440: " + wcfg.maxClaimVolume + ", \u0442\u0432\u043e\u0439 \u0440\u0430\u0437\u043c\u0435\u0440: " + region.volume());
            return;
        }
        region.getOwners().addPlayer(player.getName());
        mgr.addRegion(region);
        try {
            mgr.save();
            sender.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0433\u0438\u043e\u043d \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u043a\u0430\u043a " + id + ".");
        }
        catch (ProtectionDatabaseException e) {
            throw new CommandException("Failed to write regions: " + e.getMessage());
        }
    }

    @Command(aliases={"select", "sel", "s"}, usage="<id>", desc="Load a region as a WorldEdit selection", min=1, max=1)
    public void select(CommandContext args, CommandSender sender) throws CommandException {
        Player player = this.plugin.checkPlayer(sender);
        World world = player.getWorld();
        WorldEditPlugin worldEdit = this.plugin.getWorldEdit();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        String id = args.getString(0);
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
        ProtectedRegion region = mgr.getRegion(id);
        if (region == null) {
            throw new CommandException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u044d\u0442\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c.");
        }
        if (region.isOwner(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.select.own." + id.toLowerCase());
        } else if (region.isMember(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.select.member." + id.toLowerCase());
        } else {
            this.plugin.checkPermission(sender, "worldguard.region.select." + id.toLowerCase());
        }
        if (region instanceof ProtectedCuboidRegion) {
            ProtectedCuboidRegion cuboid = (ProtectedCuboidRegion)region;
            BlockVector pt1 = cuboid.getMinimumPoint();
            BlockVector pt2 = cuboid.getMaximumPoint();
            CuboidSelection selection = new CuboidSelection(world, (Vector)pt1, (Vector)pt2);
            worldEdit.setSelection(player, (Selection)selection);
            sender.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0434\u0435\u043b\u0435\u043d \u043a\u0430\u043a \u043a\u0443\u0431\u043e\u0438\u0434.");
        } else if (region instanceof ProtectedPolygonalRegion) {
            ProtectedPolygonalRegion poly2d = (ProtectedPolygonalRegion)region;
            Polygonal2DSelection selection = new Polygonal2DSelection(world, poly2d.getPoints(), poly2d.getMinimumPoint().getBlockY(), poly2d.getMaximumPoint().getBlockY());
            worldEdit.setSelection(player, (Selection)selection);
            sender.sendMessage(ChatColor.YELLOW + "Region selected as a polygon.");
        } else {
            if (region instanceof GlobalProtectedRegion) {
                throw new CommandException("Can't select global regions.");
            }
            throw new CommandException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0440\u0435\u0433\u0438\u043e\u043d\u0430: " + region.getClass().getCanonicalName());
        }
    }

    @Command(aliases={"info", "i"}, usage="[world] <id>", desc="Get information about a region", min=1, max=2)
    public void info(CommandContext args, CommandSender sender) throws CommandException {
        String id;
        World world;
        Player player = null;
        LocalPlayer localPlayer = null;
        if (args.argsLength() == 1) {
            player = this.plugin.checkPlayer(sender);
            localPlayer = this.plugin.wrapPlayer(player);
            world = player.getWorld();
            id = args.getString(0).toLowerCase();
        } else {
            world = this.plugin.matchWorld(sender, args.getString(0));
            id = args.getString(1).toLowerCase();
        }
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
        if (!mgr.hasRegion(id)) {
            if (!ProtectedRegion.isValidId(id)) {
                throw new CommandException("\u0412\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 ID \u0440\u0435\u0433\u0438\u043e\u043d\u0430!");
            }
            throw new CommandException("\u0420\u0435\u0433\u0438\u043e\u043d \u0441 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c '" + id + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
        }
        ProtectedRegion region = mgr.getRegion(id);
        if (player != null) {
            if (region.isOwner(localPlayer)) {
                this.plugin.checkPermission(sender, "worldguard.region.info.own");
            } else if (region.isMember(localPlayer)) {
                this.plugin.checkPermission(sender, "worldguard.region.info.member");
            } else {
                this.plugin.checkPermission(sender, "worldguard.region.info");
            }
        } else {
            this.plugin.checkPermission(sender, "worldguard.region.info");
        }
        DefaultDomain owners = region.getOwners();
        DefaultDomain members = region.getMembers();
        sender.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0433\u0438\u043e\u043d: " + id + ChatColor.GRAY + " (\u0442\u0438\u043f: " + region.getTypeName() + ")");
        if (!ProtectedRegion.isValidId(id)) {
            sender.sendMessage(ChatColor.RED + "\u0420\u0435\u0433\u0438\u043e\u043d \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435." + "\u041f\u043e\u043f\u0440\u043e\u0441\u0438 \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0447\u0442\u043e \u0431\u044b \u043e\u043d \u0443\u0434\u0430\u043b\u0438\u043b, \u0438 \u0441\u043e\u0437\u0434\u0430\u043b \u0435\u0433\u043e \u0437\u0430\u043d\u043e\u0432\u043e.");
        }
        sender.sendMessage(ChatColor.BLUE + "\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: " + region.getPriority());
        StringBuilder s = new StringBuilder();
        for (Flag<?> flag : DefaultFlag.getFlags()) {
            Object val = region.getFlag(flag);
            if (val == null) continue;
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(flag.getName() + ": " + String.valueOf(val));
        }
        sender.sendMessage(ChatColor.BLUE + "\u0424\u043b\u0430\u0433\u0438: " + s.toString());
        sender.sendMessage(ChatColor.BLUE + "\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c: " + (region.getParent() == null ? "(\u043d\u0435\u0442)" : region.getParent().getId()));
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "\u0412\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u044b: " + owners.toUserFriendlyString());
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "\u0416\u0438\u0442\u0435\u043b\u0438: " + members.toUserFriendlyString());
        BlockVector min = region.getMinimumPoint();
        BlockVector max = region.getMaximumPoint();
        String c = "(" + min.getBlockX() + "," + min.getBlockY() + "," + min.getBlockZ() + ")";
        c = c + " (" + max.getBlockX() + "," + max.getBlockY() + "," + max.getBlockZ() + ")";
        sender.sendMessage(ChatColor.LIGHT_PURPLE + "\u0422\u043e\u0447\u043a\u0438: " + c);
    }

    @Command(aliases={"list"}, usage="[.player] [page] [world]", desc="Get a list of regions", max=3)
    public void list(CommandContext args, CommandSender sender) throws CommandException {
        int page = 0;
        int argl = 0;
        String name = "";
        boolean own = false;
        LocalPlayer localPlayer = null;
        if (args.argsLength() > 0 && args.getString(0).startsWith(".")) {
            name = args.getString(0).substring(1).toLowerCase();
            argl = 1;
            if (name.equals("me") || name.isEmpty() || name.equals(this.plugin.checkPlayer(sender).getDisplayName().toLowerCase())) {
                this.plugin.checkPermission(sender, "worldguard.region.list.own");
                name = this.plugin.checkPlayer(sender).getDisplayName().toLowerCase();
                localPlayer = this.plugin.wrapPlayer(this.plugin.checkPlayer(sender));
                own = true;
            }
        }
        if (!own) {
            this.plugin.checkPermission(sender, "worldguard.region.list");
        }
        if (args.argsLength() > argl) {
            page = Math.max(0, args.getInteger(argl) - 1);
        }
        World world = args.argsLength() > 1 + argl ? this.plugin.matchWorld(sender, args.getString(1 + argl)) : this.plugin.checkPlayer(sender).getWorld();
        int listSize = 10;
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
        Map<String, ProtectedRegion> regions = mgr.getRegions();
        int size = regions.size();
        Object[] regionIDList = new String[size];
        int index = 0;
        for (String id : regions.keySet()) {
            boolean show = false;
            String prefix = "";
            if (name.isEmpty()) {
                show = true;
            } else if (own) {
                if (regions.get(id).isOwner(localPlayer)) {
                    show = true;
                    prefix = prefix + "+";
                } else if (regions.get(id).isMember(localPlayer)) {
                    show = true;
                    prefix = prefix + "-";
                }
            } else {
                if (regions.get(id).getOwners().getPlayers().contains(name)) {
                    show = true;
                    prefix = prefix + "+";
                }
                if (regions.get(id).getMembers().getPlayers().contains(name)) {
                    show = true;
                    prefix = prefix + "-";
                }
            }
            if (!show) continue;
            regionIDList[index] = prefix + " " + id;
            ++index;
        }
        if (!name.isEmpty()) {
            regionIDList = (String[])Arrays.copyOf(regionIDList, index);
        }
        Arrays.sort(regionIDList);
        size = index;
        int pages = (int)Math.ceil((float)size / (float)listSize);
        sender.sendMessage(ChatColor.RED + (name.equals("") ? "\u0420\u0435\u0433\u0438\u043e\u043d\u044b (\u0441\u0442\u0440. " : "\u0420\u0435\u0433\u0438\u043e\u043d\u044b \u0434\u043b\u044f " + name + " (\u0441\u0442\u0440.") + (page + 1) + " of " + pages + "):");
        if (page < pages) {
            for (int i = page * listSize; i < page * listSize + listSize && i < size; ++i) {
                sender.sendMessage(ChatColor.YELLOW.toString() + (i + 1) + "." + (String)regionIDList[i]);
            }
        }
    }

    @Command(aliases={"flag", "f"}, usage="<id> <flag> [-g group] [value]", flags="g:", desc="Set flags", min=2)
    public void flag(CommandContext args, CommandSender sender) throws CommandException {
        RegionManager mgr;
        ProtectedRegion region;
        Player player = this.plugin.checkPlayer(sender);
        World world = player.getWorld();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        String id = args.getString(0);
        String flagName = args.getString(1);
        String value = null;
        if (args.argsLength() >= 3) {
            value = args.getJoinedStrings(2);
        }
        if ((region = (mgr = this.plugin.getGlobalRegionManager().get(world)).getRegion(id)) == null) {
            if (id.equalsIgnoreCase("__global__")) {
                region = new GlobalProtectedRegion(id);
                mgr.addRegion(region);
            } else {
                throw new CommandException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u044d\u0442\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c.");
            }
        }
        boolean hasPerm = false;
        if (region.isOwner(localPlayer)) {
            if (this.plugin.hasPermission(sender, "worldguard.region.flag.own." + id.toLowerCase())) {
                hasPerm = true;
            } else if (this.plugin.hasPermission(sender, "worldguard.region.flag.regions.own." + id.toLowerCase())) {
                hasPerm = true;
            }
        } else if (region.isMember(localPlayer)) {
            if (this.plugin.hasPermission(sender, "worldguard.region.flag.member." + id.toLowerCase())) {
                hasPerm = true;
            } else if (this.plugin.hasPermission(sender, "worldguard.region.flag.regions.member." + id.toLowerCase())) {
                hasPerm = true;
            }
        } else if (this.plugin.hasPermission(sender, "worldguard.region.flag." + id.toLowerCase())) {
            hasPerm = true;
        } else if (this.plugin.hasPermission(sender, "worldguard.region.flag.regions." + id.toLowerCase())) {
            hasPerm = true;
        }
        if (!hasPerm) {
            throw new CommandPermissionsException();
        }
        Flag<?> foundFlag = null;
        for (Flag<?> flag : DefaultFlag.getFlags()) {
            if (!flag.getName().replace("-", "").equalsIgnoreCase(flagName.replace("-", ""))) continue;
            foundFlag = flag;
            break;
        }
        if (foundFlag == null) {
            StringBuilder list = new StringBuilder();
            for (Flag<?> flag : DefaultFlag.getFlags()) {
                if (list.length() > 0) {
                    list.append(", ");
                }
                if (region.isOwner(localPlayer) ? !this.plugin.hasPermission(sender, "worldguard.region.flag.flags." + flag.getName() + ".owner." + id.toLowerCase()) && !this.plugin.hasPermission(sender, "worldguard.region.flag.flags." + flag.getName() + ".own." + id.toLowerCase()) : (region.isMember(localPlayer) ? !this.plugin.hasPermission(sender, "worldguard.region.flag.flags." + flag.getName() + ".member." + id.toLowerCase()) : !this.plugin.hasPermission(sender, "worldguard.region.flag.flags." + flag.getName() + "." + id.toLowerCase()))) continue;
                list.append(flag.getName());
            }
            player.sendMessage(ChatColor.RED + "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043b\u0430\u0433: " + flagName);
            player.sendMessage(ChatColor.RED + "\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0444\u043b\u0430\u0433\u0438: " + list);
            return;
        }
        if (region.isOwner(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.flag.flags." + foundFlag.getName() + ".owner." + id.toLowerCase());
        } else if (region.isMember(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.flag.flags." + foundFlag.getName() + ".member." + id.toLowerCase());
        } else {
            this.plugin.checkPermission(sender, "worldguard.region.flag.flags." + foundFlag.getName() + "." + id.toLowerCase());
        }
        if (args.hasFlag('g')) {
            String group = args.getFlag('g');
            if (foundFlag.getRegionGroupFlag() == null) {
                throw new CommandException("Region flag '" + foundFlag.getName() + "' does not have a group flag!");
            }
            try {
                this.setFlag(region, foundFlag.getRegionGroupFlag(), sender, group);
            }
            catch (InvalidFlagFormat e) {
                throw new CommandException(e.getMessage());
            }
            sender.sendMessage(ChatColor.YELLOW + "\u0413\u0440\u0443\u043f\u043f\u043e\u0432\u043e\u0439 \u0444\u043b\u0430\u0433 \u0434\u043b\u044f '" + foundFlag.getName() + "' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d.");
        } else if (value != null) {
            try {
                this.setFlag(region, foundFlag, sender, value);
            }
            catch (InvalidFlagFormat e) {
                throw new CommandException(e.getMessage());
            }
            sender.sendMessage(ChatColor.YELLOW + "Region flag '" + foundFlag.getName() + "' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d.");
        } else {
            region.setFlag(foundFlag, null);
            sender.sendMessage(ChatColor.YELLOW + "Region flag '" + foundFlag.getName() + "' \u043e\u0447\u0438\u0449\u0435\u043d.");
        }
        try {
            mgr.save();
        }
        catch (ProtectionDatabaseException e) {
            throw new CommandException("Failed to write regions: " + e.getMessage());
        }
    }

    public <V> void setFlag(ProtectedRegion region, Flag<V> flag, CommandSender sender, String value) throws InvalidFlagFormat {
        region.setFlag(flag, flag.parseInput(this.plugin, sender, value));
    }

    @Command(aliases={"setpriority", "priority", "pri"}, usage="<id> <priority>", desc="Set the priority of a region", min=2, max=2)
    public void setPriority(CommandContext args, CommandSender sender) throws CommandException {
        Player player = this.plugin.checkPlayer(sender);
        World world = player.getWorld();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        String id = args.getString(0);
        int priority = args.getInteger(1);
        if (id.equalsIgnoreCase("__global__")) {
            throw new CommandException("The region cannot be named __global__");
        }
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
        ProtectedRegion region = mgr.getRegion(id);
        if (region == null) {
            throw new CommandException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u044d\u0442\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c.");
        }
        if (region.isOwner(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.setpriority.own." + id.toLowerCase());
        } else if (region.isMember(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.setpriority.member." + id.toLowerCase());
        } else {
            this.plugin.checkPermission(sender, "worldguard.region.setpriority." + id.toLowerCase());
        }
        region.setPriority(priority);
        sender.sendMessage(ChatColor.YELLOW + "\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442 \u043e\u0442 '" + region.getId() + "' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043d\u0430 " + priority + ".");
        try {
            mgr.save();
        }
        catch (ProtectionDatabaseException e) {
            throw new CommandException("Failed to write regions: " + e.getMessage());
        }
    }

    @Command(aliases={"setparent", "parent", "par"}, usage="<id> [parent-id]", desc="Set the parent of a region", min=1, max=2)
    public void setParent(CommandContext args, CommandSender sender) throws CommandException {
        Player player = this.plugin.checkPlayer(sender);
        World world = player.getWorld();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        String id = args.getString(0);
        if (id.equalsIgnoreCase("__global__")) {
            throw new CommandException("The region cannot be named __global__");
        }
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
        ProtectedRegion region = mgr.getRegion(id);
        if (args.argsLength() == 1) {
            try {
                region.setParent(null);
            }
            catch (ProtectedRegion.CircularInheritanceException ignore) {
                // empty catch block
            }
            sender.sendMessage(ChatColor.YELLOW + "\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c \u043e\u0442 '" + region.getId() + "' \u043e\u0447\u0438\u0449\u0435\u043d.");
        } else {
            String parentId = args.getString(1);
            ProtectedRegion parent = mgr.getRegion(parentId);
            if (region == null) {
                throw new CommandException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u044d\u0442\u043e\u0442 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u044d\u0442\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c.");
            }
            if (parent == null) {
                throw new CommandException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c \u0441 \u044d\u0442\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c.");
            }
            if (region.isOwner(localPlayer)) {
                this.plugin.checkPermission(sender, "worldguard.region.setparent.own." + id.toLowerCase());
            } else if (region.isMember(localPlayer)) {
                this.plugin.checkPermission(sender, "worldguard.region.setparent.member." + id.toLowerCase());
            } else {
                this.plugin.checkPermission(sender, "worldguard.region.setparent." + id.toLowerCase());
            }
            if (parent.isOwner(localPlayer)) {
                this.plugin.checkPermission(sender, "worldguard.region.setparent.own." + id.toLowerCase());
            } else if (parent.isMember(localPlayer)) {
                this.plugin.checkPermission(sender, "worldguard.region.setparent.member." + id.toLowerCase());
            } else {
                this.plugin.checkPermission(sender, "worldguard.region.setparent." + id.toLowerCase());
            }
            try {
                region.setParent(parent);
            }
            catch (ProtectedRegion.CircularInheritanceException e) {
                throw new CommandException("Circular inheritance detected!");
            }
            sender.sendMessage(ChatColor.YELLOW + "\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c \u043e\u0442 '" + region.getId() + "' set to '" + parent.getId() + "'.");
        }
        try {
            mgr.save();
        }
        catch (ProtectionDatabaseException e) {
            throw new CommandException("Failed to write regions: " + e.getMessage());
        }
    }

    @Command(aliases={"remove", "delete", "del", "rem"}, usage="<id>", desc="Remove a region", min=1, max=1)
    public void remove(CommandContext args, CommandSender sender) throws CommandException {
        Player player = this.plugin.checkPlayer(sender);
        World world = player.getWorld();
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        String id = args.getString(0);
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
        ProtectedRegion region = mgr.getRegion(id);
        if (region == null) {
            throw new CommandException("\u041d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0433\u0438\u043e\u043d \u0441 \u044d\u0442\u0438\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c.");
        }
        if (region.isOwner(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.remove.own." + id.toLowerCase());
        } else if (region.isMember(localPlayer)) {
            this.plugin.checkPermission(sender, "worldguard.region.remove.member." + id.toLowerCase());
        } else {
            this.plugin.checkPermission(sender, "worldguard.region.remove." + id.toLowerCase());
        }
        mgr.removeRegion(id);
        sender.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0433\u0438\u043e\u043d '" + id + "' \u0443\u0434\u0430\u043b\u0435\u043d.");
        try {
            mgr.save();
        }
        catch (ProtectionDatabaseException e) {
            throw new CommandException("Failed to write regions: " + e.getMessage());
        }
    }

    @Command(aliases={"load", "reload"}, usage="[world]", desc="Reload regions from file", max=1)
    public void load(CommandContext args, CommandSender sender) throws CommandException {
        World world = null;
        if (args.argsLength() > 0) {
            world = this.plugin.matchWorld(sender, args.getString(0));
        }
        if (world != null) {
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            try {
                mgr.load();
                sender.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0433\u0438\u043e\u043d\u044b \u0434\u043b\u044f '" + world.getName() + "' \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b.");
            }
            catch (ProtectionDatabaseException e) {
                throw new CommandException("Failed to read regions: " + e.getMessage());
            }
        } else {
            for (World w : this.plugin.getServer().getWorlds()) {
                RegionManager mgr = this.plugin.getGlobalRegionManager().get(w);
                try {
                    mgr.load();
                }
                catch (ProtectionDatabaseException e) {
                    throw new CommandException("Failed to read regions: " + e.getMessage());
                }
            }
            sender.sendMessage(ChatColor.YELLOW + "Region databases loaded.");
        }
    }

    @Command(aliases={"save", "write"}, usage="[world]", desc="Re-save regions to file", max=1)
    public void save(CommandContext args, CommandSender sender) throws CommandException {
        World world = null;
        if (args.argsLength() > 0) {
            world = this.plugin.matchWorld(sender, args.getString(0));
        }
        if (world != null) {
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
            try {
                mgr.save();
                sender.sendMessage(ChatColor.YELLOW + "\u0420\u0435\u0433\u0438\u043e\u043d\u044b \u0434\u043b\u044f '" + world.getName() + "' \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u044b.");
            }
            catch (ProtectionDatabaseException e) {
                throw new CommandException("Failed to write regions: " + e.getMessage());
            }
        } else {
            for (World w : this.plugin.getServer().getWorlds()) {
                RegionManager mgr = this.plugin.getGlobalRegionManager().get(w);
                try {
                    mgr.save();
                }
                catch (ProtectionDatabaseException e) {
                    throw new CommandException("Failed to write regions: " + e.getMessage());
                }
            }
            sender.sendMessage(ChatColor.YELLOW + "Region databases saved.");
        }
    }

    @Command(aliases={"migratedb"}, usage="<from> <to>", desc="Migrate from one Protection Database to another.", min=1)
    @CommandPermissions(value={"worldguard.region.migratedb"})
    public void migratedb(CommandContext args, CommandSender sender) throws CommandException {
        MigratorKey key;
        String to;
        String from = args.getString(0).toLowerCase().trim();
        if (from.equals(to = args.getString(1).toLowerCase().trim())) {
            throw new CommandException("Will not migrate with common source and target.");
        }
        Map<MigratorKey, Class<? extends AbstractDatabaseMigrator>> migrators = AbstractDatabaseMigrator.getMigrators();
        if (!migrators.containsKey(key = new MigratorKey(from, to))) {
            throw new CommandException("No migrator found for that combination and direction.");
        }
        long lastRequest = 10000000L;
        if (this.migrateDBRequestDate != null) {
            lastRequest = new Date().getTime() - this.migrateDBRequestDate.getTime();
        }
        if (this.migrateDBRequest == null || lastRequest > 60000L) {
            this.migrateDBRequest = key;
            this.migrateDBRequestDate = new Date();
            throw new CommandException("This command is potentially dangerous.\nPlease ensure you have made a backup of your data, and then re-enter the command exactly to procede.");
        }
        Class<? extends AbstractDatabaseMigrator> cls = migrators.get(key);
        try {
            AbstractDatabaseMigrator migrator = cls.getConstructor(WorldGuardPlugin.class).newInstance(new Object[]{this.plugin});
            migrator.migrate();
        }
        catch (IllegalArgumentException ignore) {
        }
        catch (SecurityException ignore) {
        }
        catch (InstantiationException ignore) {
        }
        catch (IllegalAccessException ignore) {
        }
        catch (InvocationTargetException ignore) {
        }
        catch (NoSuchMethodException ignore) {
        }
        catch (MigrationException e) {
            throw new CommandException("Error migrating database: " + e.getMessage());
        }
        sender.sendMessage(ChatColor.YELLOW + "Regions have been migrated successfully.\n" + "If you wish to use the destination format as your new backend, please update your config and reload WorldGuard.");
    }
}

