/*
 * Decompiled with CFR 0.152.
 */
package com.steaks4uce.HerobrineUnleashed;

import com.steaks4uce.HerobrineUnleashed.PluginBlockListener;
import com.steaks4uce.HerobrineUnleashed.PluginEntityListener;
import com.steaks4uce.HerobrineUnleashed.PluginPlayerListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Template
extends JavaPlugin {
    private final PluginBlockListener blockListener = new PluginBlockListener(this);
    private final PluginPlayerListener playerListener = new PluginPlayerListener(this);
    private final PluginEntityListener entityListener = new PluginEntityListener(this);
    Logger log = Logger.getLogger("Minecraft");
    public static String mainDir = "plugins/HerobrineUnleashed";
    public static File config = new File(mainDir + File.separator + "config.properties");
    public static File folder = new File(mainDir);
    public static Properties prop = new Properties();
    public static String summonName;
    public static int randomspawnchance;
    public static int randomOutput;
    public static int createsignchance;
    public static int randombuildchance;
    public static int randomTorch;
    public static String summonedName;
    public static String signName;
    public static String builtName;
    public static String redstoneName;
    public static int buildingMaterial;
    public static Boolean canBuild;
    public static Boolean placeSigns;
    public static Boolean placeTorches;
    public static Boolean canRandomSpawn;
    public static Boolean canSummon;
    public static Boolean talkDeath;
    public static Boolean talkSpawn;
    public static int randomNoise;
    public static Boolean canNoise;
    public static String noisePlayer;
    public static int altarChance;
    public static Boolean replaceBlock;
    public static Boolean doStorm;
    public static Boolean changeTime;
    public static Boolean dropItem;
    public static int itemDrop;
    public static int itemDropAmount;
    public static Boolean hasGod;
    public static Boolean processActive;
    public static Boolean blockChat;
    public static int tunnelChance;
    public static Boolean canTunnel;
    public static String tunnelUser;
    public static Location diamondLoc;
    public static int tunnelItem;

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.log.info("[HerobrineUnleashed] HerobrineUnleashed " + pdfFile.getVersion() + " is disabled!");
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        if (!folder.exists()) {
            new File(mainDir).mkdir();
        }
        if (!config.exists()) {
            try {
                config.createNewFile();
                FileOutputStream out = new FileOutputStream(config);
                prop.put("randomspawn-chance", Integer.toString(25000));
                prop.put("createsign-chance", Integer.toString(13000));
                prop.put("randombuild-chance", Integer.toString(16000));
                prop.put("randomnoise-chance", Integer.toString(13000));
                prop.put("redstonetorch-chance", Integer.toString(13000));
                prop.put("altarspawn-chance", Integer.toString(25));
                prop.put("buildingtemple-material", Integer.toString(4));
                prop.put("canbuild-temples", Boolean.toString(canBuild));
                prop.put("canplace-signs", Boolean.toString(placeSigns));
                prop.put("canplace-torches", Boolean.toString(placeTorches));
                prop.put("canrandom-spawn", Boolean.toString(canRandomSpawn));
                prop.put("cansummonby-player", Boolean.toString(canSummon));
                prop.put("canmake-noises", Boolean.toString(canNoise));
                prop.put("removemossy-cobblestone", Boolean.toString(replaceBlock));
                prop.put("talkon-death", Boolean.toString(talkDeath));
                prop.put("talkon-spawn", Boolean.toString(talkSpawn));
                prop.put("stormon-summon", Boolean.toString(doStorm));
                prop.put("changetime-summon", Boolean.toString(changeTime));
                prop.put("dropitem-death", Boolean.toString(dropItem));
                prop.put("itemdrop-type", Integer.toString(itemDrop));
                prop.put("itemdrop-amount", Integer.toString(itemDropAmount));
                prop.put("hasunlimited-health", Boolean.toString(hasGod));
                prop.put("blockplayer-chat", Boolean.toString(blockChat));
                prop.put("cancreate-tunnels", Boolean.toString(canTunnel));
                prop.put("tunnelprize-block", Integer.toString(tunnelItem));
                prop.put("buildtunnel-chance", Integer.toString(tunnelChance));
                prop.store(out, "HerobrineUnleashed " + pdfFile.getVersion() + " Configuration");
                this.log.info("[HerobrineUnleashed] Configuration file has been created!");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.log.info("[HerobrineUnleashed] Failed to create configuration file!");
            }
        } else {
            try {
                FileInputStream in = new FileInputStream(config);
                prop.load(in);
                randomspawnchance = Integer.parseInt(prop.getProperty("randomspawn-chance").toString());
                createsignchance = Integer.parseInt(prop.getProperty("createsign-chance").toString());
                randombuildchance = Integer.parseInt(prop.getProperty("randombuild-chance").toString());
                randomTorch = Integer.parseInt(prop.getProperty("redstonetorch-chance").toString());
                randomNoise = Integer.parseInt(prop.getProperty("randomnoise-chance").toString());
                altarChance = Integer.parseInt(prop.getProperty("altarspawn-chance").toString());
                buildingMaterial = Integer.parseInt(prop.getProperty("buildingtemple-material").toString());
                canBuild = Boolean.valueOf(prop.getProperty("canbuild-temples"));
                placeSigns = Boolean.valueOf(prop.getProperty("canplace-signs"));
                placeTorches = Boolean.valueOf(prop.getProperty("canplace-torches"));
                canRandomSpawn = Boolean.valueOf(prop.getProperty("canrandom-spawn"));
                canSummon = Boolean.valueOf(prop.getProperty("cansummonby-player"));
                canNoise = Boolean.valueOf(prop.getProperty("canmake-noises"));
                replaceBlock = Boolean.valueOf(prop.getProperty("removemossy-cobblestone"));
                talkDeath = Boolean.valueOf(prop.getProperty("talkon-death"));
                talkSpawn = Boolean.valueOf(prop.getProperty("talkon-spawn"));
                doStorm = Boolean.valueOf(prop.getProperty("stormon-summon"));
                changeTime = Boolean.valueOf(prop.getProperty("changetime-summon"));
                dropItem = Boolean.valueOf(prop.getProperty("dropitem-death"));
                itemDrop = Integer.parseInt(prop.getProperty("itemdrop-type"));
                itemDropAmount = Integer.parseInt(prop.getProperty("itemdrop-amount"));
                hasGod = Boolean.valueOf(prop.getProperty("hasunlimited-health"));
                blockChat = Boolean.valueOf(prop.getProperty("blockplayer-chat"));
                canTunnel = Boolean.valueOf(prop.getProperty("cancreate-tunnels"));
                tunnelChance = Integer.parseInt(prop.getProperty("buildtunnel-chance"));
                tunnelItem = Integer.parseInt(prop.getProperty("tunnelprize-block"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.log.info("[HerobrineUnleashed] " + pdfFile.getName() + " " + pdfFile.getVersion() + " is enabled!");
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_MOVE, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_IGNITE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_DEATH, (Listener)this.entityListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.CREATURE_SPAWN, (Listener)this.entityListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_DAMAGE, (Listener)this.entityListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_CHAT, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
    }

    public void summonHerobrine() {
        if (talkSpawn.booleanValue()) {
            Player[] playerList;
            for (Player p : playerList = this.getServer().getOnlinePlayers()) {
                p.sendMessage("<Herobrine> \u0422\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u0433 \u0442\u0435\u0431\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u043c\u043e\u0447\u044c!");
            }
        }
        this.log.info("[HerobrineUnleashed] Herobrine was summoned by " + summonName + ".");
        summonName = "";
    }

    public void summonHerobrineFailed() {
        this.log.info("[HerobrineUnleashed] " + summonName + " tried to summon Herobrine.");
        summonName = "";
    }

    public void spawnHerobrine() {
        this.log.info("[HerobrineUnleashed] " + summonedName + " had Herobrine summon on them.");
        summonedName = "";
    }

    public void builtHouse() {
        this.log.info("[HerobrineUnleashed] " + builtName + " had a temple built.");
        builtName = "";
    }

    public void redstoneTorchSpawn() {
        this.log.info("[HerobrineUnleashed] " + redstoneName + " had a torch placed.");
        redstoneName = "";
    }

    public void spawnSign() {
        this.log.info("[HerobrineUnleashed] " + signName + " had a sign placed.");
        signName = "";
    }

    public void createNoise() {
        this.log.info("[HerobrineUnleashed] " + noisePlayer + " had a sound played.");
        noisePlayer = "";
    }

    public void onTunnel() {
        this.log.info("[HerobrineUnleashed] " + tunnelUser + " had a tunnel dug.");
        tunnelUser = "";
    }

    static {
        randomspawnchance = 25000;
        randomOutput = 0;
        createsignchance = 13000;
        randombuildchance = 16000;
        randomTorch = 13000;
        buildingMaterial = 4;
        canBuild = true;
        placeSigns = true;
        placeTorches = true;
        canRandomSpawn = true;
        canSummon = true;
        talkDeath = true;
        talkSpawn = true;
        randomNoise = 13000;
        canNoise = true;
        altarChance = 25;
        replaceBlock = true;
        doStorm = true;
        changeTime = true;
        dropItem = true;
        itemDrop = 322;
        itemDropAmount = 1;
        hasGod = false;
        processActive = false;
        blockChat = false;
        tunnelChance = 20000;
        canTunnel = true;
        tunnelItem = 56;
    }
}

