/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.myhome;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import me.taylorkelly.myhome.Home;
import me.taylorkelly.myhome.HomePermissions;
import me.taylorkelly.myhome.HomeSettings;
import me.taylorkelly.myhome.MatchList;
import me.taylorkelly.myhome.MyHome;
import me.taylorkelly.myhome.WarpDataSource;
import me.taylorkelly.myhome.timers.CoolDown;
import me.taylorkelly.myhome.timers.WarmUp;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class HomeList {
    private HashMap<String, Home> homeList;
    private Server server;

    public HomeList(Server server) {
        this.server = server;
        WarpDataSource.initialize();
        this.homeList = WarpDataSource.getMap();
    }

    public void addHome(Player player) {
        if (this.homeList.containsKey(player.getName())) {
            Home warp = this.homeList.get(player.getName());
            warp.setLocation(player.getLocation());
            WarpDataSource.moveWarp(warp);
            player.sendMessage(ChatColor.AQUA + "Welcome to your new home :).");
        } else {
            Home warp = new Home(player);
            this.homeList.put(player.getName(), warp);
            WarpDataSource.addWarp(warp);
            player.sendMessage(ChatColor.AQUA + "Successfully created your home");
            if (HomePermissions.invite(player)) {
                player.sendMessage("If you'd like to invite friends to it,");
                player.sendMessage("Use: " + ChatColor.RED + "/home invite <player>");
            }
        }
        MyHome.setCompass(player, player.getLocation());
    }

    public void blindAdd(Home warp) {
        this.homeList.put(warp.name, warp);
    }

    public void warpTo(String name, Player player, Plugin plugin) {
        MatchList matches = this.getMatches(name, player);
        if (this.homeList.containsKey(name = matches.getMatch(name))) {
            Home warp = this.homeList.get(name);
            if (warp.playerCanWarp(player)) {
                if (CoolDown.playerHasCooled(player)) {
                    WarmUp.addPlayer(player, warp, plugin);
                    CoolDown.addPlayer(player, plugin);
                } else {
                    player.sendMessage(ChatColor.RED + "You need to wait for the cooldown of " + HomeSettings.coolDown + " secs");
                }
            } else {
                player.sendMessage(ChatColor.RED + "You do not have permission to warp to " + name + "'s home");
            }
        } else {
            player.sendMessage(ChatColor.RED + name + " doesn't have a home :(");
        }
    }

    public void sendPlayerHome(Player player, Plugin plugin) {
        if (this.homeList.containsKey(player.getName())) {
            if (CoolDown.playerHasCooled(player)) {
                WarmUp.addPlayer(player, this.homeList.get(player.getName()), plugin);
                CoolDown.addPlayer(player, plugin);
            } else {
                player.sendMessage(ChatColor.RED + "You need to wait for the cooldown of " + HomeSettings.coolDown + " secs");
            }
        }
    }

    public boolean playerHasHome(Player player) {
        return this.homeList.containsKey(player.getName());
    }

    public void deleteHome(Player player) {
        if (this.homeList.containsKey(player.getName())) {
            Home warp = this.homeList.get(player.getName());
            this.homeList.remove(player.getName());
            WarpDataSource.deleteWarp(warp);
            player.sendMessage(ChatColor.AQUA + "You have deleted your home");
        } else {
            player.sendMessage(ChatColor.RED + "You have no home to delete :(");
        }
    }

    public void privatize(Player player) {
        if (this.homeList.containsKey(player.getName())) {
            Home warp = this.homeList.get(player.getName());
            warp.publicAll = false;
            WarpDataSource.publicizeWarp(warp, false);
            player.sendMessage(ChatColor.AQUA + "You have privatized your home");
            if (HomePermissions.invite(player)) {
                player.sendMessage("If you'd like to invite others to it,");
                player.sendMessage("Use: " + ChatColor.RED + "/home invite <player>");
            }
        } else {
            player.sendMessage(ChatColor.RED + "You have no home to privatize :(");
        }
    }

    public void publicize(Player player) {
        if (this.homeList.containsKey(player.getName())) {
            Home warp = this.homeList.get(player.getName());
            warp.publicAll = true;
            WarpDataSource.publicizeWarp(warp, true);
            player.sendMessage(ChatColor.AQUA + "You have publicized your home.");
        } else {
            player.sendMessage(ChatColor.RED + "You have no home to publicize :(");
        }
    }

    public void invite(Player player, String inviteeName) {
        if (this.homeList.containsKey(player.getName())) {
            Home warp = this.homeList.get(player.getName());
            if (warp.playerIsInvited(inviteeName)) {
                player.sendMessage(ChatColor.RED + inviteeName + " is already invited to your home.");
            } else if (warp.playerIsCreator(inviteeName)) {
                player.sendMessage(ChatColor.RED + "This is your home!");
            } else {
                Player match;
                warp.invite(inviteeName);
                WarpDataSource.updatePermissions(warp);
                player.sendMessage(ChatColor.AQUA + "You have invited " + inviteeName + " to your home");
                if (warp.publicAll) {
                    player.sendMessage(ChatColor.RED + "But your home is still public!");
                }
                if ((match = this.server.getPlayer(inviteeName)) != null) {
                    match.sendMessage(ChatColor.AQUA + "You've been invited to " + player.getName() + "'s home");
                    match.sendMessage("Use: " + ChatColor.RED + "/home " + player.getName() + ChatColor.WHITE + " to warp to it.");
                }
            }
        } else {
            player.sendMessage(ChatColor.RED + "You have no home to invite people to :(");
        }
    }

    public void uninvite(Player player, String inviteeName) {
        if (this.homeList.containsKey(player.getName())) {
            Home warp = this.homeList.get(player.getName());
            if (!warp.playerIsInvited(inviteeName)) {
                player.sendMessage(ChatColor.RED + inviteeName + " is not invited to your home.");
            } else if (warp.playerIsCreator(inviteeName)) {
                player.sendMessage(ChatColor.RED + "Why would you want to uninivite yourself?");
            } else {
                Player match;
                warp.uninvite(inviteeName);
                WarpDataSource.updatePermissions(warp);
                player.sendMessage(ChatColor.AQUA + "You have uninvited " + inviteeName + " from your home");
                if (warp.publicAll) {
                    player.sendMessage(ChatColor.RED + "But your home is still public.");
                }
                if ((match = this.server.getPlayer(inviteeName)) != null) {
                    match.sendMessage(ChatColor.RED + "You've been uninvited to " + player.getName() + "'s home. Sorry.");
                }
            }
        } else {
            player.sendMessage(ChatColor.RED + "You have no home to uninvite people from :(");
        }
    }

    public boolean homeExists(String name) {
        return this.homeList.containsKey(name);
    }

    public void list(Player player) {
        ArrayList<Home> results = this.homesInvitedTo(player);
        if (results.size() == 0) {
            player.sendMessage(ChatColor.RED + "You are invited to no one's home.");
        } else {
            player.sendMessage(ChatColor.AQUA + "You are invited to the homes of:");
            player.sendMessage(results.toString().replace("[", "").replace("]", ""));
        }
    }

    public void ilist(Player player) {
        if (this.homeList.containsKey(player.getName())) {
            Home warp = this.homeList.get(player.getName());
            if (warp.permissions.size() == 0) {
                player.sendMessage(ChatColor.AQUA + "No one is invited to your house");
            } else {
                player.sendMessage(ChatColor.AQUA + warp.invitees() + " invited to your house");
            }
        } else {
            player.sendMessage(ChatColor.RED + "You have no home :(");
        }
    }

    private ArrayList<Home> homesInvitedTo(Player player) {
        ArrayList<Home> results = new ArrayList<Home>();
        for (Home home : this.homeList.values()) {
            if (!home.playerCanWarp(player) || home.playerIsCreator(player.getName())) continue;
            results.add(home);
        }
        return results;
    }

    public void orientPlayer(Player player) {
        if (this.playerHasHome(player)) {
            Home home = this.homeList.get(player.getName());
            World world = player.getWorld();
            Location location = new Location(world, home.x, (double)home.y, home.z);
            MyHome.setCompass(player, location);
        }
    }

    public MatchList getMatches(String name, Player player) {
        ArrayList<Home> exactMatches = new ArrayList<Home>();
        ArrayList<Home> matches = new ArrayList<Home>();
        ArrayList<String> names = new ArrayList<String>(this.homeList.keySet());
        Collator collator = Collator.getInstance();
        collator.setStrength(1);
        Collections.sort(names, collator);
        for (int i = 0; i < names.size(); ++i) {
            String currName = (String)names.get(i);
            Home warp = this.homeList.get(currName);
            if (!warp.playerCanWarp(player)) continue;
            if (warp.name.equalsIgnoreCase(name)) {
                exactMatches.add(warp);
                continue;
            }
            if (!warp.name.toLowerCase().contains(name.toLowerCase())) continue;
            matches.add(warp);
        }
        if (exactMatches.size() > 1) {
            for (Home warp : exactMatches) {
                if (warp.name.equals(name)) continue;
                exactMatches.remove(warp);
                matches.add(0, warp);
            }
        }
        return new MatchList(exactMatches, matches);
    }

    public Home getHomeFor(Player player) {
        return this.homeList.get(player.getName());
    }
}

