/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.myhome;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import me.taylorkelly.myhome.ConnectionManager;
import me.taylorkelly.myhome.Converter;
import me.taylorkelly.myhome.HomeHelp;
import me.taylorkelly.myhome.HomeList;
import me.taylorkelly.myhome.HomeLogger;
import me.taylorkelly.myhome.HomePermissions;
import me.taylorkelly.myhome.HomeSettings;
import me.taylorkelly.myhome.MHPlayerListener;
import me.taylorkelly.myhome.griefcraft.Updater;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MyHome
extends JavaPlugin {
    private MHPlayerListener playerListener;
    private HomeList homeList;
    private boolean warning = false;
    public String name;
    public String version;
    private Updater updater;

    public void onDisable() {
        ConnectionManager.closeConnection();
    }

    public void onEnable() {
        Connection conn;
        this.name = this.getDescription().getName();
        this.version = this.getDescription().getVersion();
        HomeSettings.initialize(this.getDataFolder());
        this.updater = new Updater();
        try {
            this.updater.check();
            this.updater.update();
        }
        catch (Exception e) {
            // empty catch block
        }
        File newDatabase = new File(this.getDataFolder(), "homes.db");
        File oldDatabase = new File("homes-warps.db");
        if (!newDatabase.exists() && oldDatabase.exists()) {
            this.updateFiles(oldDatabase, newDatabase);
        }
        if ((conn = ConnectionManager.initialize(this.getDataFolder())) == null) {
            HomeLogger.severe("Could not establish SQL connection. Disabling MyHome");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.homeList = new HomeList(this.getServer());
        this.playerListener = new MHPlayerListener(this.homeList, this.getServer());
        HomePermissions.initialize(this.getServer());
        HomeHelp.initialize((Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_RESPAWN, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        HomeLogger.info(this.name + " " + this.version + " enabled");
    }

    private void updateFiles(File oldDatabase, File newDatabase) {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (newDatabase.exists()) {
            newDatabase.delete();
        }
        try {
            newDatabase.createNewFile();
        }
        catch (IOException ex) {
            HomeLogger.severe("Could not create new database file", ex);
        }
        MyHome.copyFile(oldDatabase, newDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File fromFile, File toFile) {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {}
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String[] split = args;
        String commandName = command.getName().toLowerCase();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (commandName.equals("home")) {
                if (split.length == 0 && HomePermissions.home(player)) {
                    if (this.homeList.playerHasHome(player)) {
                        this.homeList.sendPlayerHome(player, (Plugin)this);
                    } else {
                        player.sendMessage(ChatColor.RED + "You have no home :(");
                        player.sendMessage("Use: " + ChatColor.RED + "/home set" + ChatColor.WHITE + " to set a home");
                    }
                } else if (split.length == 1 && split[0].equalsIgnoreCase("convert") && HomePermissions.isAdmin(player)) {
                    if (!this.warning) {
                        player.sendMessage(ChatColor.RED + "Warning: " + ChatColor.WHITE + "Only use a copy of homes.txt.");
                        player.sendMessage("This will delete the homes.txt it uses");
                        player.sendMessage("Use " + ChatColor.RED + "'/home convert'" + ChatColor.WHITE + " again to confirm.");
                        this.warning = true;
                    } else {
                        Converter.convert(player, this.getServer(), this.homeList);
                        this.warning = false;
                    }
                } else if (split.length == 1 && split[0].equalsIgnoreCase("set") && HomePermissions.set(player)) {
                    this.homeList.addHome(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("delete") && HomePermissions.delete(player)) {
                    this.homeList.deleteHome(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("list") && HomePermissions.list(player)) {
                    this.homeList.list(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("ilist") && HomePermissions.list(player)) {
                    this.homeList.ilist(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("private") && HomePermissions.canPrivate(player)) {
                    this.homeList.privatize(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("public") && HomePermissions.canPublic(player)) {
                    this.homeList.publicize(player);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("point") && HomeSettings.compassPointer) {
                    this.homeList.orientPlayer(player);
                } else if (split.length == 2 && split[0].equalsIgnoreCase("invite") && HomePermissions.invite(player)) {
                    Player invitee = this.getServer().getPlayer(split[1]);
                    String inviteeName = invitee == null ? split[1] : invitee.getName();
                    this.homeList.invite(player, inviteeName);
                } else if (split.length == 2 && split[0].equalsIgnoreCase("uninvite") && HomePermissions.uninvite(player)) {
                    Player invitee = this.getServer().getPlayer(split[1]);
                    String inviteeName = invitee == null ? split[1] : invitee.getName();
                    this.homeList.uninvite(player, inviteeName);
                } else if (split.length == 1 && split[0].equalsIgnoreCase("help")) {
                    ArrayList<String> messages = new ArrayList<String>();
                    messages.add(ChatColor.RED + "-------------------- " + ChatColor.WHITE + "/HOME HELP" + ChatColor.RED + " --------------------");
                    if (HomePermissions.home(player)) {
                        messages.add(ChatColor.RED + "/home" + ChatColor.WHITE + "  -  Go home young chap!");
                    }
                    if (HomePermissions.set(player)) {
                        messages.add(ChatColor.RED + "/home set" + ChatColor.WHITE + "  -  Sets your home to your current position");
                    }
                    if (HomePermissions.delete(player)) {
                        messages.add(ChatColor.RED + "/home delete" + ChatColor.WHITE + "  -  Deletes your current home");
                    }
                    if (HomePermissions.homeOthers(player)) {
                        messages.add(ChatColor.RED + "/home [player]" + ChatColor.WHITE + "  -  Go to " + ChatColor.GRAY + "[player]" + ChatColor.WHITE + "'s house (if allowed)");
                    }
                    if (HomePermissions.list(player)) {
                        messages.add(ChatColor.RED + "/home list" + ChatColor.WHITE + "  -  List the homes that you are invited to");
                        messages.add(ChatColor.RED + "/home ilist" + ChatColor.WHITE + "  -  List the people invited to your home");
                    }
                    if (HomePermissions.invite(player)) {
                        messages.add(ChatColor.RED + "/home invite [player]" + ChatColor.WHITE + "  -  Invite " + ChatColor.GRAY + "[player]" + ChatColor.WHITE + " to your house");
                    }
                    if (HomePermissions.uninvite(player)) {
                        messages.add(ChatColor.RED + "/home uninvite [player]" + ChatColor.WHITE + "  -  Uninvite " + ChatColor.GRAY + "[player]" + ChatColor.WHITE + " to your house");
                    }
                    if (HomePermissions.canPublic(player)) {
                        messages.add(ChatColor.RED + "/home public" + ChatColor.WHITE + "  -  Makes your house public");
                    }
                    if (HomePermissions.canPrivate(player)) {
                        messages.add(ChatColor.RED + "/home private" + ChatColor.WHITE + "  -  Makes your house private");
                    }
                    if (HomeSettings.compassPointer) {
                        messages.add(ChatColor.RED + "/home point" + ChatColor.WHITE + "  -  Points your compass home");
                    }
                    for (String message : messages) {
                        player.sendMessage(message);
                    }
                } else if (split.length == 1 && HomePermissions.homeOthers(player)) {
                    String playerName = split[0];
                    this.homeList.warpTo(playerName, player, (Plugin)this);
                } else {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static void setCompass(Player player, Location location) {
        if (HomeSettings.compassPointer) {
            player.setCompassTarget(location);
        }
    }
}

