/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.myhome.griefcraft;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import me.taylorkelly.myhome.griefcraft.UpdaterFile;

public class Updater {
    private Logger logger = Logger.getLogger("Minecraft");
    private static final String UPDATE_SITE = "http://stethoscopesmp.com/tkelly/";
    private List<UpdaterFile> needsUpdating = new ArrayList<UpdaterFile>();

    public void check() {
        String[] paths;
        for (String path : paths = new String[]{"lib/sqlite.jar", "lib/" + this.getOSSpecificFileName()}) {
            File file = new File(path);
            if (file == null || file.exists() || file.isDirectory()) continue;
            UpdaterFile updaterFile = new UpdaterFile(UPDATE_SITE + path);
            updaterFile.setLocalLocation(path);
            this.needsUpdating.add(updaterFile);
        }
    }

    public String getOSSpecificFileName() {
        String osname = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch");
        if (osname.contains("windows")) {
            osname = "win";
            arch = "x86";
        } else if (osname.contains("mac")) {
            osname = "mac";
            arch = "universal";
        } else if (osname.contains("nix")) {
            osname = "linux";
        } else if (osname.equals("sunos")) {
            osname = "linux";
        }
        if (arch.startsWith("i") && arch.endsWith("86")) {
            arch = "x86";
        }
        return osname + "-" + arch + ".lib";
    }

    public void update() throws Exception {
        if (this.needsUpdating.size() == 0) {
            return;
        }
        File folder = new File("lib");
        if (folder.exists() && !folder.isDirectory()) {
            throw new Exception("Folder \"lib\" cannot be created ! It is a file!");
        }
        if (!folder.exists()) {
            this.logger.info("Creating folder : lib");
            folder.mkdir();
        }
        this.logger.info("Need to download " + this.needsUpdating.size() + " object(s)");
        Iterator<UpdaterFile> iterator = this.needsUpdating.iterator();
        while (iterator.hasNext()) {
            UpdaterFile item = iterator.next();
            this.logger.info(" - Downloading file : " + item.getRemoteLocation());
            URL url = new URL(item.getRemoteLocation());
            File file = new File(item.getLocalLocation());
            if (file.exists()) {
                file.delete();
            }
            InputStream inputStream = url.openStream();
            FileOutputStream outputStream = new FileOutputStream(file);
            this.saveTo(inputStream, outputStream);
            inputStream.close();
            ((OutputStream)outputStream).close();
            this.logger.info("  + Download complete");
            iterator.remove();
        }
    }

    private void saveTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
    }
}

