/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class ArenaClass {
    private String configName;
    private String lowercaseName;
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    private List<ItemStack> items;
    private List<ItemStack> armor;
    private Map<String, Boolean> perms;
    private int pets;
    private static int[] weaponTypes = new int[]{256, 257, 258, 261, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 283, 284, 285, 286, 290, 291, 292, 293, 294};

    public ArenaClass(String name) {
        this.configName = name;
        this.lowercaseName = name.toLowerCase();
        this.items = new ArrayList<ItemStack>();
        this.armor = new ArrayList<ItemStack>(4);
        this.perms = new HashMap<String, Boolean>();
        this.pets = 0;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getLowercaseName() {
        return this.lowercaseName;
    }

    public Material getLogo() {
        if (this.items.isEmpty()) {
            return Material.STONE;
        }
        return this.items.get(0).getType();
    }

    public void setHelmet(ItemStack helmet) {
        this.helmet = helmet;
    }

    public void setChestplate(ItemStack chestplate) {
        this.chestplate = chestplate;
    }

    public void setLeggings(ItemStack leggings) {
        this.leggings = leggings;
    }

    public void setBoots(ItemStack boots) {
        this.boots = boots;
    }

    public void addItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (this.isWeapon(stack)) {
            stack.setDurability((short)Short.MIN_VALUE);
        } else if (stack.getType() == Material.BONE) {
            this.pets += stack.getAmount();
        } else if (stack.getAmount() > 64) {
            while (stack.getAmount() > 64) {
                this.items.add(new ItemStack(stack.getType(), 64));
                stack.setAmount(stack.getAmount() - 64);
            }
        }
        this.items.add(stack);
    }

    public void setItems(List<ItemStack> stacks) {
        this.items = new ArrayList<ItemStack>(stacks.size());
        for (ItemStack stack : stacks) {
            this.addItem(stack);
        }
    }

    public void setArmor(List<ItemStack> armor) {
        this.armor = armor;
    }

    public void grantItems(Player p) {
        PlayerInventory inv = p.getInventory();
        for (ItemStack stack : this.items) {
            inv.addItem(new ItemStack[]{stack});
        }
        if (!this.armor.isEmpty()) {
            for (ItemStack piece : this.armor) {
                ArmorType type = ArmorType.getType(piece);
                if (type == null) continue;
                switch (type) {
                    case HELMET: {
                        inv.setHelmet(piece);
                        break;
                    }
                    case CHESTPLATE: {
                        inv.setChestplate(piece);
                        break;
                    }
                    case LEGGINGS: {
                        inv.setLeggings(piece);
                        break;
                    }
                    case BOOTS: {
                        inv.setBoots(piece);
                        break;
                    }
                }
            }
        }
        if (this.helmet != null) {
            inv.setHelmet(this.helmet);
        }
        if (this.chestplate != null) {
            inv.setChestplate(this.chestplate);
        }
        if (this.leggings != null) {
            inv.setLeggings(this.leggings);
        }
        if (this.boots != null) {
            inv.setBoots(this.boots);
        }
    }

    public void addPermission(String perm, boolean value) {
        this.perms.put(perm, value);
    }

    public Map<String, Boolean> getPermissions() {
        return Collections.unmodifiableMap(this.perms);
    }

    public PermissionAttachment grantPermissions(MobArena plugin, Player p) {
        if (this.perms.isEmpty()) {
            return null;
        }
        PermissionAttachment pa = p.addAttachment((Plugin)plugin);
        for (Map.Entry<String, Boolean> entry : this.perms.entrySet()) {
            try {
                pa.setPermission(entry.getKey(), entry.getValue().booleanValue());
            }
            catch (Exception e) {
                String perm = entry.getKey() + ":" + entry.getValue();
                String player = p.getName();
                Messenger.warning("[PERM00] Failed to attach permission '" + perm + "' to player '" + player + " with class " + this.configName + "'.\nPlease verify that your class permissions are well-formed.");
            }
        }
        return pa;
    }

    public int getPetAmount() {
        return this.pets;
    }

    private boolean isWeapon(ItemStack stack) {
        int id = stack.getTypeId();
        for (int type : weaponTypes) {
            if (id != type) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ArenaClass other = (ArenaClass)o;
        return other.lowercaseName.equals(this.lowercaseName);
    }

    public int hashCode() {
        return this.lowercaseName.hashCode();
    }

    public static enum ArmorType {
        HELMET(298, 302, 306, 310, 314),
        CHESTPLATE(299, 303, 307, 311, 315),
        LEGGINGS(300, 304, 308, 312, 316),
        BOOTS(301, 305, 309, 313, 317);

        private int[] types;

        private ArmorType(int ... types) {
            this.types = types;
        }

        public static ArmorType getType(ItemStack stack) {
            int id = stack.getTypeId();
            for (ArmorType armorType : ArmorType.values()) {
                for (int type : armorType.types) {
                    if (id != type) continue;
                    return armorType;
                }
            }
            return null;
        }
    }
}

