/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.ArenaListener;
import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.ClassLimitManager;
import com.garbagemule.MobArena.MASpawnThread;
import com.garbagemule.MobArena.MAUtils;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.MonsterManager;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.PlayerData;
import com.garbagemule.MobArena.RewardManager;
import com.garbagemule.MobArena.events.ArenaEndEvent;
import com.garbagemule.MobArena.events.ArenaPlayerDeathEvent;
import com.garbagemule.MobArena.events.ArenaPlayerJoinEvent;
import com.garbagemule.MobArena.events.ArenaPlayerLeaveEvent;
import com.garbagemule.MobArena.events.ArenaStartEvent;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.leaderboards.Leaderboard;
import com.garbagemule.MobArena.log.ArenaLog;
import com.garbagemule.MobArena.log.LogSessionBuilder;
import com.garbagemule.MobArena.log.LogTotalsBuilder;
import com.garbagemule.MobArena.log.YMLSessionBuilder;
import com.garbagemule.MobArena.log.YMLTotalsBuilder;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.repairable.Repairable;
import com.garbagemule.MobArena.repairable.RepairableComparator;
import com.garbagemule.MobArena.repairable.RepairableContainer;
import com.garbagemule.MobArena.spout.Spouty;
import com.garbagemule.MobArena.time.Time;
import com.garbagemule.MobArena.time.TimeStrategy;
import com.garbagemule.MobArena.time.TimeStrategyLocked;
import com.garbagemule.MobArena.time.TimeStrategyNull;
import com.garbagemule.MobArena.util.Delays;
import com.garbagemule.MobArena.util.Enums;
import com.garbagemule.MobArena.util.ItemParser;
import com.garbagemule.MobArena.util.TextUtils;
import com.garbagemule.MobArena.util.config.Config;
import com.garbagemule.MobArena.util.config.ConfigSection;
import com.garbagemule.MobArena.util.inventory.InventoryManager;
import com.garbagemule.MobArena.util.inventory.InventoryUtils;
import com.garbagemule.MobArena.waves.SheepBouncer;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.WaveManager;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class ArenaImpl
implements Arena {
    private MobArena plugin;
    private String name;
    private World world;
    private File dir;
    private ConfigSection settings;
    private boolean enabled;
    private boolean protect;
    private boolean running;
    private boolean edit;
    private boolean allowMonsters;
    private boolean allowAnimals;
    private ArenaRegion region;
    private Leaderboard leaderboard;
    private InventoryManager inventoryManager;
    private RewardManager rewardManager;
    private ClassLimitManager limitManager;
    private Map<Player, ArenaPlayer> arenaPlayerMap;
    private Map<Player, PlayerData> playerData = new HashMap<Player, PlayerData>();
    private Set<Player> arenaPlayers;
    private Set<Player> lobbyPlayers;
    private Set<Player> readyPlayers;
    private Set<Player> specPlayers;
    private Set<Player> deadPlayers;
    private Set<Player> randoms;
    private Map<String, ArenaClass> classes;
    private Map<Player, PermissionAttachment> attachments;
    private PriorityBlockingQueue<Repairable> repairQueue;
    private Set<Block> blocks;
    private LinkedList<Repairable> repairables;
    private LinkedList<Repairable> containables;
    private MonsterManager monsterManager;
    private WaveManager waveManager;
    private Wave currentWave;
    private MASpawnThread spawnThread;
    private SheepBouncer sheepBouncer;
    private Map<Integer, List<ItemStack>> everyWaveMap;
    private Map<Integer, List<ItemStack>> afterWaveMap;
    private boolean logging;
    private ArenaLog log;
    private LogSessionBuilder sessionBuilder;
    private LogTotalsBuilder totalsBuilder;
    private ArenaListener eventListener;
    private List<ItemStack> entryFee;
    private TimeStrategy timeStrategy;

    public ArenaImpl(MobArena plugin, Config config, String name, World world) {
        if (world == null) {
            throw new NullPointerException("[MobArena] ERROR! World for arena '" + name + "' does not exist!");
        }
        this.name = name;
        this.world = world;
        this.plugin = plugin;
        this.settings = new ConfigSection(config, "arenas." + name + ".settings");
        this.region = new ArenaRegion(new ConfigSection(config, "arenas." + name + ".coords"), this);
        this.enabled = this.settings.getBoolean("enabled", false);
        this.protect = this.settings.getBoolean("protect", true);
        this.logging = this.settings.getBoolean("logging", true);
        this.running = false;
        this.edit = false;
        this.inventoryManager = new InventoryManager(this);
        this.rewardManager = new RewardManager(this);
        this.leaderboard = new Leaderboard(plugin, this, this.region.getLeaderboard());
        this.arenaPlayerMap = new HashMap<Player, ArenaPlayer>();
        this.arenaPlayers = new HashSet<Player>();
        this.lobbyPlayers = new HashSet<Player>();
        this.readyPlayers = new HashSet<Player>();
        this.specPlayers = new HashSet<Player>();
        this.deadPlayers = new HashSet<Player>();
        this.randoms = new HashSet<Player>();
        this.classes = plugin.getArenaMaster().getClasses();
        this.attachments = new HashMap<Player, PermissionAttachment>();
        this.limitManager = new ClassLimitManager(this, this.classes, new ConfigSection(config, "arenas." + name + ".class-limits"));
        this.repairQueue = new PriorityBlockingQueue<Repairable>(100, new RepairableComparator());
        this.blocks = new HashSet<Block>();
        this.repairables = new LinkedList();
        this.containables = new LinkedList();
        this.monsterManager = new MonsterManager();
        this.waveManager = new WaveManager(this, config);
        this.everyWaveMap = MAUtils.getArenaRewardMap(plugin, config, name, "every");
        this.afterWaveMap = MAUtils.getArenaRewardMap(plugin, config, name, "after");
        this.eventListener = new ArenaListener(this, plugin);
        this.entryFee = ItemParser.parseItems(this.settings.getString("entry-fee", ""));
        this.allowMonsters = world.getAllowMonsters();
        this.allowAnimals = world.getAllowAnimals();
        String timeString = this.settings.getString("player-time-in-arena", "world");
        Time time = Enums.getEnumFromString(Time.class, timeString);
        TimeStrategy timeStrategy = this.timeStrategy = time != null ? new TimeStrategyLocked(time) : new TimeStrategyNull();
        if (this.logging) {
            this.dir = new File(plugin.getDataFolder() + File.separator + "arenas" + File.separator + name);
            this.sessionBuilder = new YMLSessionBuilder(new File(this.dir, "log_session.yml"));
            this.totalsBuilder = new YMLTotalsBuilder(new File(this.dir, "log_totals.yml"));
            this.log = new ArenaLog(this, this.sessionBuilder, this.totalsBuilder);
        }
    }

    @Override
    public ConfigSection getSettings() {
        return this.settings;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
        this.settings.set("enabled", this.enabled);
    }

    @Override
    public boolean isProtected() {
        return this.protect;
    }

    @Override
    public void setProtected(boolean value) {
        this.protect = value;
        this.settings.set("protect", this.protect);
    }

    @Override
    public boolean isLogging() {
        return this.logging;
    }

    @Override
    public void setLogging(boolean value) {
        this.logging = value;
        this.settings.set("logging", this.logging);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean inEditMode() {
        return this.edit;
    }

    @Override
    public void setEditMode(boolean value) {
        this.edit = value;
    }

    private int getMinPlayers() {
        return this.settings.getInt("min-players");
    }

    private int getMaxPlayers() {
        return this.settings.getInt("max-players");
    }

    private int getJoinDistance() {
        return this.settings.getInt("max-join-distance");
    }

    @Override
    public Material getClassLogo(String classname) {
        ArenaClass arenaClass = this.classes.get(classname);
        if (arenaClass == null) {
            return Material.STONE;
        }
        return arenaClass.getLogo();
    }

    @Override
    public List<ItemStack> getEntryFee() {
        return this.entryFee;
    }

    @Override
    public Set<Map.Entry<Integer, List<ItemStack>>> getEveryWaveEntrySet() {
        return this.everyWaveMap.entrySet();
    }

    @Override
    public List<ItemStack> getAfterWaveReward(int wave) {
        return this.afterWaveMap.get(wave);
    }

    @Override
    public Set<Player> getPlayersInArena() {
        return Collections.unmodifiableSet(this.arenaPlayers);
    }

    @Override
    public Set<Player> getPlayersInLobby() {
        return Collections.unmodifiableSet(this.lobbyPlayers);
    }

    @Override
    public Set<Player> getReadyPlayersInLobby() {
        return Collections.unmodifiableSet(this.readyPlayers);
    }

    @Override
    public Set<Player> getSpectators() {
        return Collections.unmodifiableSet(this.specPlayers);
    }

    @Override
    public MASpawnThread getSpawnThread() {
        return this.spawnThread;
    }

    @Override
    public WaveManager getWaveManager() {
        return this.waveManager;
    }

    @Override
    public Location getPlayerEntry(Player p) {
        PlayerData mp = this.playerData.get(p);
        return mp != null ? mp.entry() : null;
    }

    @Override
    public ArenaListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public void setLeaderboard(Leaderboard leaderboard) {
        this.leaderboard = leaderboard;
    }

    @Override
    public ArenaPlayer getArenaPlayer(Player p) {
        return this.arenaPlayerMap.get(p);
    }

    @Override
    public Set<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    public void addBlock(Block b) {
        this.blocks.add(b);
    }

    @Override
    public boolean removeBlock(Block b) {
        return this.blocks.remove(b);
    }

    @Override
    public boolean hasPet(Entity e) {
        return this.monsterManager.hasPet(e);
    }

    @Override
    public void addRepairable(Repairable r) {
        this.repairables.add(r);
    }

    @Override
    public ArenaRegion getRegion() {
        return this.region;
    }

    @Override
    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @Override
    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    @Override
    public MonsterManager getMonsterManager() {
        return this.monsterManager;
    }

    @Override
    public ClassLimitManager getClassLimitManager() {
        return this.limitManager;
    }

    @Override
    public ArenaLog getLog() {
        return this.log;
    }

    @Override
    public boolean startArena() {
        if (this.running || this.lobbyPlayers.isEmpty() || !this.readyPlayers.containsAll(this.lobbyPlayers)) {
            return false;
        }
        ArenaStartEvent event = new ArenaStartEvent(this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.storeContainerContents();
        this.arenaPlayers.addAll(this.lobbyPlayers);
        this.lobbyPlayers.clear();
        this.readyPlayers.clear();
        for (Player p : this.randoms) {
            this.assignRandomClass(p);
        }
        this.randoms.clear();
        if (this.arenaPlayers.isEmpty()) {
            return false;
        }
        for (Player p : this.arenaPlayers) {
            if (this.inSpec(p)) {
                this.specPlayers.remove(p);
                System.out.println("[MobArena] Player " + p.getName() + " joined the arena from the spec area!");
                System.out.println("[MobArena] Invincibility glitch attempt stopped!");
            }
            p.teleport(this.region.getArenaWarp());
            this.setHealth(p, 20);
            p.setFoodLevel(20);
            this.assignClassPermissions(p);
            this.arenaPlayerMap.get(p).resetStats();
        }
        this.startSpawner();
        this.startBouncingSheep();
        this.running = true;
        this.spawnPets();
        this.limitManager.clearClassesInUse();
        this.rewardManager.reset();
        if (this.logging) {
            this.log.start();
        }
        this.leaderboard.initialize();
        this.leaderboard.startTracking();
        Messenger.tellAll(this, Msg.ARENA_START);
        return true;
    }

    @Override
    public boolean endArena() {
        if (!this.running || !this.arenaPlayers.isEmpty()) {
            return false;
        }
        ArenaEndEvent event = new ArenaEndEvent(this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        boolean en = this.enabled;
        this.enabled = false;
        this.running = false;
        this.leaderboard.stopTracking();
        this.leaderboard.update();
        if (this.logging) {
            this.log.end();
        }
        this.stopSpawner();
        Messenger.tellAll((Arena)this, Msg.ARENA_END, true);
        this.cleanup();
        if (this.settings.getBoolean("soft-restore", false)) {
            this.restoreRegion();
        }
        this.restoreContainerContents();
        this.enabled = en;
        return true;
    }

    @Override
    public void forceStart() {
        if (this.running) {
            return;
        }
        HashSet<Player> tmp = new HashSet<Player>();
        tmp.addAll(this.lobbyPlayers);
        tmp.removeAll(this.readyPlayers);
        for (Player p : tmp) {
            this.playerLeave(p);
        }
        this.startArena();
    }

    @Override
    public void forceEnd() {
        for (Player p : this.getAllPlayers()) {
            this.playerLeave(p);
        }
        this.cleanup();
    }

    @Override
    public boolean playerJoin(Player p, Location loc) {
        ArenaPlayerJoinEvent event = new ArenaPlayerJoinEvent(p, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.takeFee(p);
        this.storePlayerData(p, loc);
        this.removePotionEffects(p);
        MAUtils.sitPets(p);
        this.setHealth(p, 20);
        p.setFoodLevel(20);
        p.setGameMode(GameMode.SURVIVAL);
        this.movePlayerToLobby(p);
        this.arenaPlayerMap.put(p, new ArenaPlayer(p, this, this.plugin));
        if (MobArena.hasSpout && this.settings.getBoolean("spout-class-select")) {
            Spouty.classSelectionScreen(this.plugin, this, p);
        }
        Messenger.tellPlayer((CommandSender)p, Msg.JOIN_PLAYER_JOINED);
        return true;
    }

    @Override
    public void playerReady(Player p) {
        this.readyPlayers.add(p);
        int minPlayers = this.getMinPlayers();
        if (minPlayers > 0 && this.lobbyPlayers.size() < minPlayers) {
            Messenger.tellPlayer((CommandSender)p, Msg.LOBBY_NOT_ENOUGH_PLAYERS, "" + minPlayers);
            return;
        }
        this.startArena();
    }

    @Override
    public boolean playerLeave(Player p) {
        ArenaPlayerLeaveEvent event = new ArenaPlayerLeaveEvent(p, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.removeClassPermissions(p);
        this.removePotionEffects(p);
        ArenaPlayer ap = this.arenaPlayerMap.get(p);
        if (this.logging && ap != null && this.running) {
            this.log.playerDeath(ap);
        }
        this.restoreInvAndExp(p);
        if (this.inLobby(p) || this.inArena(p)) {
            this.refund(p);
        }
        if (this.inLobby(p) && ap.getArenaClass() != null) {
            this.limitManager.playerLeftClass(ap.getArenaClass());
        }
        this.movePlayerToEntry(p);
        this.discardPlayer(p);
        this.endArena();
        return true;
    }

    @Override
    public void playerDeath(Player p) {
        ArenaPlayerDeathEvent event = new ArenaPlayerDeathEvent(p, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        ArenaPlayer ap = this.arenaPlayerMap.get(p);
        if (this.logging && ap != null) {
            this.log.playerDeath(ap);
        }
        this.arenaPlayers.remove(p);
        if (!this.settings.getBoolean("auto-respawn", true)) {
            this.deadPlayers.add(p);
            this.endArena();
            return;
        }
        p.setHealth(20);
        Delays.revivePlayer(this.plugin, this, p);
        this.endArena();
    }

    @Override
    public void playerRespawn(Player p) {
        if (this.settings.getBoolean("auto-respawn", true)) {
            return;
        }
        this.deadPlayers.remove(p);
        this.revivePlayer(p);
    }

    @Override
    public void revivePlayer(Player p) {
        Delays.douse(this.plugin, p, 1L);
        this.removeClassPermissions(p);
        this.removePotionEffects(p);
        if (this.settings.getBoolean("spectate-on-death", true)) {
            this.movePlayerToSpec(p);
            Messenger.tellPlayer((CommandSender)p, Msg.SPEC_FROM_ARENA);
            Messenger.tellPlayer((CommandSender)p, Msg.MISC_MA_LEAVE_REMINDER);
        } else {
            this.restoreInvAndExp(p);
            this.movePlayerToEntry(p);
            this.discardPlayer(p);
        }
        p.updateInventory();
    }

    @Override
    public Location getRespawnLocation(Player p) {
        Location l = null;
        l = this.settings.getBoolean("spectate-on-death", true) ? this.region.getSpecWarp() : this.playerData.get(p).entry();
        return l;
    }

    @Override
    public void playerSpec(Player p, Location loc) {
        this.storePlayerData(p, loc);
        MAUtils.sitPets(p);
        this.movePlayerToSpec(p);
        Messenger.tellPlayer((CommandSender)p, Msg.SPEC_PLAYER_SPECTATE);
    }

    private void spawnPets() {
        for (Map.Entry<Player, ArenaPlayer> entry : this.arenaPlayerMap.entrySet()) {
            ArenaClass arenaClass = entry.getValue().getArenaClass();
            int petAmount = arenaClass.getPetAmount();
            if (petAmount <= 0) continue;
            Player p = entry.getKey();
            p.getInventory().removeItem(new ItemStack[]{new ItemStack(Material.BONE, petAmount)});
            for (int i = 0; i < petAmount; ++i) {
                Wolf wolf = (Wolf)this.world.spawnEntity(p.getLocation(), EntityType.WOLF);
                wolf.setTamed(true);
                wolf.setOwner((AnimalTamer)p);
                wolf.setHealth(wolf.getMaxHealth());
                if (this.settings.getBoolean("hellhounds")) {
                    wolf.setFireTicks(32768);
                }
                this.monsterManager.addPet(wolf);
            }
        }
    }

    private void removePotionEffects(Player p) {
        for (PotionEffect effect : p.getActivePotionEffects()) {
            p.removePotionEffect(effect.getType());
        }
    }

    private void startSpawner() {
        this.world.setSpawnFlags(true, true);
        if (this.spawnThread == null) {
            this.spawnThread = new MASpawnThread(this.plugin, this);
        } else {
            this.spawnThread.reset();
        }
        this.scheduleTask(this.spawnThread, this.settings.getInt("first-wave-delay", 5) * 20);
    }

    @Override
    public void scheduleTask(Runnable r, int delay) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, r, (long)delay);
    }

    private void stopSpawner() {
        this.world.setSpawnFlags(this.allowMonsters, this.allowAnimals);
    }

    private void startBouncingSheep() {
        if (this.sheepBouncer == null) {
            this.sheepBouncer = new SheepBouncer(this);
        }
        this.scheduleTask(this.sheepBouncer, this.settings.getInt("first-wave-delay", 5) * 20);
    }

    private void updateChunk(Location loc) {
        if (!this.arenaPlayers.isEmpty() || !this.world.getName().equals(loc.getWorld().getName())) {
            return;
        }
        Chunk chunk = this.world.getChunkAt(loc);
        if (!this.world.isChunkLoaded(chunk)) {
            this.world.loadChunk(chunk);
        } else {
            this.world.refreshChunk(chunk.getX(), chunk.getZ());
        }
    }

    @Override
    public void storePlayerData(Player p, Location loc) {
        this.plugin.getArenaMaster().addPlayer(p, this);
        PlayerData mp = this.playerData.get(p);
        if (mp == null) {
            mp = new PlayerData(p);
            this.playerData.put(p, mp);
        }
        mp.update();
        this.inventoryManager.storeInventory(p);
    }

    @Override
    public void storeContainerContents() {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Location loc : ArenaImpl.this.region.getContainers()) {
                    BlockState state = ArenaImpl.this.world.getBlockAt(loc).getState();
                    if (!(state instanceof InventoryHolder)) continue;
                    ArenaImpl.this.containables.add(new RepairableContainer(state, false));
                }
            }
        });
    }

    @Override
    public void restoreContainerContents() {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                for (Repairable r : ArenaImpl.this.containables) {
                    r.repair();
                }
            }
        });
    }

    @Override
    public void movePlayerToLobby(Player p) {
        this.updateChunk(this.region.getLobbyWarp());
        this.specPlayers.remove(p);
        this.lobbyPlayers.add(p);
        p.teleport(this.region.getLobbyWarp());
        this.timeStrategy.setPlayerTime(p);
    }

    @Override
    public void movePlayerToSpec(Player p) {
        this.updateChunk(this.region.getSpecWarp());
        this.specPlayers.add(p);
        p.teleport(this.region.getSpecWarp());
        this.timeStrategy.setPlayerTime(p);
    }

    @Override
    public void movePlayerToEntry(Player p) {
        Location entry = this.playerData.get(p).entry();
        if (entry == null || p.isDead()) {
            return;
        }
        this.updateChunk(entry);
        p.teleport(entry);
        this.timeStrategy.resetPlayerTime(p);
        p.setGameMode(this.playerData.get(p).getMode());
        p.addPotionEffects(this.playerData.get(p).getPotionEffects());
    }

    private void restoreInvAndExp(Player p) {
        this.inventoryManager.clearInventory(p);
        this.inventoryManager.restoreInventory(p);
        this.rewardManager.grantRewards(p);
        if (!this.settings.getBoolean("keep-exp", false)) {
            this.playerData.get(p).restoreData();
        } else {
            p.setFoodLevel(this.playerData.get(p).food());
        }
    }

    @Override
    public void discardPlayer(Player p) {
        this.plugin.getArenaMaster().removePlayer(p);
        this.clearPlayer(p);
    }

    private void clearPlayer(Player p) {
        PlayerData mp = this.playerData.remove(p);
        this.setHealth(p, mp.health());
        Delays.douse(this.plugin, p, 3L);
        this.monsterManager.removePets(p);
        this.readyPlayers.remove(p);
        this.specPlayers.remove(p);
        this.arenaPlayers.remove(p);
        this.lobbyPlayers.remove(p);
        this.arenaPlayerMap.remove(p);
    }

    private void setHealth(Player p, int health) {
        this.plugin.getHealthStrategy().setHealth(p, health);
    }

    @Override
    public void repairBlocks() {
        while (!this.repairQueue.isEmpty()) {
            this.repairQueue.poll().repair();
        }
    }

    @Override
    public void queueRepairable(Repairable r) {
        this.repairQueue.add(r);
    }

    @Override
    public void assignClass(Player p, String className) {
        ArenaPlayer arenaPlayer = this.arenaPlayerMap.get(p);
        ArenaClass arenaClass = this.classes.get(className);
        if (arenaPlayer == null || arenaClass == null) {
            return;
        }
        this.inventoryManager.clearInventory(p);
        arenaPlayer.setArenaClass(arenaClass);
        arenaClass.grantItems(p);
    }

    @Override
    public void addRandomPlayer(Player p) {
        this.randoms.add(p);
    }

    @Override
    public void assignRandomClass(Player p) {
        Random r = new Random();
        LinkedList<String> classes = new LinkedList<String>(this.classes.keySet());
        String className = (String)classes.remove(r.nextInt(classes.size()));
        while (!this.plugin.has(p, "mobarena.classes." + className)) {
            if (classes.isEmpty()) {
                Messenger.info("Player '" + p.getName() + "' has no class permissions!");
                this.playerLeave(p);
                return;
            }
            className = (String)classes.remove(r.nextInt(classes.size()));
        }
        this.assignClass(p, className);
        Messenger.tellPlayer((CommandSender)p, Msg.LOBBY_CLASS_PICKED, TextUtils.camelCase(className), this.getClassLogo(className));
    }

    @Override
    public void assignClassPermissions(Player p) {
        PermissionAttachment pa = this.arenaPlayerMap.get(p).getArenaClass().grantPermissions(this.plugin, p);
        if (pa == null) {
            return;
        }
        this.attachments.put(p, pa);
        p.recalculatePermissions();
    }

    @Override
    public void removeClassPermissions(Player p) {
        PermissionAttachment pa = this.attachments.remove(p);
        if (pa == null) {
            return;
        }
        try {
            p.removeAttachment(pa);
        }
        catch (Exception e) {
            for (Map.Entry entry : pa.getPermissions().entrySet()) {
                String perm = (String)entry.getKey() + ":" + entry.getValue();
                String name = p.getName();
                Messenger.warning("[PERM01] Failed to remove permission attachment '" + perm + "' from player '" + name + "'.\nThis should not be a big issue, but please verify that the player doesn't have any permissions they shouldn't have.");
            }
        }
        p.recalculatePermissions();
    }

    private void cleanup() {
        this.removeMonsters();
        this.removeBlocks();
        this.removeEntities();
        this.clearPlayers();
    }

    private void removeMonsters() {
        this.monsterManager.clear();
    }

    private void removeBlocks() {
        for (Block b : this.blocks) {
            b.setTypeId(0);
        }
        this.blocks.clear();
    }

    private void removeEntities() {
        List<Chunk> chunks = this.region.getChunks();
        for (Chunk c : chunks) {
            for (Entity e : c.getEntities()) {
                if (!(e instanceof Item) && !(e instanceof Vehicle) && !(e instanceof Slime) && !(e instanceof ExperienceOrb) || e == null) continue;
                e.remove();
            }
        }
    }

    private void clearPlayers() {
        this.arenaPlayers.clear();
        this.arenaPlayerMap.clear();
        this.lobbyPlayers.clear();
        this.readyPlayers.clear();
    }

    @Override
    public void restoreRegion() {
        Collections.sort(this.repairables, new RepairableComparator());
        for (Repairable r : this.repairables) {
            r.repair();
        }
    }

    @Override
    public boolean inArena(Player p) {
        return this.arenaPlayers.contains(p);
    }

    @Override
    public boolean inLobby(Player p) {
        return this.lobbyPlayers.contains(p);
    }

    @Override
    public boolean inSpec(Player p) {
        return this.specPlayers.contains(p);
    }

    @Override
    public boolean isDead(Player p) {
        return this.deadPlayers.contains(p);
    }

    @Override
    public String configName() {
        return this.name;
    }

    @Override
    public String arenaName() {
        return MAUtils.nameConfigToArena(this.name);
    }

    @Override
    public MobArena getPlugin() {
        return this.plugin;
    }

    @Override
    public Wave getWave() {
        return this.currentWave;
    }

    @Override
    public Map<String, ArenaClass> getClasses() {
        return this.classes;
    }

    @Override
    public int getPlayerCount() {
        return this.spawnThread.getPlayerCount();
    }

    @Override
    public List<Player> getAllPlayers() {
        LinkedList<Player> result = new LinkedList<Player>();
        result.addAll(this.arenaPlayers);
        result.addAll(this.lobbyPlayers);
        result.addAll(this.specPlayers);
        return result;
    }

    @Override
    public Collection<ArenaPlayer> getArenaPlayerSet() {
        return this.arenaPlayerMap.values();
    }

    @Override
    public List<Player> getNonreadyPlayers() {
        LinkedList<Player> result = new LinkedList<Player>();
        result.addAll(this.lobbyPlayers);
        result.removeAll(this.readyPlayers);
        return result;
    }

    @Override
    public boolean canAfford(Player p) {
        if (this.entryFee.isEmpty()) {
            return true;
        }
        PlayerInventory inv = p.getInventory();
        for (ItemStack stack : this.entryFee) {
            if (!(stack.getTypeId() == -29 ? !this.plugin.hasEnough(p, stack.getAmount()) : !inv.contains(stack.getTypeId(), stack.getAmount()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean takeFee(Player p) {
        if (this.entryFee.isEmpty()) {
            return true;
        }
        PlayerInventory inv = p.getInventory();
        for (ItemStack stack : InventoryUtils.extractAll(-29, this.entryFee)) {
            this.plugin.takeMoney(p, stack.getAmount());
        }
        for (ItemStack stack : this.entryFee) {
            inv.removeItem(new ItemStack[]{stack});
        }
        Messenger.tellPlayer((CommandSender)p, Msg.JOIN_FEE_PAID.toString(MAUtils.listToString(this.entryFee, this.plugin)));
        return true;
    }

    @Override
    public boolean refund(Player p) {
        if (this.entryFee.isEmpty()) {
            return true;
        }
        if (!this.inLobby(p)) {
            return false;
        }
        for (ItemStack stack : InventoryUtils.extractAll(-29, this.entryFee)) {
            this.plugin.giveMoney(p, stack.getAmount());
        }
        for (ItemStack stack : this.entryFee) {
            if (stack.getTypeId() <= 0) continue;
            p.getInventory().addItem(new ItemStack[]{stack});
        }
        return true;
    }

    @Override
    public boolean canJoin(Player p) {
        if (!this.enabled) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ARENA_NOT_ENABLED);
        } else if (!this.region.isSetup() || this.waveManager.getRecurrentWaves().isEmpty()) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ARENA_NOT_SETUP);
        } else if (this.edit) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ARENA_EDIT_MODE);
        } else if (this.arenaPlayers.contains(p) || this.lobbyPlayers.contains(p)) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ALREADY_PLAYING);
        } else if (this.running) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ARENA_IS_RUNNING);
        } else if (!this.plugin.has(p, "mobarena.arenas." + this.configName())) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ARENA_PERMISSION);
        } else if (this.getMaxPlayers() > 0 && this.lobbyPlayers.size() >= this.getMaxPlayers()) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_PLAYER_LIMIT_REACHED);
        } else if (this.getJoinDistance() > 0 && !this.region.contains(p.getLocation(), this.getJoinDistance())) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_TOO_FAR);
        } else if (this.settings.getBoolean("require-empty-inv-join", true) && !InventoryManager.hasEmptyInventory(p)) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_EMPTY_INV);
        } else if (!this.canAfford(p)) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_FEE_REQUIRED, MAUtils.listToString(this.entryFee, this.plugin));
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean canSpec(Player p) {
        if (!this.enabled) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ARENA_NOT_ENABLED);
        } else if (!this.region.isSetup()) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ARENA_NOT_SETUP);
        } else if (this.edit) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ARENA_EDIT_MODE);
        } else if (this.arenaPlayers.contains(p) || this.lobbyPlayers.contains(p)) {
            Messenger.tellPlayer((CommandSender)p, Msg.SPEC_ALREADY_PLAYING);
        } else if (this.settings.getBoolean("require-empty-inv-spec", true) && !InventoryManager.hasEmptyInventory(p)) {
            Messenger.tellPlayer((CommandSender)p, Msg.SPEC_EMPTY_INV);
        } else if (this.getJoinDistance() > 0 && !this.region.contains(p.getLocation(), this.getJoinDistance())) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_TOO_FAR);
        } else {
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return other instanceof ArenaImpl && ((ArenaImpl)other).name.equals(this.name);
    }

    public String toString() {
        return (this.enabled && this.region.isSetup() ? ChatColor.GREEN : ChatColor.GRAY) + this.configName();
    }
}

