/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.ArenaImpl;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.util.ItemParser;
import com.garbagemule.MobArena.util.TextUtils;
import com.garbagemule.MobArena.util.config.Config;
import com.garbagemule.MobArena.util.config.ConfigSection;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;

public class ArenaMasterImpl
implements ArenaMaster {
    private MobArena plugin;
    private Config config;
    private List<Arena> arenas;
    private Map<Player, Arena> arenaMap;
    private Arena selectedArena;
    private Map<String, ArenaClass> classes;
    private Set<String> allowedCommands;
    private boolean enabled;

    public ArenaMasterImpl(MobArena plugin) {
        this.plugin = plugin;
        this.config = plugin.getMAConfig();
        this.arenas = new LinkedList<Arena>();
        this.arenaMap = new HashMap<Player, Arena>();
        this.classes = new HashMap<String, ArenaClass>();
        this.allowedCommands = new HashSet<String>();
        this.enabled = this.config.getBoolean("global-settings.enabled", true);
    }

    @Override
    public MobArena getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
        this.config.set("global-settings.enabled", this.enabled);
    }

    @Override
    public boolean notifyOnUpdates() {
        return this.config.getBoolean("global-settings.update-notification", false);
    }

    @Override
    public Arena getSelectedArena() {
        return this.selectedArena;
    }

    @Override
    public void setSelectedArena(Arena arena) {
        this.selectedArena = arena;
    }

    @Override
    public List<Arena> getArenas() {
        return this.arenas;
    }

    @Override
    public Map<String, ArenaClass> getClasses() {
        return this.classes;
    }

    @Override
    public void addPlayer(Player p, Arena arena) {
        this.arenaMap.put(p, arena);
    }

    @Override
    public Arena removePlayer(Player p) {
        return this.arenaMap.remove(p);
    }

    @Override
    public void resetArenaMap() {
        this.arenaMap.clear();
    }

    @Override
    public boolean isAllowed(String command) {
        return this.allowedCommands.contains(command);
    }

    @Override
    public List<Arena> getEnabledArenas() {
        return this.getEnabledArenas(this.arenas);
    }

    @Override
    public List<Arena> getEnabledArenas(List<Arena> arenas) {
        LinkedList<Arena> result = new LinkedList<Arena>();
        for (Arena arena : arenas) {
            if (!arena.isEnabled()) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Arena> getPermittedArenas(Player p) {
        LinkedList<Arena> result = new LinkedList<Arena>();
        for (Arena arena : this.arenas) {
            if (!this.plugin.has(p, "mobarena.arenas." + arena.configName())) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Arena> getEnabledAndPermittedArenas(Player p) {
        LinkedList<Arena> result = new LinkedList<Arena>();
        for (Arena arena : this.arenas) {
            if (!arena.isEnabled() || !this.plugin.has(p, "mobarena.arenas." + arena.configName())) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public Arena getArenaAtLocation(Location loc) {
        for (Arena arena : this.arenas) {
            if (!arena.getRegion().contains(loc)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public List<Arena> getArenasInWorld(World world) {
        LinkedList<Arena> result = new LinkedList<Arena>();
        for (Arena arena : this.arenas) {
            if (!arena.getWorld().equals(world)) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Player> getAllPlayers() {
        LinkedList<Player> result = new LinkedList<Player>();
        for (Arena arena : this.arenas) {
            result.addAll(arena.getAllPlayers());
        }
        return result;
    }

    @Override
    public List<Player> getAllPlayersInArena(String arenaName) {
        Arena arena = this.getArenaWithName(arenaName);
        return arena != null ? new LinkedList<Player>(arena.getPlayersInArena()) : new LinkedList();
    }

    @Override
    public List<Player> getAllLivingPlayers() {
        LinkedList<Player> result = new LinkedList<Player>();
        for (Arena arena : this.arenas) {
            result.addAll(arena.getPlayersInArena());
        }
        return result;
    }

    @Override
    public List<Player> getLivingPlayersInArena(String arenaName) {
        Arena arena = this.getArenaWithName(arenaName);
        return arena != null ? new LinkedList<Player>(arena.getPlayersInArena()) : new LinkedList();
    }

    @Override
    public Arena getArenaWithPlayer(Player p) {
        return this.arenaMap.get(p);
    }

    @Override
    public Arena getArenaWithPlayer(String playerName) {
        return this.arenaMap.get(this.plugin.getServer().getPlayer(playerName));
    }

    @Override
    public Arena getArenaWithSpectator(Player p) {
        for (Arena arena : this.arenas) {
            if (!arena.getSpectators().contains(p)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithMonster(Entity e) {
        for (Arena arena : this.arenas) {
            if (!arena.getMonsterManager().getMonsters().contains(e)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithPet(Entity e) {
        for (Arena arena : this.arenas) {
            if (!arena.hasPet(e)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithName(String configName) {
        return this.getArenaWithName(this.arenas, configName);
    }

    @Override
    public Arena getArenaWithName(Collection<Arena> arenas, String configName) {
        for (Arena arena : arenas) {
            if (!arena.configName().equals(configName)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public void initialize() {
        this.config.load();
        this.loadSettings();
        this.loadClasses();
        this.loadArenas();
        this.config.save();
    }

    @Override
    public void loadSettings() {
        ConfigUtils.replaceAllNodes(this.plugin, this.config, "global-settings", "global-settings.yml");
        ConfigSection section = this.config.getConfigSection("global-settings");
        String cmds = section.getString("allowed-commands", "");
        String[] parts = cmds.split(",");
        this.allowedCommands.add("/ma");
        for (String part : parts) {
            this.allowedCommands.add(part.trim().toLowerCase());
        }
    }

    @Override
    public void loadClasses() {
        Set<String> classNames = this.config.getKeys("classes");
        if (classNames == null || classNames.isEmpty()) {
            this.loadDefaultClasses();
            classNames = this.config.getKeys("classes");
        }
        this.classes = new HashMap<String, ArenaClass>();
        for (String className : classNames) {
            this.loadClass(className);
        }
    }

    public void loadDefaultClasses() {
        ConfigUtils.addMissingNodes(this.plugin, this.config, "classes", "classes.yml");
    }

    private ArenaClass loadClass(String classname) {
        String armor;
        String lowercase = classname.toLowerCase();
        ConfigSection section = this.config.getConfigSection("classes." + classname);
        if (section == null) {
            Messenger.severe("Failed to load class '" + classname + "'.");
            return null;
        }
        ArenaClass arenaClass = new ArenaClass(classname);
        String items = section.getString("items", "");
        if (!items.equals("")) {
            List<ItemStack> stacks = ItemParser.parseItems(items);
            arenaClass.setItems(stacks);
        }
        if (!(armor = section.getString("armor", "")).equals("")) {
            List<ItemStack> stacks = ItemParser.parseItems(armor);
            arenaClass.setArmor(stacks);
        }
        String head = section.getString("helmet", null);
        String chest = section.getString("chestplate", null);
        String legs = section.getString("leggings", null);
        String feet = section.getString("boots", null);
        ItemStack helmet = ItemParser.parseItem(head);
        ItemStack chestplate = ItemParser.parseItem(chest);
        ItemStack leggings = ItemParser.parseItem(legs);
        ItemStack boots = ItemParser.parseItem(feet);
        arenaClass.setHelmet(helmet);
        arenaClass.setChestplate(chestplate);
        arenaClass.setLeggings(leggings);
        arenaClass.setBoots(boots);
        this.loadClassPermissions(arenaClass, section);
        this.registerPermission("mobarena.classes." + lowercase, PermissionDefault.TRUE).addParent("mobarena.classes", true);
        this.classes.put(lowercase, arenaClass);
        return arenaClass;
    }

    private void loadClassPermissions(ArenaClass arenaClass, ConfigSection section) {
        List<String> perms = section.getStringList("permissions", null);
        if (perms.isEmpty()) {
            return;
        }
        for (String perm : perms) {
            boolean value = true;
            if (perm.startsWith("-") || perm.startsWith("^")) {
                perm = perm.substring(1).trim();
                value = false;
            }
            arenaClass.addPermission(perm, value);
        }
    }

    @Override
    public ArenaClass createClassNode(String classname, PlayerInventory inv, boolean safe) {
        String path = "classes." + classname;
        if (safe && this.config.getConfigSection(path) != null) {
            return null;
        }
        this.config.set(path, "");
        ConfigSection section = this.config.getConfigSection(path);
        section.set("items", ItemParser.parseString(inv.getContents()));
        section.set("armor", ItemParser.parseString(inv.getArmorContents()));
        ItemStack helmet = inv.getHelmet();
        if (helmet.getTypeId() != 0 && ArenaClass.ArmorType.getType(helmet) != ArenaClass.ArmorType.HELMET) {
            section.set("helmet", ItemParser.parseString(helmet));
        }
        this.config.save();
        return this.loadClass(classname);
    }

    @Override
    public void removeClassNode(String classname) {
        String lowercase = classname.toLowerCase();
        if (!this.classes.containsKey(lowercase)) {
            throw new IllegalArgumentException("Class does not exist!");
        }
        this.config.remove("classes." + classname);
        this.config.save();
        this.classes.remove(lowercase);
        this.unregisterPermission("mobarena.arenas." + lowercase);
    }

    @Override
    public boolean addClassPermission(String classname, String perm) {
        return this.addRemoveClassPermission(classname, perm, true);
    }

    @Override
    public boolean removeClassPermission(String classname, String perm) {
        return this.addRemoveClassPermission(classname, perm, false);
    }

    private boolean addRemoveClassPermission(String classname, String perm, boolean add) {
        classname = TextUtils.camelCase(classname);
        String path = "classes." + classname;
        if (this.config.getConfigSection(path) == null) {
            return false;
        }
        ConfigSection section = this.config.getConfigSection(path);
        List<String> nodes = section.getStringList("permissions", null);
        if (nodes.contains(perm) && add) {
            return false;
        }
        if (nodes.contains(perm) && !add) {
            nodes.remove(perm);
        } else if (!nodes.contains(perm) && add) {
            this.removeContradictions(nodes, perm);
            nodes.add(perm);
        } else if (!nodes.contains(perm) && !add) {
            return false;
        }
        section.set("permissions", nodes);
        this.config.save();
        this.loadClass(classname);
        return true;
    }

    private void removeContradictions(List<String> nodes, String perm) {
        if (perm.startsWith("^") || perm.startsWith("-")) {
            nodes.remove(perm.substring(1).trim());
        } else {
            nodes.remove("^" + perm);
            nodes.remove("-" + perm);
        }
    }

    @Override
    public void loadArenas() {
        Set<String> arenanames = this.config.getKeys("arenas");
        if (arenanames == null || arenanames.isEmpty()) {
            this.createArenaNode("default", (World)this.plugin.getServer().getWorlds().get(0));
            arenanames = this.config.getKeys("arenas");
        }
        this.arenas = new LinkedList<Arena>();
        for (String arenaname : arenanames) {
            this.loadArena(arenaname);
        }
        this.selectedArena = this.arenas.get(0);
    }

    private Arena loadArena(String arenaname) {
        String path = "arenas." + arenaname;
        String worldName = this.config.getString(path + ".settings.world", "");
        World world = null;
        if (!worldName.equals("")) {
            world = this.plugin.getServer().getWorld(worldName);
            if (world == null) {
                Messenger.severe("The world '" + worldName + "' for arena '" + arenaname + "' does not exist!");
                return null;
            }
        } else {
            world = (World)this.plugin.getServer().getWorlds().get(0);
            Messenger.warning("Could not find the world for arena '" + arenaname + "'. Using default world ('" + world.getName() + "')! Check the config-file!");
        }
        ConfigUtils.replaceAllNodes(this.plugin, this.config, path + ".settings", "settings.yml");
        ArenaImpl arena = new ArenaImpl(this.plugin, this.config, arenaname, world);
        this.registerPermission("mobarena.arenas." + arenaname.toLowerCase(), PermissionDefault.TRUE);
        this.arenas.add(arena);
        return arena;
    }

    @Override
    public Arena createArenaNode(String arenaName, World world) {
        String path = "arenas." + arenaName;
        if (this.config.getConfigSection(path) != null) {
            throw new IllegalArgumentException("Arena already exists!");
        }
        ConfigUtils.replaceAllNodes(this.plugin, this.config, path + ".settings", "settings.yml");
        this.config.set(path + ".settings.world", world.getName());
        ConfigUtils.replaceAllNodes(this.plugin, this.config, path + ".waves", "waves.yml");
        ConfigUtils.replaceAllNodes(this.plugin, this.config, path + ".rewards", "rewards.yml");
        this.config.save();
        return this.loadArena(arenaName);
    }

    @Override
    public void removeArenaNode(Arena arena) {
        this.config.remove("arenas." + arena.configName());
        this.config.save();
        this.arenas.remove(arena);
        this.unregisterPermission("mobarena.arenas." + arena.configName());
    }

    @Override
    public void reloadConfig() {
        boolean wasEnabled = this.isEnabled();
        if (wasEnabled) {
            this.setEnabled(false);
        }
        for (Arena a : this.arenas) {
            a.forceEnd();
        }
        this.config.load();
        this.loadSettings();
        this.loadClasses();
        this.loadArenas();
        if (wasEnabled) {
            this.setEnabled(true);
        }
    }

    @Override
    public void saveConfig() {
        this.config.save();
    }

    private Permission registerPermission(String permString, PermissionDefault value) {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        Permission perm = pm.getPermission(permString);
        if (perm == null) {
            perm = new Permission(permString);
            perm.setDefault(value);
            pm.addPermission(perm);
        }
        return perm;
    }

    private void unregisterPermission(String s) {
        this.plugin.getServer().getPluginManager().removePermission(s);
    }
}

