/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.MutableInt;
import com.garbagemule.MobArena.util.config.ConfigSection;
import java.util.HashMap;
import java.util.Map;

public class ClassLimitManager {
    private HashMap<ArenaClass, MutableInt> classLimits;
    private HashMap<ArenaClass, MutableInt> classesInUse;
    private ConfigSection limits;
    private Map<String, ArenaClass> classes;

    public ClassLimitManager(Arena arena, Map<String, ArenaClass> classes, ConfigSection limits) {
        this.limits = limits;
        this.classes = classes;
        this.classLimits = new HashMap();
        this.classesInUse = new HashMap();
        this.loadLimitMap();
        this.initInUseMap();
    }

    private void loadLimitMap() {
        if (this.limits.getKeys() == null) {
            for (ArenaClass ac : this.classes.values()) {
                this.limits.set(ac.getConfigName(), -1);
            }
            this.limits.getParent().save();
        }
        for (ArenaClass ac : this.classes.values()) {
            this.classLimits.put(ac, new MutableInt(this.limits.getInt(ac.getConfigName(), -1)));
        }
    }

    private void initInUseMap() {
        for (ArenaClass ac : this.classes.values()) {
            this.classesInUse.put(ac, new MutableInt());
        }
    }

    public void playerPickedClass(ArenaClass ac) {
        this.classesInUse.get(ac).inc();
    }

    public void playerLeftClass(ArenaClass ac) {
        if (ac != null) {
            this.classesInUse.get(ac).dec();
        }
    }

    public boolean canPlayerJoinClass(ArenaClass ac) {
        if (this.classLimits.get(ac) == null) {
            this.limits.set(ac.getConfigName(), -1);
            this.classLimits.put(ac, new MutableInt(-1));
            this.classesInUse.put(ac, new MutableInt());
        }
        if (this.classLimits.get(ac).value() <= -1) {
            return true;
        }
        return this.classesInUse.get(ac).value() < this.classLimits.get(ac).value();
    }

    public void clearClassesInUse() {
        this.classesInUse.clear();
        this.initInUseMap();
    }
}

