/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.Msg;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MAMessages {
    public static void init(MobArena plugin) {
        File msgFile = new File(plugin.getDataFolder(), "announcements.properties");
        if (!MAMessages.load(plugin, msgFile)) {
            return;
        }
        MAMessages.parseFile(plugin, msgFile);
    }

    private static boolean load(MobArena plugin, File file) {
        if (file.exists()) {
            return true;
        }
        try {
            file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            for (Msg m : Msg.values()) {
                if (m.hasSpoutMsg()) {
                    bw.write(m.name() + "=" + (Object)((Object)m) + "|" + m.toSpoutString());
                } else {
                    bw.write(m.name() + "=" + (Object)((Object)m));
                }
                bw.newLine();
            }
            bw.close();
            return true;
        }
        catch (Exception e) {
            Messenger.warning("Couldn't initialize announcements-file. Using defaults.");
            return false;
        }
    }

    private static void parseFile(MobArena plugin, File file) {
        try {
            String s;
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            br.mark(1);
            int bom = br.read();
            if (bom != 65279) {
                br.reset();
            }
            while ((s = br.readLine()) != null) {
                MAMessages.process(plugin, s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            Messenger.warning("Problem with announcements-file. Using defaults.");
            return;
        }
    }

    private static void process(MobArena plugin, String s) {
        String[] split;
        if (s.endsWith("=") || s.endsWith("|")) {
            s = s + " ";
        }
        if ((split = s.split("=")).length != 2) {
            Messenger.warning("Couldn't parse \"" + s + "\". Check announcements-file.");
            return;
        }
        String[] vals = split[1].split("\\|");
        String key = split[0];
        String val = vals.length == 2 ? vals[0] : split[1];
        String spoutVal = vals.length == 2 ? vals[1] : null;
        try {
            Msg msg = Msg.valueOf(key);
            msg.set(val);
            msg.setSpout(spoutVal);
        }
        catch (Exception e) {
            Messenger.warning(key + " is not a valid key. Check announcements-file.");
            return;
        }
    }
}

