/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.MAUtils;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.MonsterManager;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.RewardManager;
import com.garbagemule.MobArena.events.NewWaveEvent;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.waves.MABoss;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.WaveManager;
import com.garbagemule.MobArena.waves.enums.WaveType;
import com.garbagemule.MobArena.waves.types.BossWave;
import com.garbagemule.MobArena.waves.types.SupplyWave;
import com.garbagemule.MobArena.waves.types.UpgradeWave;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class MASpawnThread
implements Runnable {
    private MobArena plugin;
    private Arena arena;
    private ArenaRegion region;
    private RewardManager rewardManager;
    private WaveManager waveManager;
    private MonsterManager monsterManager;
    private int playerCount;
    private int monsterLimit;
    private boolean waveClear;
    private boolean bossClear;

    public MASpawnThread(MobArena plugin, Arena arena) {
        this.plugin = plugin;
        this.arena = arena;
        this.region = arena.getRegion();
        this.rewardManager = arena.getRewardManager();
        this.waveManager = arena.getWaveManager();
        this.monsterManager = arena.getMonsterManager();
        this.reset();
    }

    public void reset() {
        this.waveManager.reset();
        this.playerCount = this.arena.getPlayersInArena().size();
        this.monsterLimit = this.arena.getSettings().getInt("monster-limit", 100);
        this.waveClear = this.arena.getSettings().getBoolean("clear-wave-before-next", false);
        this.bossClear = this.arena.getSettings().getBoolean("clear-boss-before-next", false);
    }

    @Override
    public void run() {
        if (!this.arena.isRunning() || this.arena.getPlayersInArena().isEmpty()) {
            return;
        }
        this.removeDeadMonsters();
        this.removeCheatingPlayers();
        if (!this.arena.isRunning()) {
            return;
        }
        int nextWave = this.waveManager.getWaveNumber() + 1;
        if (!this.isWaveClear()) {
            this.arena.scheduleTask(this, 60);
            return;
        }
        NewWaveEvent event = new NewWaveEvent(this.arena, this.waveManager.getNext(), nextWave);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.arena.scheduleTask(this, 60);
            return;
        }
        this.grantRewards(nextWave);
        if (nextWave > 1 && nextWave - 1 == this.waveManager.getFinalWave()) {
            ArrayList<Player> players = new ArrayList<Player>(this.arena.getPlayersInArena());
            for (Player p : players) {
                this.arena.playerLeave(p);
            }
            return;
        }
        this.spawnWave(nextWave);
        this.updateStats(nextWave);
        this.arena.scheduleTask(this, this.arena.getSettings().getInt("wave-interval", 3) * 20);
    }

    private void spawnWave(int wave) {
        Wave w = this.waveManager.next();
        w.announce(this.arena, wave);
        if (w.getType() == WaveType.UPGRADE) {
            this.handleUpgradeWave(w);
            return;
        }
        Map<MACreature, Integer> monsters = w.getMonstersToSpawn(wave, this.playerCount, this.arena);
        List<Location> spawnpoints = w.getSpawnpoints(this.arena);
        World world = this.arena.getWorld();
        int totalSpawnpoints = spawnpoints.size();
        int index = 0;
        double mul = w.getHealthMultiplier();
        for (Map.Entry<MACreature, Integer> entry : monsters.entrySet()) {
            int i = 0;
            while (i < entry.getValue()) {
                if (this.monsterManager.getMonsters().size() >= this.monsterLimit) {
                    return;
                }
                Location spawnpoint = spawnpoints.get(index % totalSpawnpoints);
                LivingEntity e = entry.getKey().spawn(this.arena, world, spawnpoint);
                this.monsterManager.addMonster(e);
                int health = (int)Math.max(1.0, (double)e.getMaxHealth() * mul);
                e.setHealth(Math.min(health, e.getMaxHealth()));
                switch (w.getType()) {
                    case BOSS: {
                        BossWave bw = (BossWave)w;
                        int maxHealth = bw.getMaxHealth(this.playerCount);
                        MABoss boss = this.monsterManager.addBoss(e, maxHealth);
                        bw.addMABoss(boss);
                        bw.activateAbilities(this.arena);
                        break;
                    }
                    case SWARM: {
                        health = (int)(mul < 1.0 ? (double)e.getMaxHealth() * mul : 1.0);
                        health = Math.max(1, health);
                        e.setHealth(Math.min(health, e.getMaxHealth()));
                        break;
                    }
                    case SUPPLY: {
                        SupplyWave sw = (SupplyWave)w;
                        this.monsterManager.addSupplier(e, sw.getDropList());
                        break;
                    }
                }
                ++i;
                ++index;
            }
        }
    }

    private void handleUpgradeWave(Wave w) {
        UpgradeWave uw = (UpgradeWave)w;
        for (Player p : this.arena.getPlayersInArena()) {
            String className = this.arena.getArenaPlayer(p).getArenaClass().getLowercaseName();
            uw.grantItems(p, className);
            uw.grantItems(p, "All");
        }
    }

    private boolean isWaveClear() {
        if (this.monsterManager.getMonsters().size() >= this.monsterLimit) {
            return false;
        }
        if (this.bossClear && !this.monsterManager.getBossMonsters().isEmpty()) {
            return false;
        }
        if (this.waveClear && !this.monsterManager.getMonsters().isEmpty()) {
            return false;
        }
        return this.monsterManager.getMonsters().isEmpty() || this.waveManager.getWaveNumber() != this.waveManager.getFinalWave();
    }

    private void removeDeadMonsters() {
        ArrayList<LivingEntity> tmp = new ArrayList<LivingEntity>(this.monsterManager.getMonsters());
        for (Entity entity : tmp) {
            if (entity == null || !entity.isDead() && this.region.contains(entity.getLocation())) continue;
            this.monsterManager.removeMonster(entity);
            entity.remove();
        }
    }

    private void removeCheatingPlayers() {
        ArrayList<Player> players = new ArrayList<Player>(this.arena.getPlayersInArena());
        for (Player p : players) {
            if (this.region.contains(p.getLocation())) continue;
            Location l = p.getLocation();
            System.out.println("Player: " + p.getName() + " found at location:" + l.getX() + ", " + l.getY() + ", " + l.getZ());
            Messenger.tellPlayer((CommandSender)p, "Leaving so soon?");
            p.getInventory().clear();
            this.arena.playerLeave(p);
        }
    }

    private void grantRewards(int wave) {
        for (Map.Entry<Integer, List<ItemStack>> entry : this.arena.getEveryWaveEntrySet()) {
            if (wave % entry.getKey() != 0) continue;
            this.addReward(entry.getValue());
        }
        List<ItemStack> after = this.arena.getAfterWaveReward(wave);
        if (after != null) {
            this.addReward(after);
        }
    }

    private void updateStats(int wave) {
        for (ArenaPlayer ap : this.arena.getArenaPlayerSet()) {
            if (!this.arena.getPlayersInArena().contains(ap.getPlayer())) continue;
            ap.getStats().inc("lastWave");
        }
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    private void addReward(List<ItemStack> rewards) {
        for (Player p : this.arena.getPlayersInArena()) {
            ItemStack reward = MAUtils.getRandomReward(rewards);
            this.rewardManager.addReward(p, reward);
            if (reward == null) {
                Messenger.tellPlayer((CommandSender)p, "ERROR! Problem with rewards. Notify server host!");
                Messenger.warning("Could not add null reward. Please check the config-file!");
                continue;
            }
            if (reward.getTypeId() == -29) {
                if (this.plugin.giveMoney(p, reward.getAmount())) {
                    Messenger.tellPlayer((CommandSender)p, Msg.WAVE_REWARD, this.plugin.economyFormat(reward.getAmount()));
                    continue;
                }
                Messenger.warning("Tried to add money, but no economy plugin detected!");
                continue;
            }
            Messenger.tellPlayer((CommandSender)p, Msg.WAVE_REWARD, MAUtils.toCamelCase(reward.getType().toString()) + ":" + reward.getAmount(), reward.getType());
        }
    }

    public void updateTargets() {
        for (Entity entity : this.monsterManager.getMonsters()) {
            LivingEntity target;
            if (!(entity instanceof Creature)) continue;
            Creature c = (Creature)entity;
            try {
                target = c.getTarget();
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (target instanceof Player && this.arena.getPlayersInArena().contains((Player)target)) continue;
            c.setTarget((LivingEntity)MAUtils.getClosestPlayer(this.plugin, entity, this.arena));
        }
    }
}

