/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.getspout.spoutapi.SpoutManager;
import org.getspout.spoutapi.player.SpoutPlayer;

public class Messenger {
    private static final Logger log = Logger.getLogger("Minecraft");
    private static final String prefix = "[MobArena] ";

    private Messenger() {
    }

    public static boolean tellSpoutPlayer(Player p, Msg msg, String s, Material logo) {
        SpoutPlayer sp;
        SpoutPlayer spoutPlayer = sp = MobArena.hasSpout ? SpoutManager.getPlayer((Player)p) : null;
        if (msg.hasSpoutMsg() && sp != null && sp.isSpoutCraftEnabled()) {
            String text = msg.toSpoutString(s);
            if (text.length() > 26) {
                text = text.substring(0, 26);
            }
            if (logo == null) {
                logo = msg.getLogo();
            }
            sp.sendNotification("MobArena", text, logo, (short)0, 2000);
            return true;
        }
        return Messenger.tellPlayer((CommandSender)p, msg.toString(s));
    }

    public static boolean tellSpoutPlayer(Player p, Msg msg, Material logo) {
        return Messenger.tellSpoutPlayer(p, msg, null, logo);
    }

    public static boolean tellSpoutPlayer(Player p, Msg msg, String s) {
        return Messenger.tellSpoutPlayer(p, msg, s, null);
    }

    public static boolean tellSpoutPlayer(Player p, Msg msg) {
        return Messenger.tellSpoutPlayer(p, msg, null, null);
    }

    public static boolean tellPlayer(CommandSender p, String msg) {
        if (p == null || msg.equals(" ")) {
            return false;
        }
        p.sendMessage(ChatColor.GREEN + prefix + ChatColor.WHITE + msg);
        return true;
    }

    public static boolean tellPlayer(CommandSender p, Msg msg, String s, boolean spout, Material logo) {
        if (spout && p instanceof Player) {
            return Messenger.tellSpoutPlayer((Player)p, msg, s, logo);
        }
        return Messenger.tellPlayer(p, msg.toString(s));
    }

    public static boolean tellPlayer(CommandSender p, Msg msg, String s, Material logo) {
        return Messenger.tellPlayer(p, msg, s, MobArena.hasSpout, logo);
    }

    public static boolean tellPlayer(CommandSender p, Msg msg, String s) {
        return Messenger.tellPlayer(p, msg, s, MobArena.hasSpout, null);
    }

    public static boolean tellPlayer(CommandSender p, Msg msg) {
        return Messenger.tellPlayer(p, msg, null, MobArena.hasSpout, null);
    }

    public static void tellAll(Arena arena, Msg msg, String s, boolean notifyPlayers) {
        ArrayList<Player> players = new ArrayList<Player>();
        players.addAll(arena.getPlayersInArena());
        players.addAll(arena.getPlayersInLobby());
        players.addAll(arena.getSpectators());
        for (Player p : players) {
            Messenger.tellPlayer((CommandSender)p, msg, s);
        }
    }

    public static void tellAll(Arena arena, Msg msg, String s) {
        Messenger.tellAll(arena, msg, s, false);
    }

    public static void tellAll(Arena arena, Msg msg, boolean notifyPlayers) {
        Messenger.tellAll(arena, msg, null, notifyPlayers);
    }

    public static void tellAll(Arena arena, Msg msg) {
        Messenger.tellAll(arena, msg, null, false);
    }

    public static void info(String msg) {
        log.info(prefix + msg);
    }

    public static void warning(String msg) {
        log.warning(prefix + msg);
    }

    public static void severe(String msg) {
        log.severe(prefix + msg);
    }
}

