/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaMasterImpl;
import com.garbagemule.MobArena.MAMessages;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.commands.CommandHandler;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.health.HealthStrategy;
import com.garbagemule.MobArena.health.HealthStrategyHeroes;
import com.garbagemule.MobArena.health.HealthStrategyStandard;
import com.garbagemule.MobArena.listeners.MAGlobalListener;
import com.garbagemule.MobArena.listeners.MagicSpellsListener;
import com.garbagemule.MobArena.listeners.SpoutScreenListener;
import com.garbagemule.MobArena.util.FileUtils;
import com.garbagemule.MobArena.util.config.Config;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import com.garbagemule.MobArena.util.inventory.InventoryManager;
import com.garbagemule.MobArena.waves.ability.AbilityManager;
import java.io.File;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MobArena
extends JavaPlugin {
    private Config config;
    private ArenaMaster arenaMaster;
    private Set<String> inventoriesToRestore;
    private boolean hasHeroes;
    private HealthStrategy healthStrategy;
    private Economy economy;
    public static boolean hasSpout;
    public static final double MIN_PLAYER_DISTANCE_SQUARED = 225.0;
    public static final int ECONOMY_MONEY_ID = -29;
    public static Random random;

    public void onEnable() {
        FileUtils.extractResource(this.getDataFolder(), "config.yml");
        this.loadConfigFile();
        this.loadAbilities();
        this.setupVault();
        this.setupHeroes();
        this.setupSpout();
        this.setupMagicSpells();
        this.setupStrategies();
        this.arenaMaster = new ArenaMasterImpl(this);
        this.arenaMaster.initialize();
        this.registerInventories();
        MAMessages.init(this);
        this.registerListeners();
        Messenger.info("v" + this.getDescription().getVersion() + " enabled.");
    }

    public void onDisable() {
        hasSpout = false;
        if (this.arenaMaster == null) {
            return;
        }
        for (Arena arena : this.arenaMaster.getArenas()) {
            arena.forceEnd();
        }
        this.arenaMaster.resetArenaMap();
        Messenger.info("disabled.");
    }

    private void loadConfigFile() {
        File dir = this.getDataFolder();
        if (!dir.exists()) {
            dir.mkdir();
        }
        File file = new File(this.getDataFolder(), "config.yml");
        this.config = new Config(file);
        if (!this.config.load()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            throw new IllegalStateException("The config-file could not be loaded! Read further up to find the actual bug!");
        }
        this.updateSettings(this.config);
        this.config.setHeader(this.getHeader());
        this.config.save();
    }

    private void registerListeners() {
        CommandHandler handler = new CommandHandler(this);
        this.getCommand("ma").setExecutor((CommandExecutor)handler);
        this.getCommand("mobarena").setExecutor((CommandExecutor)handler);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new MAGlobalListener(this, this.arenaMaster), (Plugin)this);
        if (hasSpout) {
            pm.registerEvents((Listener)new SpoutScreenListener(this), (Plugin)this);
        }
    }

    public boolean has(Player p, String s) {
        return p.hasPermission(s);
    }

    public boolean has(CommandSender sender, String s) {
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        return this.has((Player)sender, s);
    }

    private void setupVault() {
        Plugin vaultPlugin = this.getServer().getPluginManager().getPlugin("Vault");
        if (vaultPlugin == null) {
            Messenger.warning("Vault was not found. Economy rewards will not work!");
            return;
        }
        ServicesManager manager = this.getServer().getServicesManager();
        RegisteredServiceProvider e = manager.getRegistration(Economy.class);
        if (e != null) {
            this.economy = (Economy)e.getProvider();
        } else {
            Messenger.warning("Vault found, but no economy plugin detected. Economy rewards will not work!");
        }
    }

    private void setupHeroes() {
        Plugin heroesPlugin = this.getServer().getPluginManager().getPlugin("Heroes");
        if (heroesPlugin == null) {
            return;
        }
        this.hasHeroes = true;
    }

    private void setupSpout() {
        Plugin spoutPlugin = this.getServer().getPluginManager().getPlugin("Spout");
        if (spoutPlugin == null) {
            return;
        }
        hasSpout = true;
    }

    private void setupMagicSpells() {
        Plugin spells = this.getServer().getPluginManager().getPlugin("MagicSpells");
        if (spells == null) {
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)new MagicSpellsListener(this), (Plugin)this);
    }

    private void setupStrategies() {
        this.healthStrategy = this.hasHeroes ? new HealthStrategyHeroes() : new HealthStrategyStandard();
    }

    private void loadAbilities() {
        File dir = new File(this.getDataFolder(), "abilities");
        if (!dir.exists()) {
            dir.mkdir();
        }
        AbilityManager.loadAbilities(dir);
    }

    public HealthStrategy getHealthStrategy() {
        return this.healthStrategy;
    }

    public Config getMAConfig() {
        return this.config;
    }

    public ArenaMaster getArenaMaster() {
        return this.arenaMaster;
    }

    private void updateSettings(Config config) {
        Set<String> arenas = config.getKeys("arenas");
        if (arenas == null) {
            return;
        }
        for (String arena : arenas) {
            String path = "arenas." + arena + ".settings";
            ConfigUtils.replaceAllNodes(this, config, path, "settings.yml");
        }
    }

    private String getHeader() {
        String sep = System.getProperty("line.separator");
        return "MobArena v" + this.getDescription().getVersion() + " - Config-file" + sep + "Read the Wiki for details on how to set up this file: http://goo.gl/F5TTc" + sep + "Note: You -must- use spaces instead of tabs!\r";
    }

    private void registerInventories() {
        this.inventoriesToRestore = new HashSet<String>();
        File dir = new File(this.getDataFolder(), "inventories");
        if (!dir.exists()) {
            dir.mkdir();
            return;
        }
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith(".inv")) continue;
            this.inventoriesToRestore.add(f.getName().substring(0, f.getName().indexOf(".")));
        }
    }

    public void restoreInventory(Player p) {
        if (!this.inventoriesToRestore.contains(p.getName())) {
            return;
        }
        if (InventoryManager.restoreFromFile(this, p)) {
            this.inventoriesToRestore.remove(p.getName());
        }
    }

    public boolean giveMoney(Player p, int amount) {
        if (this.economy != null) {
            EconomyResponse result = this.economy.depositPlayer(p.getName(), (double)amount);
            return result.type == EconomyResponse.ResponseType.SUCCESS;
        }
        return false;
    }

    public boolean takeMoney(Player p, int amount) {
        if (this.economy != null) {
            EconomyResponse result = this.economy.withdrawPlayer(p.getName(), (double)amount);
            return result.type == EconomyResponse.ResponseType.SUCCESS;
        }
        return false;
    }

    public boolean hasEnough(Player p, double amount) {
        if (this.economy != null) {
            return this.economy.getBalance(p.getName()) >= amount;
        }
        return true;
    }

    public String economyFormat(double amount) {
        if (this.economy != null) {
            return this.economy.format(amount);
        }
        return null;
    }

    static {
        random = new Random();
    }
}

