/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.waves.MABoss;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;

public class MonsterManager {
    private Set<LivingEntity> monsters = new HashSet<LivingEntity>();
    private Set<LivingEntity> sheep = new HashSet<LivingEntity>();
    private Set<LivingEntity> golems = new HashSet<LivingEntity>();
    private Set<Wolf> pets = new HashSet<Wolf>();
    private Map<LivingEntity, MABoss> bosses = new HashMap<LivingEntity, MABoss>();
    private Map<LivingEntity, List<ItemStack>> suppliers = new HashMap<LivingEntity, List<ItemStack>>();

    public void reset() {
        this.monsters.clear();
        this.sheep.clear();
        this.golems.clear();
        this.pets.clear();
        this.bosses.clear();
        this.suppliers.clear();
    }

    public void clear() {
        this.removeAll(this.monsters);
        this.removeAll(this.sheep);
        this.removeAll(this.golems);
        this.removeAll(this.pets);
        this.removeAll(this.bosses.keySet());
        this.removeAll(this.suppliers.keySet());
        this.reset();
    }

    private void removeAll(Collection<? extends LivingEntity> collection) {
        for (LivingEntity livingEntity : collection) {
            if (livingEntity == null) continue;
            livingEntity.remove();
        }
    }

    public Set<LivingEntity> getMonsters() {
        return this.monsters;
    }

    public void addMonster(LivingEntity e) {
        this.monsters.add(e);
    }

    public boolean removeMonster(Entity e) {
        return this.monsters.remove(e);
    }

    public Set<LivingEntity> getExplodingSheep() {
        return this.sheep;
    }

    public void addExplodingSheep(LivingEntity e) {
        this.sheep.add(e);
    }

    public boolean removeExplodingSheep(LivingEntity e) {
        return this.sheep.remove(e);
    }

    public Set<LivingEntity> getGolems() {
        return this.golems;
    }

    public void addGolem(LivingEntity e) {
        this.golems.add(e);
    }

    public boolean removeGolem(LivingEntity e) {
        return this.golems.remove(e);
    }

    public Set<Wolf> getPets() {
        return this.pets;
    }

    public void addPet(Wolf w) {
        this.pets.add(w);
    }

    public boolean hasPet(Entity e) {
        return this.pets.contains(e);
    }

    public void removePets(Player p) {
        for (Wolf w : this.pets) {
            if (w == null || !(w.getOwner() instanceof Player) || !((Player)w.getOwner()).getName().equals(p.getName())) continue;
            w.setOwner(null);
            w.remove();
        }
    }

    public void addSupplier(LivingEntity e, List<ItemStack> drops) {
        this.suppliers.put(e, drops);
    }

    public List<ItemStack> getLoot(Entity e) {
        return this.suppliers.get(e);
    }

    public MABoss addBoss(LivingEntity e, int maxHealth) {
        MABoss b = new MABoss(e, maxHealth);
        this.bosses.put(e, b);
        return b;
    }

    public MABoss removeBoss(LivingEntity e) {
        return this.bosses.remove(e);
    }

    public MABoss getBoss(LivingEntity e) {
        return this.bosses.get(e);
    }

    public Set<LivingEntity> getBossMonsters() {
        return this.bosses.keySet();
    }
}

