/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RewardManager {
    private MobArena plugin;
    private Arena arena;
    private Map<Player, List<ItemStack>> players;
    private Set<Player> rewarded;

    public RewardManager(Arena arena) {
        this.plugin = arena.getPlugin();
        this.arena = arena;
        this.players = new HashMap<Player, List<ItemStack>>();
        this.rewarded = new HashSet<Player>();
    }

    public void reset() {
        this.players.clear();
        this.rewarded.clear();
    }

    public void addReward(Player p, ItemStack stack) {
        if (!this.players.containsKey(p)) {
            this.players.put(p, new ArrayList());
        }
        this.players.get(p).add(stack);
    }

    public List<ItemStack> getRewards(Player p) {
        List<ItemStack> rewards = this.players.get(p);
        return rewards == null ? new ArrayList(1) : Collections.unmodifiableList(rewards);
    }

    public void grantRewards(Player p) {
        if (this.rewarded.contains(p)) {
            return;
        }
        List<ItemStack> rewards = this.players.get(p);
        if (rewards == null) {
            return;
        }
        for (ItemStack stack : rewards) {
            if (stack == null || stack.getTypeId() == -29) continue;
            p.getInventory().addItem(new ItemStack[]{stack});
        }
        this.rewarded.add(p);
    }
}

