/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.commands.admin.DisableCommand;
import com.garbagemule.MobArena.commands.admin.EnableCommand;
import com.garbagemule.MobArena.commands.admin.ForceCommand;
import com.garbagemule.MobArena.commands.admin.KickCommand;
import com.garbagemule.MobArena.commands.admin.RestoreCommand;
import com.garbagemule.MobArena.commands.setup.AddArenaCommand;
import com.garbagemule.MobArena.commands.setup.AddClassPermCommand;
import com.garbagemule.MobArena.commands.setup.AddContainerCommand;
import com.garbagemule.MobArena.commands.setup.AddSpawnpointCommand;
import com.garbagemule.MobArena.commands.setup.ArenaCommand;
import com.garbagemule.MobArena.commands.setup.AutoDegenerateCommand;
import com.garbagemule.MobArena.commands.setup.AutoGenerateCommand;
import com.garbagemule.MobArena.commands.setup.CheckDataCommand;
import com.garbagemule.MobArena.commands.setup.ConfigCommand;
import com.garbagemule.MobArena.commands.setup.ContainersCommand;
import com.garbagemule.MobArena.commands.setup.EditArenaCommand;
import com.garbagemule.MobArena.commands.setup.ExpandLobbyRegionCommand;
import com.garbagemule.MobArena.commands.setup.ExpandRegionCommand;
import com.garbagemule.MobArena.commands.setup.ListClassPermsCommand;
import com.garbagemule.MobArena.commands.setup.ListClassesCommand;
import com.garbagemule.MobArena.commands.setup.ProtectCommand;
import com.garbagemule.MobArena.commands.setup.RemoveArenaCommand;
import com.garbagemule.MobArena.commands.setup.RemoveClassCommand;
import com.garbagemule.MobArena.commands.setup.RemoveClassPermCommand;
import com.garbagemule.MobArena.commands.setup.RemoveContainerCommand;
import com.garbagemule.MobArena.commands.setup.RemoveLeaderboardCommand;
import com.garbagemule.MobArena.commands.setup.RemoveSpawnpointCommand;
import com.garbagemule.MobArena.commands.setup.SetArenaCommand;
import com.garbagemule.MobArena.commands.setup.SetClassCommand;
import com.garbagemule.MobArena.commands.setup.SetLobbyRegionCommand;
import com.garbagemule.MobArena.commands.setup.SetRegionCommand;
import com.garbagemule.MobArena.commands.setup.SetWarpCommand;
import com.garbagemule.MobArena.commands.setup.ShowRegionCommand;
import com.garbagemule.MobArena.commands.setup.SpawnpointsCommand;
import com.garbagemule.MobArena.commands.user.ArenaListCommand;
import com.garbagemule.MobArena.commands.user.JoinCommand;
import com.garbagemule.MobArena.commands.user.LeaveCommand;
import com.garbagemule.MobArena.commands.user.NotReadyCommand;
import com.garbagemule.MobArena.commands.user.PlayerListCommand;
import com.garbagemule.MobArena.commands.user.SpecCommand;
import com.garbagemule.MobArena.framework.ArenaMaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandHandler
implements CommandExecutor {
    private MobArena plugin;
    private ArenaMaster am;
    private Map<String, Command> commands;

    public CommandHandler(MobArena plugin) {
        this.plugin = plugin;
        this.am = plugin.getArenaMaster();
        this.registerCommands();
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command bcmd, String label, String[] args) {
        String last;
        String base = args.length > 0 ? args[0] : "";
        String string = last = args.length > 0 ? args[args.length - 1] : "";
        if (base.equals("")) {
            Messenger.tellPlayer(sender, Msg.MISC_HELP);
            return true;
        }
        if (base.equals("?") || base.equals("help")) {
            this.showHelp(sender);
            return true;
        }
        List<Command> matches = this.getMatchingCommands(base);
        if (matches.size() > 1) {
            Messenger.tellPlayer(sender, Msg.MISC_MULTIPLE_MATCHES);
            for (Command cmd : matches) {
                this.showUsage(cmd, sender);
            }
            return true;
        }
        if (matches.size() == 0) {
            Messenger.tellPlayer(sender, Msg.MISC_NO_MATCHES);
            return true;
        }
        Command command = matches.get(0);
        CommandInfo info = command.getClass().getAnnotation(CommandInfo.class);
        if (!this.plugin.has(sender, info.permission())) {
            Messenger.tellPlayer(sender, Msg.MISC_NO_ACCESS);
            return true;
        }
        if (last.equals("?") || last.equals("help")) {
            this.showUsage(command, sender);
            return true;
        }
        String[] params = this.trimFirstArg(args);
        command.execute(this.am, sender, params);
        return true;
    }

    private List<Command> getMatchingCommands(String arg) {
        ArrayList<Command> result = new ArrayList<Command>();
        for (Map.Entry<String, Command> entry : this.commands.entrySet()) {
            if (!arg.matches(entry.getKey())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    private void showUsage(Command cmd, CommandSender sender) {
        CommandInfo info = cmd.getClass().getAnnotation(CommandInfo.class);
        if (!this.plugin.has(sender, info.permission())) {
            return;
        }
        Messenger.tellPlayer(sender, info.usage() + " " + ChatColor.YELLOW + info.desc());
    }

    private String[] trimFirstArg(String[] args) {
        return Arrays.copyOfRange(args, 1, args.length);
    }

    private void showHelp(CommandSender sender) {
        Messenger.tellPlayer(sender, "Available MobArena commands:");
        for (Command cmd : this.commands.values()) {
            this.showUsage(cmd, sender);
        }
    }

    private void registerCommands() {
        this.commands = new HashMap<String, Command>();
        this.register(ArenaListCommand.class);
        this.register(JoinCommand.class);
        this.register(LeaveCommand.class);
        this.register(NotReadyCommand.class);
        this.register(SpecCommand.class);
        this.register(PlayerListCommand.class);
        this.register(DisableCommand.class);
        this.register(EnableCommand.class);
        this.register(ForceCommand.class);
        this.register(KickCommand.class);
        this.register(RestoreCommand.class);
        this.register(AddArenaCommand.class);
        this.register(AddClassPermCommand.class);
        this.register(AddContainerCommand.class);
        this.register(AddSpawnpointCommand.class);
        this.register(ArenaCommand.class);
        this.register(CheckDataCommand.class);
        this.register(ConfigCommand.class);
        this.register(ContainersCommand.class);
        this.register(EditArenaCommand.class);
        this.register(ExpandLobbyRegionCommand.class);
        this.register(ExpandRegionCommand.class);
        this.register(ListClassesCommand.class);
        this.register(ListClassPermsCommand.class);
        this.register(ProtectCommand.class);
        this.register(RemoveArenaCommand.class);
        this.register(RemoveClassCommand.class);
        this.register(RemoveClassPermCommand.class);
        this.register(RemoveContainerCommand.class);
        this.register(RemoveLeaderboardCommand.class);
        this.register(RemoveSpawnpointCommand.class);
        this.register(SetArenaCommand.class);
        this.register(SetClassCommand.class);
        this.register(SetLobbyRegionCommand.class);
        this.register(SetRegionCommand.class);
        this.register(SetWarpCommand.class);
        this.register(ShowRegionCommand.class);
        this.register(SpawnpointsCommand.class);
        this.register(AutoGenerateCommand.class);
        this.register(AutoDegenerateCommand.class);
    }

    private void register(Class<? extends Command> c) {
        CommandInfo info = c.getAnnotation(CommandInfo.class);
        if (info == null) {
            return;
        }
        try {
            this.commands.put(info.pattern(), c.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

