/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.setup;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

@CommandInfo(name="editarena", pattern="edit(arena)?", usage="/ma editarena (<arena>) (true|false)", desc="set edit mode of an arena", permission="mobarena.setup.editarena")
public class EditArenaCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        Arena arena;
        String arg2;
        String arg1 = args.length > 0 ? args[0] : "";
        String string = arg2 = args.length > 1 ? args[1] : "";
        if (arg1.equals("")) {
            arena.setEditMode(!(arena = am.getSelectedArena()).inEditMode());
        } else if (arg2.equals("")) {
            if (arg1.matches("true|on") || arg1.matches("false|off")) {
                arena = am.getSelectedArena();
                arena.setEditMode(arg1.equals("true"));
            } else {
                arena = am.getArenaWithName(arg1);
                if (arena == null) {
                    Messenger.tellPlayer(sender, "There is no arena with that name.");
                    Messenger.tellPlayer(sender, "Usage: /ma editarena (true|false)");
                    Messenger.tellPlayer(sender, "    or /ma editarena <arena> (true|false)");
                    return true;
                }
                arena.setEditMode(!arena.inEditMode());
            }
        } else {
            if (!arg2.matches("true|on") && !arg2.matches("false|off")) {
                Messenger.tellPlayer(sender, "Usage: /ma editarena (true|false)");
                Messenger.tellPlayer(sender, "    or /ma editarena <arena> (true|false)");
                return true;
            }
            arena = am.getArenaWithName(arg1);
            if (arena == null) {
                Messenger.tellPlayer(sender, "There is no arena with that name.");
                Messenger.tellPlayer(sender, "Usage: /ma editarena (true|false)");
                Messenger.tellPlayer(sender, "    or /ma editarena <arena> (true|false)");
                return true;
            }
            arena.setEditMode(arg2.equals("true"));
        }
        Messenger.tellPlayer(sender, "Edit mode for arena '" + arena.configName() + "': " + (arena.inEditMode() ? ChatColor.GREEN + "true" : ChatColor.RED + "false"));
        if (arena.inEditMode()) {
            Messenger.tellPlayer(sender, "Remember to turn it back off after editing!");
        }
        return true;
    }
}

