/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.setup;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.util.TextUtils;
import java.util.Map;
import org.bukkit.command.CommandSender;

@CommandInfo(name="listclassperms", pattern="(list)?classperm(.*)s", usage="/ma listclassperms <classname>", desc="list per-class permissions", permission="mobarena.setup.classes")
public class ListClassPermsCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        String arg1;
        String string = arg1 = args.length > 0 ? args[0] : "";
        if (arg1.equals("")) {
            Messenger.tellPlayer(sender, "Usage: /ma listclassperms <classname>");
            return true;
        }
        ArenaClass arenaClass = am.getClasses().get(arg1);
        String className = TextUtils.camelCase(arg1);
        if (arenaClass == null) {
            Messenger.tellPlayer(sender, "The class '" + className + "' does not exist.");
            return true;
        }
        Messenger.tellPlayer(sender, "Permissions for '" + className + "':");
        Map<String, Boolean> perms = arenaClass.getPermissions();
        if (perms.isEmpty()) {
            Messenger.tellPlayer(sender, "<none>");
            return true;
        }
        for (Map.Entry<String, Boolean> entry : arenaClass.getPermissions().entrySet()) {
            String perm = entry.getKey();
            if (!entry.getValue().booleanValue()) {
                perm = "^" + perm;
            }
            Messenger.tellPlayer(sender, "- " + perm);
        }
        return true;
    }
}

