/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.setup;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.commands.Commands;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.util.TextUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandInfo(name="setclass", pattern="setclass|saveclass", usage="/ma setclass (safe) <classname>", desc="save your inventory as a class", permission="mobarena.setup.classes")
public class SetClassCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        if (!Commands.isPlayer(sender)) {
            Messenger.tellPlayer(sender, Msg.MISC_NOT_FROM_CONSOLE);
            return false;
        }
        String arg1 = args.length > 0 ? args[0] : "";
        String arg2 = args.length > 1 ? args[1] : "";
        Player p = (Player)sender;
        if (arg1.equals("")) {
            Messenger.tellPlayer((CommandSender)p, "Usage: /ma setclass (safe) <classname>");
            return true;
        }
        boolean safe = arg1.equals("safe");
        if (safe && arg2.equals("")) {
            Messenger.tellPlayer((CommandSender)p, "Usage: /ma setclass (safe) <classname>");
            return true;
        }
        String className = TextUtils.camelCase(safe ? arg2 : arg1);
        ArenaClass arenaClass = am.createClassNode(className, p.getInventory(), safe);
        if (arenaClass == null) {
            Messenger.tellPlayer((CommandSender)p, "That class already exists!");
            Messenger.tellPlayer((CommandSender)p, "To overwrite, omit the 'safe' parameter.");
            return true;
        }
        Messenger.tellPlayer((CommandSender)p, "Class '" + className + "' set with your current inventory.");
        return true;
    }
}

