/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.user;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.commands.Commands;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandInfo(name="join", pattern="j|jo.*|j.*n", usage="/ma join (<arena>)", desc="join an arena", permission="mobarena.use.join")
public class JoinCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        if (!Commands.isPlayer(sender)) {
            Messenger.tellPlayer(sender, Msg.MISC_NOT_FROM_CONSOLE);
            return false;
        }
        Player p = (Player)sender;
        String arg1 = args.length > 0 ? args[0] : null;
        Arena toArena = Commands.getArenaToJoinOrSpec(am, p, arg1);
        Arena fromArena = am.getArenaWithPlayer(p);
        if (toArena == null) {
            return false;
        }
        if (fromArena != null && (fromArena.inArena(p) || fromArena.inLobby(p))) {
            Messenger.tellPlayer((CommandSender)p, Msg.JOIN_ALREADY_PLAYING);
            return false;
        }
        if (!toArena.canJoin(p)) {
            return false;
        }
        return toArena.playerJoin(p, p.getLocation());
    }
}

