/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.leaderboards;

import com.garbagemule.MobArena.ArenaPlayerStatistics;
import com.garbagemule.MobArena.leaderboards.LeaderboardColumn;
import java.util.List;
import org.bukkit.block.Sign;

public abstract class AbstractLeaderboardColumn
implements LeaderboardColumn {
    protected String statname;
    private Sign header;
    private List<Sign> signs;

    public AbstractLeaderboardColumn(String statname, Sign header, List<Sign> signs) {
        this.statname = statname;
        this.header = header;
        this.signs = signs;
    }

    @Override
    public void update(List<ArenaPlayerStatistics> stats) {
        int range = Math.min(stats.size(), this.signs.size() * 4);
        for (int i = 0; i < range; ++i) {
            Sign s = this.signs.get(i / 4);
            String value = this.getLine(stats.get(i));
            s.setLine(i % 4, value);
            s.update();
        }
    }

    @Override
    public abstract String getLine(ArenaPlayerStatistics var1);

    @Override
    public void clear() {
        for (Sign s : this.signs) {
            s.setLine(0, "");
            s.setLine(1, "");
            s.setLine(2, "");
            s.setLine(3, "");
            s.update();
        }
    }

    @Override
    public Sign getHeader() {
        return this.header;
    }

    @Override
    public List<Sign> getSigns() {
        return this.signs;
    }
}

