/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.leaderboards;

import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.ArenaPlayerStatistics;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.leaderboards.AbstractLeaderboardColumn;
import com.garbagemule.MobArena.leaderboards.ClassLeaderboardColumn;
import com.garbagemule.MobArena.leaderboards.IntLeaderboardColumn;
import com.garbagemule.MobArena.leaderboards.LeaderboardColumn;
import com.garbagemule.MobArena.leaderboards.PlayerLeaderboardColumn;
import com.garbagemule.MobArena.leaderboards.Stats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.plugin.Plugin;

public class Leaderboard {
    private MobArena plugin;
    private Arena arena;
    private Location topLeft;
    private Sign topLeftSign;
    private BlockFace direction;
    private int rows;
    private int cols;
    private int trackingId;
    private List<LeaderboardColumn> boards;
    private List<ArenaPlayerStatistics> stats;
    private boolean isValid;

    private Leaderboard(MobArena plugin, Arena arena) {
        this.plugin = plugin;
        this.arena = arena;
        this.boards = new ArrayList<LeaderboardColumn>();
        this.stats = new ArrayList<ArenaPlayerStatistics>();
    }

    public Leaderboard(MobArena plugin, Arena arena, Location topLeft) {
        this(plugin, arena);
        if (topLeft == null) {
            return;
        }
        if (!(topLeft.getBlock().getState() instanceof Sign)) {
            throw new IllegalArgumentException("Block must be a sign!");
        }
        this.topLeft = topLeft;
    }

    public void initialize() {
        if (!this.isGridWellFormed()) {
            return;
        }
        this.initializeBoards();
        this.initializeStats();
        this.clear();
    }

    public void clear() {
        for (LeaderboardColumn column : this.boards) {
            column.clear();
        }
    }

    public void update() {
        Collections.sort(this.stats, ArenaPlayerStatistics.waveComparator());
        for (LeaderboardColumn column : this.boards) {
            column.update(this.stats);
        }
    }

    public void startTracking() {
        this.trackingId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Leaderboard.this.update();
            }
        }, 100L, 100L);
    }

    public void stopTracking() {
        this.plugin.getServer().getScheduler().cancelTask(this.trackingId);
    }

    private boolean isGridWellFormed() {
        if (this.topLeft == null) {
            return false;
        }
        BlockState state = this.topLeft.getBlock().getState();
        if (!(state instanceof Sign)) {
            Messenger.severe("Leaderboards for '" + this.arena.configName() + "' could not be established!");
            return false;
        }
        Sign current = this.topLeftSign = (Sign)state;
        this.direction = this.getRightDirection(current);
        this.rows = this.getSignCount(current, BlockFace.DOWN);
        this.cols = this.getSignCount(current, this.direction);
        if (this.rows <= 1 || this.cols <= 1) {
            return false;
        }
        Sign first = this.getAdjacentSign(current, BlockFace.DOWN);
        for (int i = 1; i < this.rows; ++i) {
            current = first;
            for (int j = 1; j < this.cols; ++j) {
                if ((current = this.getAdjacentSign(current, this.direction)) != null) continue;
                return false;
            }
            first = this.getAdjacentSign(first, BlockFace.DOWN);
        }
        return true;
    }

    private void initializeBoards() {
        this.boards.clear();
        Sign header = this.topLeftSign;
        do {
            String name;
            Stats stat;
            if ((stat = Stats.getByFullName(name = ChatColor.stripColor((String)header.getLine(2)))) == null) continue;
            ArrayList<Sign> signs = new ArrayList<Sign>();
            Sign current = header;
            for (int i = 1; i < this.rows; ++i) {
                current = this.getAdjacentSign(current, BlockFace.DOWN);
                signs.add(current);
            }
            AbstractLeaderboardColumn column = null;
            switch (stat) {
                case PLAYER_NAME: {
                    column = new PlayerLeaderboardColumn(stat.getShortName(), header, signs);
                    break;
                }
                case CLASS_NAME: {
                    column = new ClassLeaderboardColumn(stat.getShortName(), header, signs);
                    break;
                }
                default: {
                    column = new IntLeaderboardColumn(stat.getShortName(), header, signs);
                }
            }
            this.boards.add(column);
        } while ((header = this.getAdjacentSign(header, this.direction)) != null);
    }

    private void initializeStats() {
        this.stats.clear();
        for (ArenaPlayer ap : this.arena.getArenaPlayerSet()) {
            this.stats.add(ap.getStats());
        }
    }

    private int getSignCount(Sign s, BlockFace direction) {
        int i = 1;
        BlockState state = s.getBlock().getState();
        while ((state = state.getBlock().getRelative(direction).getState()) instanceof Sign) {
            ++i;
        }
        return i;
    }

    private Sign getAdjacentSign(Sign s, BlockFace direction) {
        BlockState state = s.getBlock().getRelative(direction).getState();
        if (state instanceof Sign) {
            return (Sign)state;
        }
        return null;
    }

    private BlockFace getRightDirection(Sign s) {
        byte data = s.getRawData();
        if (data == 2) {
            return BlockFace.NORTH;
        }
        if (data == 3) {
            return BlockFace.SOUTH;
        }
        if (data == 4) {
            return BlockFace.WEST;
        }
        if (data == 5) {
            return BlockFace.EAST;
        }
        return null;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

