/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.listeners;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.FileUtils;
import com.garbagemule.MobArena.util.config.Config;
import com.garbagemule.MobArena.waves.enums.WaveType;
import com.nisovin.magicspells.events.SpellCastEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class MagicSpellsListener
implements Listener {
    private MobArena plugin;
    private List<String> disabled;
    private List<String> disabledOnBoss;
    private List<String> disabledOnSwarm;

    public MagicSpellsListener(MobArena plugin) {
        this.plugin = plugin;
        File spellFile = FileUtils.extractResource(plugin.getDataFolder(), "magicspells.yml");
        Config spellConfig = new Config(spellFile);
        spellConfig.load();
        this.setupSpells(spellConfig);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onSpellCast(SpellCastEvent event) {
        WaveType type;
        Arena arena = this.plugin.getArenaMaster().getArenaWithPlayer(event.getCaster());
        if (arena == null || !arena.isRunning()) {
            return;
        }
        String spell = event.getSpell().getName();
        WaveType waveType = type = arena.getWave() != null ? arena.getWave().getType() : null;
        if (this.disabled.contains(spell) || type == WaveType.BOSS && this.disabledOnBoss.contains(spell) || type == WaveType.SWARM && this.disabledOnSwarm.contains(spell)) {
            event.setCancelled(true);
        }
    }

    private void setupSpells(Config config) {
        this.disabled = config.getStringList("disabled-spells", new LinkedList<String>());
        this.disabledOnBoss = config.getStringList("disabled-on-bosses", new LinkedList<String>());
        this.disabledOnSwarm = config.getStringList("disabled-on-swarms", new LinkedList<String>());
    }
}

