/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.log;

import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.log.ArenaLogPlayerEntry;
import com.garbagemule.MobArena.log.LogSessionBuilder;
import com.garbagemule.MobArena.log.LogTotalsBuilder;
import com.garbagemule.MobArena.util.MutableInt;
import java.util.HashMap;

public class ArenaLog {
    private Arena arena;
    private LogSessionBuilder sessionBuilder;
    private LogTotalsBuilder totalsBuilder;

    public ArenaLog(Arena arena, LogSessionBuilder sessionBuilder, LogTotalsBuilder totalsBuilder) {
        this.arena = arena;
        this.sessionBuilder = sessionBuilder;
        this.totalsBuilder = totalsBuilder;
    }

    public void start() {
        this.sessionBuilder.buildNumberOfPlayers(this.arena.getPlayersInArena().size());
        HashMap<String, MutableInt> classDistribution = new HashMap<String, MutableInt>();
        for (String classname : this.arena.getClasses().keySet()) {
            classDistribution.put(classname, new MutableInt());
        }
        for (ArenaPlayer ap : this.arena.getArenaPlayerSet()) {
            ((MutableInt)classDistribution.get(ap.getArenaClass().getLowercaseName())).inc();
        }
        this.sessionBuilder.buildClassDistribution(classDistribution);
        this.totalsBuilder.updateClassDistribution(classDistribution);
        this.sessionBuilder.buildStartTime();
        this.totalsBuilder.recordStartTime();
    }

    public void end() {
        this.sessionBuilder.buildEndTime();
        this.sessionBuilder.buildDuration();
        this.totalsBuilder.updateTimePlayed();
        this.totalsBuilder.updateSessionsPlayed();
        this.totalsBuilder.updateLastWave(this.arena.getWaveManager().getWaveNumber());
        this.sessionBuilder.finalize();
        this.totalsBuilder.finish();
    }

    public void playerDeath(ArenaPlayer ap) {
        ArenaLogPlayerEntry entry = ArenaLogPlayerEntry.create(ap);
        this.sessionBuilder.buildPlayerEntry(entry, this.arena.getRewardManager().getRewards(ap.getPlayer()));
        this.totalsBuilder.updatePlayerEntry(entry);
    }
}

