/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.log;

import com.garbagemule.MobArena.log.ArenaLogPlayerEntry;
import com.garbagemule.MobArena.log.LogSessionBuilder;
import com.garbagemule.MobArena.util.MutableInt;
import com.garbagemule.MobArena.util.TimeUtils;
import com.garbagemule.MobArena.util.config.Config;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class YMLSessionBuilder
implements LogSessionBuilder {
    private final String GENERAL = "general-info";
    private final String PLAYERS = "players";
    private final String CLASSES = "class-distribution";
    private Config config;
    private long start;
    private long end;

    public YMLSessionBuilder(File file) {
        this.config = new Config(file);
        this.reset();
    }

    @Override
    public void buildStartTime() {
        this.start = new Date().getTime();
        this.config.set("general-info.start-time", TimeUtils.toDateTime(this.start));
    }

    @Override
    public void buildEndTime() {
        this.end = new Date().getTime();
        this.config.set("general-info.end-time", TimeUtils.toDateTime(this.end));
    }

    @Override
    public void buildDuration() {
        String duration = TimeUtils.toTime(this.end - this.start);
        this.config.set("general-info.duration", duration);
    }

    @Override
    public void buildLastWave(int lastWave) {
        this.config.set("general-info.last-wave", lastWave);
    }

    @Override
    public void buildNumberOfPlayers(int amount) {
        this.config.set("general-info.number-of-players", amount);
    }

    @Override
    public void buildClassDistribution(Map<String, MutableInt> classDistribution) {
        for (Map.Entry<String, MutableInt> entry : classDistribution.entrySet()) {
            int amount = entry.getValue().value();
            this.config.set("class-distribution." + entry.getKey(), amount);
        }
    }

    @Override
    public void buildPlayerEntry(ArenaLogPlayerEntry entry, List<ItemStack> rewards) {
        String path = "players." + entry.playername + ".";
        this.config.set(path + "name", entry.playername);
        this.config.set(path + "class", entry.classname);
        this.config.set(path + "kills", entry.kills);
        this.config.set(path + "damage-done", entry.dmgDone);
        this.config.set(path + "damage-taken", entry.dmgTaken);
        this.config.set(path + "swings", entry.swings);
        this.config.set(path + "hits", entry.hits);
        this.config.set(path + "last-wave", entry.lastWave);
        this.config.set(path + "time-played", TimeUtils.toTime(entry.leaveTime - this.start));
        HashMap<String, MutableInt> summed = new HashMap<String, MutableInt>();
        for (ItemStack itemStack : rewards) {
            String type;
            if (itemStack == null) continue;
            String string = type = itemStack.getTypeId() == -29 ? "money" : itemStack.getType().toString().toLowerCase();
            if (!summed.containsKey(type)) {
                summed.put(type, new MutableInt());
            }
            ((MutableInt)summed.get(type)).add(itemStack.getAmount());
        }
        for (Map.Entry entry2 : summed.entrySet()) {
            this.config.set(path + "rewards." + (String)entry2.getKey(), ((MutableInt)entry2.getValue()).value());
        }
    }

    @Override
    public void finalize() {
        this.config.save();
        this.reset();
    }

    private void reset() {
        if (this.config.get("general-info") != null) {
            this.config.set("general-info", null);
        }
        if (this.config.get("class-distribution") != null) {
            this.config.set("class-distribution", null);
        }
        if (this.config.get("players") != null) {
            this.config.set("players", null);
        }
    }
}

