/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.log;

import com.garbagemule.MobArena.log.ArenaLogPlayerEntry;
import com.garbagemule.MobArena.log.LogTotalsBuilder;
import com.garbagemule.MobArena.util.MutableInt;
import com.garbagemule.MobArena.util.TimeUtils;
import com.garbagemule.MobArena.util.config.Config;
import java.io.File;
import java.util.Date;
import java.util.Map;

public class YMLTotalsBuilder
implements LogTotalsBuilder {
    private final String GENERAL = "general-info.";
    private final String PLAYERS = "players.";
    private final String CLASSES = "class-distribution.";
    private Config config;
    private long start;

    public YMLTotalsBuilder(File file) {
        this.config = new Config(file);
        if (file.exists()) {
            this.config.load();
        }
    }

    @Override
    public void recordStartTime() {
        this.start = new Date().getTime();
    }

    @Override
    public void updateSessionsPlayed() {
        String path = "general-info.sessions-played";
        int games = this.config.getInt(path, 0);
        this.config.set(path, games + 1);
    }

    @Override
    public void updateTimePlayed() {
        long end = new Date().getTime();
        String duration = TimeUtils.toTime(end - this.start);
        String path = "general-info.time-played";
        String old = this.config.getString(path, "00:00:00");
        this.config.set(path, TimeUtils.addTimes(old, duration));
    }

    @Override
    public void updateLastWave(int lastWave) {
        String path = "general-info.last-wave";
        int old = this.config.getInt(path, 0);
        this.config.set(path, Math.max(old, lastWave));
    }

    @Override
    public void updateClassDistribution(Map<String, MutableInt> classDistribution) {
        for (Map.Entry<String, MutableInt> entry : classDistribution.entrySet()) {
            String path = "class-distribution." + entry.getKey();
            int old = this.config.getInt(path, 0);
            int amount = entry.getValue().value();
            this.config.set(path, old + amount);
        }
    }

    @Override
    public void updatePlayerEntry(ArenaLogPlayerEntry entry) {
        String path = "players." + entry.playername + ".";
        this.config.set(path + "name", entry.playername);
        int old = this.config.getInt(path + "classes." + entry.classname, 0);
        this.config.set(path + "classes." + entry.classname, old + 1);
        old = this.config.getInt(path + "kills", 0);
        this.config.set(path + "kills", old + entry.kills);
        old = this.config.getInt(path + "damage-done", 0);
        this.config.set(path + "damage-done", old + entry.dmgDone);
        old = this.config.getInt(path + "damage-taken", 0);
        this.config.set(path + "damage-taken", old + entry.dmgTaken);
        old = this.config.getInt(path + "swings", 0);
        this.config.set(path + "swings", old + entry.swings);
        old = this.config.getInt(path + "hits", 0);
        this.config.set(path + "hits", old + entry.hits);
        old = this.config.getInt(path + "games-played", 0);
        this.config.set(path + "games-played", old + 1);
        old = this.config.getInt(path + "last-wave", 0);
        this.config.set(path + "last-wave", Math.max(old, entry.lastWave));
        long end = new Date().getTime();
        String session = TimeUtils.toTime(end - this.start);
        String played = this.config.getString(path + "time-played", "00:00:00");
        this.config.set(path + "time-played", TimeUtils.addTimes(played, session));
    }

    @Override
    public void finish() {
        this.config.save();
    }
}

