/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.region;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.config.ConfigSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArenaRegion {
    private Arena arena;
    private World world;
    private Location p1;
    private Location p2;
    private Location l1;
    private Location l2;
    private Location arenaWarp;
    private Location lobbyWarp;
    private Location specWarp;
    private Location leaderboard;
    private Map<String, Location> spawnpoints;
    private Map<String, Location> containers;
    private boolean setup;
    private boolean lobbySetup;
    private ConfigSection coords;
    private ConfigSection spawns;
    private ConfigSection chests;

    public ArenaRegion(ConfigSection coords, Arena arena) {
        this.arena = arena;
        this.world = arena.getWorld();
        this.coords = coords;
        this.spawns = coords.getConfigSection("spawnpoints");
        this.chests = coords.getConfigSection("containers");
        this.reloadAll();
        this.adjustRegion();
    }

    public void reloadAll() {
        this.reloadRegion();
        this.reloadWarps();
        this.reloadLeaderboards();
        this.reloadSpawnpoints();
        this.reloadChests();
        this.verifyData();
    }

    public void reloadRegion() {
        this.p1 = this.coords.getLocation("p1", this.world);
        this.p2 = this.coords.getLocation("p2", this.world);
        this.l1 = this.coords.getLocation("l1", this.world);
        this.l2 = this.coords.getLocation("l2", this.world);
    }

    public void reloadWarps() {
        this.arenaWarp = this.coords.getLocation("arena", this.world);
        this.lobbyWarp = this.coords.getLocation("lobby", this.world);
        this.specWarp = this.coords.getLocation("spectator", this.world);
        this.leaderboard = this.coords.getLocation("leaderboard", this.world);
    }

    public void reloadLeaderboards() {
        this.leaderboard = this.coords.getLocation("leaderboard", this.world);
    }

    public void reloadSpawnpoints() {
        this.spawnpoints = new HashMap<String, Location>();
        Set<String> keys = this.spawns.getKeys();
        if (keys != null) {
            for (String spwn : keys) {
                this.spawnpoints.put(spwn, this.spawns.getLocation(spwn, this.world));
            }
        }
    }

    public void reloadChests() {
        this.containers = new HashMap<String, Location>();
        Set<String> keys = this.chests.getKeys();
        if (keys != null) {
            for (String chst : keys) {
                this.containers.put(chst, this.chests.getLocation(chst, this.world));
            }
        }
    }

    public void verifyData() {
        this.setup = this.p1 != null && this.p2 != null && this.arenaWarp != null && this.lobbyWarp != null && this.specWarp != null && !this.spawnpoints.isEmpty();
        this.lobbySetup = this.l1 != null && this.l2 != null;
    }

    public void checkData(MobArena plugin, CommandSender s) {
        if (this.arenaWarp == null) {
            Messenger.tellPlayer(s, "Missing warp: arena");
        }
        if (this.lobbyWarp == null) {
            Messenger.tellPlayer(s, "Missing warp: lobby");
        }
        if (this.specWarp == null) {
            Messenger.tellPlayer(s, "Missing warp: spectator");
        }
        if (this.p1 == null) {
            Messenger.tellPlayer(s, "Missing region point: p1");
        }
        if (this.p2 == null) {
            Messenger.tellPlayer(s, "Missing region point: p2");
        }
        if (this.spawnpoints.isEmpty()) {
            Messenger.tellPlayer(s, "Missing spawnpoints");
        }
        if (this.setup) {
            Messenger.tellPlayer(s, "Arena is ready to be used!");
        }
    }

    public boolean isDefined() {
        return this.p1 != null && this.p2 != null;
    }

    public boolean isLobbyDefined() {
        return this.l1 != null && this.l2 != null;
    }

    public boolean isSetup() {
        return this.setup;
    }

    public boolean isLobbySetup() {
        return this.lobbySetup;
    }

    public boolean isWarp(Location l) {
        return l.equals((Object)this.arenaWarp) || l.equals((Object)this.lobbyWarp) || l.equals((Object)this.specWarp);
    }

    public boolean contains(Location l) {
        if (!l.getWorld().getName().equals(this.world.getName()) || !this.setup) {
            return false;
        }
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        if (this.lobbySetup && x >= this.l1.getBlockX() && x <= this.l2.getBlockX() && z >= this.l1.getBlockZ() && z <= this.l2.getBlockZ() && y >= this.l1.getBlockY() && y <= this.l2.getBlockY()) {
            return true;
        }
        return x >= this.p1.getBlockX() && x <= this.p2.getBlockX() && z >= this.p1.getBlockZ() && z <= this.p2.getBlockZ() && y >= this.p1.getBlockY() && y <= this.p2.getBlockY();
    }

    public boolean contains(Location l, int radius) {
        if (!l.getWorld().getName().equals(this.world.getName()) || !this.setup) {
            return false;
        }
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        if (this.lobbySetup && x + radius >= this.l1.getBlockX() && x - radius <= this.l2.getBlockX() && z + radius >= this.l1.getBlockZ() && z - radius <= this.l2.getBlockZ() && y + radius >= this.l1.getBlockY() && y - radius <= this.l2.getBlockY()) {
            return true;
        }
        return x + radius >= this.p1.getBlockX() && x - radius <= this.p2.getBlockX() && z + radius >= this.p1.getBlockZ() && z - radius <= this.p2.getBlockZ() && y + radius >= this.p1.getBlockY() && y - radius <= this.p2.getBlockY();
    }

    public void expandUp(int amount) {
        this.p2.setY(Math.min((double)this.arena.getWorld().getMaxHeight(), this.p2.getY() + (double)amount));
        this.set("p2", this.p2);
    }

    public void expandDown(int amount) {
        this.p1.setY(Math.max(0.0, this.p1.getY() - (double)amount));
        this.set("p1", this.p1);
    }

    public void expandP1(int x, int z) {
        this.p1.setX(this.p1.getX() - (double)x);
        this.p1.setZ(this.p1.getZ() - (double)z);
        this.set("p1", this.p1);
    }

    public void expandP2(int x, int z) {
        this.p2.setX(this.p2.getX() + (double)x);
        this.p2.setZ(this.p2.getZ() + (double)z);
        this.set("p2", this.p2);
    }

    public void expandOut(int amount) {
        this.expandP1(amount, amount);
        this.expandP2(amount, amount);
    }

    public void expandLobbyUp(int amount) {
        this.l2.setY(Math.min((double)this.arena.getWorld().getMaxHeight(), this.l2.getY() + (double)amount));
        this.set("l2", this.l2);
    }

    public void expandLobbyDown(int amount) {
        this.l1.setY(Math.max(0.0, this.l1.getY() + (double)amount));
        this.set("l1", this.l1);
    }

    public void expandL1(int x, int z) {
        this.l1.setX(this.l1.getX() - (double)x);
        this.l1.setZ(this.l1.getZ() - (double)z);
        this.set("l1", this.l1);
    }

    public void expandL2(int x, int z) {
        this.l2.setX(this.l2.getX() + (double)x);
        this.l2.setZ(this.l2.getZ() + (double)z);
        this.set("l2", this.l2);
    }

    public void expandLobbyOut(int amount) {
        this.expandL1(amount, amount);
        this.expandL2(amount, amount);
    }

    public void fixRegion() {
        this.fix("p1", "p2");
    }

    public void fixLobbyRegion() {
        this.fix("l1", "l2");
    }

    private void fix(String location1, String location2) {
        double tmp;
        Location loc1 = this.coords.getLocation(location1, this.world);
        Location loc2 = this.coords.getLocation(location2, this.world);
        if (loc1 == null || loc2 == null) {
            return;
        }
        if (loc1.getX() > loc2.getX()) {
            tmp = loc1.getX();
            loc1.setX(loc2.getX());
            loc2.setX(tmp);
        }
        if (loc1.getZ() > loc2.getZ()) {
            tmp = loc1.getZ();
            loc1.setZ(loc2.getZ());
            loc2.setZ(tmp);
        }
        if (loc1.getY() > loc2.getY()) {
            tmp = loc1.getY();
            loc1.setY(loc2.getY());
            loc2.setY(tmp);
        }
        if (!this.arena.getWorld().getName().equals(this.world.getName())) {
            this.arena.setWorld(this.world);
        }
        this.coords.set(location1, loc1);
        this.coords.set(location2, loc2);
    }

    private void adjustRegion() {
        if (!this.setup) {
            return;
        }
        this.readjustRegion(this.arenaWarp);
        for (Location spawnpoint : this.spawnpoints.values()) {
            this.readjustRegion(spawnpoint);
        }
        for (Location chest : this.containers.values()) {
            this.readjustRegion(chest);
        }
    }

    private void readjustRegion(Location l) {
        if (this.p1 == null || this.p2 == null) {
            return;
        }
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        int p1x = this.p1.getBlockX();
        int p1y = this.p1.getBlockY();
        int p1z = this.p1.getBlockZ();
        int p2x = this.p2.getBlockX();
        int p2y = this.p2.getBlockY();
        int p2z = this.p2.getBlockZ();
        if (x <= p1x) {
            this.expandP1(p1x - x + 2, 0);
        } else if (x >= p2x) {
            this.expandP2(x - p2x + 2, 0);
        }
        if (y <= p1y) {
            this.expandDown(p1y - y + 2);
        } else if (y >= p2y) {
            this.expandUp(y - p2y + 2);
        }
        if (z <= p1z) {
            this.expandP1(0, p1z - z + 2);
        } else if (z >= p2z) {
            this.expandP2(0, z - p2z + 2);
        }
    }

    public List<Chunk> getChunks() {
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        if (this.p1 == null || this.p2 == null) {
            return result;
        }
        Chunk c1 = this.world.getChunkAt(this.p1);
        Chunk c2 = this.world.getChunkAt(this.p2);
        for (int i = c1.getX(); i <= c2.getX(); ++i) {
            for (int j = c1.getZ(); j <= c2.getZ(); ++j) {
                result.add(this.world.getChunkAt(i, j));
            }
        }
        return result;
    }

    public Location getArenaWarp() {
        return this.arenaWarp;
    }

    public Location getLobbyWarp() {
        return this.lobbyWarp;
    }

    public Location getSpecWarp() {
        return this.specWarp;
    }

    public Location getSpawnpoint(String name) {
        return this.spawnpoints.get(name);
    }

    public Collection<Location> getSpawnpoints() {
        return this.spawnpoints.values();
    }

    public List<Location> getSpawnpointList() {
        return new ArrayList<Location>(this.spawnpoints.values());
    }

    public Collection<Location> getContainers() {
        return this.containers.values();
    }

    public Location getLeaderboard() {
        return this.leaderboard;
    }

    public void set(String point, Location loc) {
        this.coords.set(point, loc);
        if (point.equals("arena") || point.equals("lobby") || point.equals("spectator")) {
            this.readjustRegion(loc);
        }
        this.fixRegion();
        this.fixLobbyRegion();
        this.reloadRegion();
        this.reloadWarps();
        this.reloadLeaderboards();
        this.verifyData();
        this.save();
    }

    public void addSpawn(String name, Location loc) {
        this.spawns.set(name, loc);
        this.readjustRegion(loc);
        this.reloadSpawnpoints();
        this.verifyData();
        this.save();
    }

    public boolean removeSpawn(String name) {
        if (this.spawns.getString(name) == null) {
            return false;
        }
        this.spawns.set(name, null);
        this.reloadSpawnpoints();
        this.verifyData();
        this.save();
        return true;
    }

    public void addChest(String name, Location loc) {
        this.chests.set(name, loc);
        this.reloadChests();
        this.save();
    }

    public boolean removeChest(String name) {
        if (this.chests.getString(name) == null) {
            return false;
        }
        this.chests.set(name, null);
        this.reloadChests();
        this.save();
        return true;
    }

    public void save() {
        this.spawns.getParent().save();
    }

    public void showRegion(final Player p) {
        if (!this.isDefined()) {
            return;
        }
        final HashMap<Location, BlockState> blocks = new HashMap<Location, BlockState>();
        for (Location l : this.getFramePoints()) {
            Block b = l.getBlock();
            blocks.put(l, b.getState());
            p.sendBlockChange(l, 35, (byte)14);
        }
        this.arena.scheduleTask(new Runnable(){

            @Override
            public void run() {
                if (!p.isOnline()) {
                    return;
                }
                for (Map.Entry entry : blocks.entrySet()) {
                    Location l = (Location)entry.getKey();
                    BlockState b = (BlockState)entry.getValue();
                    int id = b.getTypeId();
                    byte data = b.getRawData();
                    p.sendBlockChange(l, id, data);
                }
            }
        }, 100);
    }

    private List<Location> getFramePoints() {
        ArrayList<Location> result = new ArrayList<Location>();
        int x1 = this.p1.getBlockX();
        int y1 = this.p1.getBlockY();
        int z1 = this.p1.getBlockZ();
        int x2 = this.p2.getBlockX();
        int y2 = this.p2.getBlockY();
        int z2 = this.p2.getBlockZ();
        for (int i = x1; i <= x2; ++i) {
            result.add(this.world.getBlockAt(i, y1, z1).getLocation());
            result.add(this.world.getBlockAt(i, y1, z2).getLocation());
            result.add(this.world.getBlockAt(i, y2, z1).getLocation());
            result.add(this.world.getBlockAt(i, y2, z2).getLocation());
        }
        for (int j = y1; j <= y2; ++j) {
            result.add(this.world.getBlockAt(x1, j, z1).getLocation());
            result.add(this.world.getBlockAt(x1, j, z2).getLocation());
            result.add(this.world.getBlockAt(x2, j, z1).getLocation());
            result.add(this.world.getBlockAt(x2, j, z2).getLocation());
        }
        for (int k = z1; k <= z2; ++k) {
            result.add(this.world.getBlockAt(x1, y1, k).getLocation());
            result.add(this.world.getBlockAt(x1, y2, k).getLocation());
            result.add(this.world.getBlockAt(x2, y1, k).getLocation());
            result.add(this.world.getBlockAt(x2, y2, k).getLocation());
        }
        return result;
    }
}

