/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileUtils {
    public static List<File> extractResources(File dir, List<String> resources) {
        return FileUtils.extractResources(dir, "", resources);
    }

    public static List<File> extractResources(File dir, String path, List<String> filenames) {
        ArrayList<File> files = new ArrayList<File>();
        if (!path.equals("")) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
        }
        for (String filename : filenames) {
            File file = FileUtils.extractResource(dir, path + filename);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    public static List<File> extractResources(File dir, String ... resources) {
        return FileUtils.extractResources(dir, Arrays.asList(resources));
    }

    public static File extractResource(File dir, String resource) {
        String filename;
        File file;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((file = new File(dir, filename = FileUtils.getFilename(resource))).exists()) {
            return file;
        }
        InputStream in = MobArena.class.getResourceAsStream("/res/" + resource);
        if (in == null) {
            return null;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
            in.close();
            out.close();
            return file;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> listFilesOnPath(String path, String ext) {
        try {
            File file = new File("plugins" + File.separator + "MobArena.jar");
            if (file == null || !file.exists()) {
                return null;
            }
            JarFile jarFile = new JarFile(file);
            ArrayList<String> result = new ArrayList<String>();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (ext == null) {
                ext = "";
            } else if (!ext.startsWith(".")) {
                ext = "." + ext;
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(path) || !name.endsWith(ext)) continue;
                result.add(FileUtils.getFilename(name));
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>(1);
        }
    }

    private static String getFilename(String resource) {
        int slash = resource.lastIndexOf("/");
        return slash < 0 ? resource : resource.substring(slash + 1);
    }

    public static YamlConfiguration getConfig(MobArena plugin, String filename) {
        InputStream in = MobArena.class.getResourceAsStream("/res/" + filename);
        if (in == null) {
            Messenger.severe("Failed to load '" + filename + "', the server must be restarted!");
            return null;
        }
        try {
            YamlConfiguration result = new YamlConfiguration();
            result.load(in);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            Messenger.warning("Couldn't load '" + filename + "' as stream!");
            return null;
        }
    }
}

