/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class ItemParser {
    public static String parseString(ItemStack ... stacks) {
        String result = "";
        for (ItemStack stack : stacks) {
            if (stack == null || stack.getTypeId() == 0) continue;
            result = result + ", " + ItemParser.parseString(stack);
        }
        if (!result.equals("")) {
            result = result.substring(2);
        }
        return result;
    }

    public static String parseString(ItemStack stack) {
        byte data;
        if (stack.getTypeId() == 0) {
            return null;
        }
        String type = stack.getType().toString().toLowerCase();
        MaterialData md = stack.getData();
        byte by = data = md != null ? md.getData() : (byte)0;
        if (stack.getType() == Material.WOOL) {
            data = (byte)(15 - data);
        }
        int amount = stack.getAmount();
        String enchantments = "";
        for (Map.Entry entry : stack.getEnchantments().entrySet()) {
            int id = ((Enchantment)entry.getKey()).getId();
            int lvl = (Integer)entry.getValue();
            enchantments = enchantments + ";" + id + ":" + lvl;
        }
        if (!enchantments.equals("")) {
            enchantments = enchantments.substring(1);
        }
        String result = type;
        if (data != 0) {
            result = result + ":" + data;
        }
        if (amount > 1 || data != 0) {
            result = result + ":" + amount;
        }
        if (!enchantments.equals("")) {
            result = result + " " + enchantments;
        }
        return result;
    }

    public static List<ItemStack> parseItems(String s) {
        if (s == null) {
            return new ArrayList<ItemStack>(1);
        }
        String[] items = s.split(",");
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(items.length);
        for (String item : items) {
            ItemStack stack = ItemParser.parseItem(item.trim());
            if (stack == null) continue;
            result.add(stack);
        }
        return result;
    }

    public static ItemStack parseItem(String item) {
        if (item == null || item.equals("")) {
            return null;
        }
        String[] space = item.split(" ");
        String[] parts = space.length == 2 ? space[0].split(":") : item.split(":");
        ItemStack result = null;
        switch (parts.length) {
            case 1: {
                result = ItemParser.singleItem(parts[0]);
                break;
            }
            case 2: {
                result = ItemParser.withAmount(parts[0], parts[1]);
                break;
            }
            case 3: {
                result = ItemParser.withDataAndAmount(parts[0], parts[1], parts[2]);
            }
        }
        if (space.length == 2) {
            ItemParser.addEnchantments(result, space[1]);
        }
        return result;
    }

    private static ItemStack singleItem(String item) {
        if (item.matches("\\$[1-9][0-9]*")) {
            int amount = Integer.parseInt(item.substring(1));
            return new ItemStack(-29, amount);
        }
        Material m = ItemParser.getMaterial(item);
        return m == null ? null : new ItemStack(m, 1);
    }

    private static ItemStack withAmount(String item, String amount) {
        Material m = ItemParser.getMaterial(item);
        int a = ItemParser.getAmount(amount);
        return m == null ? null : new ItemStack(m, a);
    }

    private static ItemStack withDataAndAmount(String item, String data, String amount) {
        Material m = ItemParser.getMaterial(item);
        short d = ItemParser.getData(data, m);
        int a = ItemParser.getAmount(amount);
        if (m == null) {
            return null;
        }
        if (m.getId() == 35) {
            d = (byte)(15 - d);
        }
        return new ItemStack(m, a, d);
    }

    private static Material getMaterial(String item) {
        if (item.matches("[0-9]*")) {
            return Material.getMaterial((int)Integer.parseInt(item));
        }
        return Material.getMaterial((String)item.toUpperCase());
    }

    private static int getAmount(String amount) {
        if (amount.matches("(-)?[1-9][0-9]*")) {
            return Integer.parseInt(amount);
        }
        return 1;
    }

    private static short getData(String data, Material m) {
        if (m == Material.INK_SACK || m == Material.WOOL) {
            int offset = m == Material.INK_SACK ? 15 : 0;
            DyeColor dye = data.matches("[0-9]+") ? DyeColor.getByData((byte)((byte)Math.abs(offset - Integer.parseInt(data)))) : DyeColor.valueOf((String)data.toUpperCase());
            return (short)Math.abs(offset - dye.getData());
        }
        return Short.parseShort(data);
    }

    private static void addEnchantments(ItemStack stack, String list) {
        String[] parts;
        for (String ench : parts = list.split(";")) {
            ItemParser.addEnchantment(stack, ench.trim());
        }
    }

    private static void addEnchantment(ItemStack stack, String ench) {
        String[] parts = ench.split(":");
        if (parts.length != 2 || !parts[0].matches("[0-9]*") || !parts[1].matches("[0-9]*")) {
            return;
        }
        int id = Integer.parseInt(parts[0]);
        int lvl = Integer.parseInt(parts[1]);
        Enchantment e = Enchantment.getById((int)id);
        if (e == null) {
            return;
        }
        stack.addUnsafeEnchantment(e, lvl);
    }
}

