/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util;

import com.garbagemule.MobArena.MobArena;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionChecker {
    public static String site = "http://forums.bukkit.org/threads/19144/";

    public static boolean isLatest(MobArena plugin) {
        if (!plugin.getMAConfig().getBoolean("global-settings.update-notification", false)) {
            return true;
        }
        try {
            URI baseURI = new URI(site);
            HttpURLConnection con = (HttpURLConnection)baseURI.toURL().openConnection();
            con.setConnectTimeout(5000);
            con.setInstanceFollowRedirects(false);
            String header = con.getHeaderField("Location");
            if (header == null) {
                return true;
            }
            String url = new URI(con.getHeaderField("Location")).toString();
            Pattern regex = Pattern.compile("v([0-9]+-)*[0-9]+");
            Matcher matcher = regex.matcher(url);
            if (!matcher.find()) {
                return true;
            }
            String thisVersion = plugin.getDescription().getVersion();
            String forumVersion = matcher.group().substring(1).replace("-", ".");
            return VersionChecker.isLatest(thisVersion, forumVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static boolean isLatest(String thisVersion, String forumVersion) {
        String[] forumParts = forumVersion.split("\\.");
        String[] thisParts = thisVersion.split("\\.");
        boolean thisIsNewer = false;
        for (int i = 0; i < Math.max(forumParts.length, thisParts.length); ++i) {
            int current;
            int forum = forumParts.length <= i ? 0 : Integer.parseInt(forumParts[i]);
            int n = current = thisParts.length <= i ? 0 : Integer.parseInt(thisParts[i]);
            if (forum < current) {
                thisIsNewer = true;
            }
            if (forum <= current || thisIsNewer) continue;
            return false;
        }
        return true;
    }
}

