/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.config;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.util.config.ConfigSection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class Config {
    private YamlConfiguration config = new YamlConfiguration();
    private File configFile;
    private Map<String, Boolean> booleans;
    private Map<String, Integer> ints;
    private Map<String, Double> doubles;
    private Map<String, String> strings;
    private Map<String, ItemStack> items;

    public Config(File configFile) {
        this.configFile = configFile;
        this.booleans = new HashMap<String, Boolean>();
        this.ints = new HashMap<String, Integer>();
        this.doubles = new HashMap<String, Double>();
        this.strings = new HashMap<String, String>();
        this.items = new HashMap<String, ItemStack>();
        this.config.options().indent(4);
    }

    public boolean load() {
        try {
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
            }
            this.config.load(this.configFile);
            this.reloadMaps();
            return true;
        }
        catch (Exception e) {
            Messenger.severe("The config-file failed to load. This is the error:\n" + e.getMessage());
            return false;
        }
    }

    public void reloadMaps() {
        for (String s : this.config.getKeys(true)) {
            Object o = this.config.get(s);
            if (o instanceof Boolean) {
                this.booleans.put(s, (Boolean)o);
                continue;
            }
            if (o instanceof Integer) {
                this.ints.put(s, (Integer)o);
                continue;
            }
            if (o instanceof Double) {
                this.doubles.put(s, (Double)o);
                continue;
            }
            if (o instanceof ItemStack) {
                this.items.put(s, (ItemStack)o);
                continue;
            }
            if (!(o instanceof String)) continue;
            this.strings.put(s, (String)o);
        }
    }

    public boolean save() {
        try {
            this.config.save(this.configFile);
            this.load();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getHeader() {
        return this.config.options().header();
    }

    public void setHeader(String header) {
        this.config.options().header(header);
    }

    public YamlConfiguration getYamlConfiguration() {
        return this.config;
    }

    public ConfigSection getConfigSection(String node) {
        if (this.get(node) != null) {
            return new ConfigSection(this, node);
        }
        return null;
    }

    public Object get(String path) {
        return this.config.get(path);
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, false);
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean result = this.booleans.get(path);
        return result != null ? result : def;
    }

    public int getInt(String path) {
        return this.getInt(path, 0);
    }

    public int getInt(String path, int def) {
        Integer result = this.ints.get(path);
        return result != null ? result : def;
    }

    public double getDouble(String path) {
        return this.getDouble(path, 0.0);
    }

    public double getDouble(String path, double def) {
        Double result = this.doubles.get(path);
        return result != null ? result : def;
    }

    public String getString(String path) {
        return this.getString(path, null);
    }

    public String getString(String path, String def) {
        String result = this.strings.get(path);
        return result != null ? result : def;
    }

    public Location getLocation(String path, World world) {
        return this.getLocation(path, world, null);
    }

    public Location getLocation(String path, World world, Location def) {
        String string = this.getString(path);
        if (string == null) {
            return def;
        }
        return Config.parseLocation(world, string);
    }

    public ItemStack getItemStack(String path) {
        return this.getItemStack(path, null);
    }

    public ItemStack getItemStack(String path, ItemStack def) {
        ItemStack result = this.items.get(path);
        return result != null ? result : def;
    }

    public Set<String> getKeys(String path) {
        if (this.config.get(path) == null) {
            return null;
        }
        ConfigurationSection section = this.config.getConfigurationSection(path);
        if (section == null) {
            return null;
        }
        return section.getKeys(false);
    }

    public List<String> getStringList(String path, List<String> def) {
        if (this.config.get(path) == null) {
            return def != null ? def : new ArrayList();
        }
        List list = this.config.getStringList(path);
        return list;
    }

    public void set(String path, Object value) {
        if (value instanceof Boolean) {
            this.booleans.put(path, (Boolean)value);
        } else if (value instanceof Integer) {
            this.ints.put(path, (Integer)value);
        } else if (value instanceof Double) {
            this.doubles.put(path, (Double)value);
        } else if (value instanceof ItemStack) {
            this.items.put(path, (ItemStack)value);
        } else if (value instanceof String) {
            this.strings.put(path, (String)value);
        } else if (value instanceof Location) {
            value = Config.locationToString((Location)value);
            this.strings.put(path, value.toString());
        }
        if (value == null) {
            this.booleans.remove(path);
            this.ints.remove(path);
            this.doubles.remove(path);
            this.strings.remove(path);
            this.items.remove(path);
        }
        this.config.set(path, value);
    }

    public void remove(String path) {
        this.set(path, null);
    }

    public static Location parseSimpleLocation(World world, String coords) {
        String[] parts = coords.split(",");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Input string must contain only x, y, and z");
        }
        Integer x = Config.parseInteger(parts[0]);
        Integer y = Config.parseInteger(parts[1]);
        Integer z = Config.parseInteger(parts[2]);
        if (x == null || y == null || z == null) {
            throw new NullPointerException("Some of the parsed values are null!");
        }
        return new Location(world, (double)x.intValue(), (double)y.intValue(), (double)z.intValue());
    }

    public static Location parseLocation(World world, String coords) {
        String[] parts = coords.split(",");
        if (parts.length != 5) {
            throw new IllegalArgumentException("Input string must contain x, y, z, yaw and pitch");
        }
        Integer x = Config.parseInteger(parts[0]);
        Integer y = Config.parseInteger(parts[1]);
        Integer z = Config.parseInteger(parts[2]);
        Float yaw = Config.parseFloat(parts[3]);
        Float pitch = Config.parseFloat(parts[4]);
        if (x == null || y == null || z == null || yaw == null || pitch == null) {
            throw new NullPointerException("Some of the parsed values are null!");
        }
        return new Location(world, (double)x.intValue(), (double)y.intValue(), (double)z.intValue(), yaw.floatValue(), pitch.floatValue());
    }

    public static String locationToString(Location loc) {
        StringBuffer result = new StringBuffer();
        result.append(loc.getBlockX() + ",");
        result.append(loc.getBlockY() + ",");
        result.append(loc.getBlockZ() + ",");
        result.append(loc.getYaw() + ",");
        result.append(loc.getPitch());
        return result.toString();
    }

    private static Integer parseInteger(String s) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Float parseFloat(String s) {
        try {
            return Float.valueOf(Float.parseFloat(s.trim()));
        }
        catch (Exception e) {
            return null;
        }
    }
}

