/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.config;

import com.garbagemule.MobArena.util.config.Config;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.ItemStack;

public class ConfigSection {
    private Config config;
    private String path;

    public ConfigSection(Config config, String path) {
        this.config = config;
        this.path = path.endsWith(".") ? path : path + ".";
    }

    public Config getParent() {
        return this.config;
    }

    public ConfigSection getConfigSection(String path) {
        return new ConfigSection(this.config, this.path + path);
    }

    public Object get(String node) {
        return this.config.get(this.path + node);
    }

    public int getInt(String node) {
        return this.config.getInt(this.path + node);
    }

    public int getInt(String node, int def) {
        return this.config.getInt(this.path + node, def);
    }

    public double getDouble(String node) {
        return this.config.getDouble(this.path + node);
    }

    public double getDouble(String node, double def) {
        return this.config.getDouble(this.path + node, def);
    }

    public boolean getBoolean(String node) {
        return this.config.getBoolean(this.path + node);
    }

    public boolean getBoolean(String node, boolean def) {
        return this.config.getBoolean(this.path + node, def);
    }

    public String getString(String node) {
        return this.config.getString(this.path + node);
    }

    public String getString(String node, String def) {
        return this.config.getString(this.path + node, def);
    }

    public Location getLocation(String node, World world) {
        return this.config.getLocation(this.path + node, world);
    }

    public Location getLocation(String node, World world, Location def) {
        return this.config.getLocation(this.path + node, world, def);
    }

    public ItemStack getItemStack(String path) {
        return this.config.getItemStack(path);
    }

    public ItemStack getItemStack(String path, ItemStack def) {
        return this.config.getItemStack(path, def);
    }

    public Set<String> getKeys() {
        return this.config.getKeys(this.path);
    }

    public Set<String> getKeys(String node) {
        return this.config.getKeys(this.path + node);
    }

    public List<String> getStringList(String node, List<String> def) {
        return this.config.getStringList(this.path + node, def);
    }

    public void set(String node, Object value) {
        this.config.set(this.path + node, value);
    }
}

