/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.config;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.FileUtils;
import com.garbagemule.MobArena.util.config.Config;
import com.garbagemule.MobArena.util.config.ConfigSection;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUtils {
    public static void addMissingNodes(MobArena plugin, Config config, String path, String filename) {
        ConfigUtils.assertNodes(plugin, config, path, filename, true);
    }

    public static void replaceAllNodes(MobArena plugin, Config config, String path, String filename) {
        ConfigUtils.assertNodes(plugin, config, path, filename, false);
    }

    private static void assertNodes(MobArena plugin, Config config, String path, String filename, boolean keepOthers) {
        ConfigSection section = config.getConfigSection(path);
        if (section == null) {
            config.set(path, "");
            section = config.getConfigSection(path);
        }
        YamlConfiguration ymlConfig = FileUtils.getConfig(plugin, filename);
        ConfigUtils.assertNodes(section, ymlConfig, keepOthers);
    }

    private static void assertNodes(ConfigSection config, YamlConfiguration ymlConfig, boolean keepOthers) {
        if (config == null || ymlConfig == null) {
            return;
        }
        Set keys = ymlConfig.getKeys(false);
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            if (config.get(key) != null) continue;
            Object o = ymlConfig.get(key);
            config.set(key, o);
        }
        if (keepOthers) {
            return;
        }
        Set<String> oldKeys = config.getKeys();
        if (oldKeys == null || oldKeys.isEmpty()) {
            return;
        }
        for (String old : oldKeys) {
            if (keys.contains(old)) continue;
            config.set(old, null);
        }
    }

    public static String waveRewardList(String arena, String type) {
        return "arenas." + arena + ".rewards.waves." + type;
    }

    public static String waveReward(String arena, String type, int wave) {
        return "arenas." + arena + ".rewards.waves." + type + "." + wave;
    }

    public static String waveReward(Arena arena, String type, int wave) {
        return "arenas." + arena.configName() + ".rewards.waves." + type + "." + wave;
    }
}

