/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.inventory;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.inventory.SerializableInventory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryManager {
    private static String EXT = ".inv";
    private File dir;
    private Map<Player, ItemStack[]> items;
    private Map<Player, ItemStack[]> armor;

    public InventoryManager(Arena arena) {
        this.dir = new File(arena.getPlugin().getDataFolder(), "inventories");
        this.dir.mkdir();
        this.items = new HashMap<Player, ItemStack[]>();
        this.armor = new HashMap<Player, ItemStack[]>();
    }

    public boolean storeInventory(Player p) {
        if (this.items.containsKey(p) && this.armor.containsKey(p)) {
            return false;
        }
        PlayerInventory inv = p.getInventory();
        ItemStack[] memItems = inv.getContents();
        ItemStack[] memArmor = inv.getArmorContents();
        this.items.put(p, memItems);
        this.armor.put(p, memArmor);
        this.saveToFile(p);
        this.clearInventory(p);
        return true;
    }

    public boolean restoreInventory(Player p) {
        ItemStack[] memItems = this.items.remove(p);
        ItemStack[] memArmor = this.armor.remove(p);
        if (memItems != null && memArmor != null) {
            PlayerInventory inv = p.getInventory();
            inv.setContents(memItems);
            inv.setArmorContents(memArmor);
            new File(this.dir, p.getName() + EXT).delete();
            return true;
        }
        return this.loadFromFile(p);
    }

    public void clearInventory(Player p) {
        PlayerInventory inv = p.getInventory();
        inv.clear();
        inv.setHelmet(null);
        inv.setChestplate(null);
        inv.setLeggings(null);
        inv.setBoots(null);
    }

    private boolean saveToFile(Player p) {
        File file = new File(this.dir, p.getName() + EXT);
        if (file.exists()) {
            return false;
        }
        try {
            SerializableInventory inv = new SerializableInventory(p.getInventory());
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(inv);
            oos.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean loadFromFile(Player p) {
        File file = new File(this.dir, p.getName() + EXT);
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object o = ois.readObject();
            ois.close();
            SerializableInventory inv = (SerializableInventory)o;
            SerializableInventory.loadContents(p, inv);
            file.delete();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasEmptyInventory(Player p) {
        ItemStack[] inventory = p.getInventory().getContents();
        ItemStack[] armor = p.getInventory().getArmorContents();
        for (ItemStack stack : inventory) {
            if (stack == null) continue;
            return false;
        }
        for (ItemStack stack : armor) {
            if (stack.getTypeId() == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean restoreFromFile(MobArena plugin, Player p) {
        File dir = new File(plugin.getDataFolder(), "inventories");
        File file = new File(dir, p.getName() + EXT);
        if (!file.exists()) {
            return false;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object o = ois.readObject();
            ois.close();
            SerializableInventory inv = (SerializableInventory)o;
            SerializableInventory.loadContents(p, inv);
            file.delete();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

