/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.WaveUtils;
import java.util.Arrays;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Wolf;

public enum MACreature {
    ZOMBIE(EntityType.ZOMBIE),
    ZOMBIES(EntityType.ZOMBIE),
    SKELETON(EntityType.SKELETON),
    SKELETONS(EntityType.SKELETON),
    SPIDER(EntityType.SPIDER),
    SPIDERS(EntityType.SPIDER),
    CREEPER(EntityType.CREEPER),
    CREEPERS(EntityType.CREEPER),
    WOLF(EntityType.WOLF),
    WOLVES(EntityType.WOLF),
    ZOMBIEPIGMAN(EntityType.PIG_ZOMBIE),
    ZOMBIEPIGMEN(EntityType.PIG_ZOMBIE),
    POWEREDCREEPER(EntityType.CREEPER),
    POWEREDCREEPERS(EntityType.CREEPER),
    ANGRYWOLF(EntityType.WOLF),
    ANGRYWOLVES(EntityType.WOLF),
    GIANT(EntityType.GIANT),
    GIANTS(EntityType.GIANT),
    GHAST(EntityType.GHAST),
    GHASTS(EntityType.GHAST),
    ENDERMAN(EntityType.ENDERMAN),
    ENDERMEN(EntityType.ENDERMAN),
    CAVESPIDER(EntityType.CAVE_SPIDER),
    CAVESPIDERS(EntityType.CAVE_SPIDER),
    SILVERFISH(EntityType.SILVERFISH),
    BLAZE(EntityType.BLAZE),
    BLAZES(EntityType.BLAZE),
    ENDERDRAGON(EntityType.ENDER_DRAGON),
    ENDERDRAGONS(EntityType.ENDER_DRAGON),
    SNOWMAN(EntityType.SNOWMAN),
    SNOWMEN(EntityType.SNOWMAN),
    SNOWGOLEM(EntityType.SNOWMAN),
    SNOWGOLEMS(EntityType.SNOWMAN),
    MUSHROOMCOW(EntityType.MUSHROOM_COW),
    MUSHROOMCOWS(EntityType.MUSHROOM_COW),
    VILLAGER(EntityType.VILLAGER),
    VILLAGERS(EntityType.VILLAGER),
    OCELOT(EntityType.OCELOT),
    OCELOTS(EntityType.OCELOT),
    IRONGOLEM(EntityType.IRON_GOLEM),
    IRONGOLEMS(EntityType.IRON_GOLEM),
    CHICKEN(EntityType.CHICKEN),
    CHICKENS(EntityType.CHICKEN),
    COW(EntityType.COW),
    COWS(EntityType.COW),
    PIG(EntityType.PIG),
    PIGS(EntityType.PIG),
    SHEEP(EntityType.SHEEP),
    SQUID(EntityType.SQUID),
    SQUIDS(EntityType.SQUID),
    EXPLODINGSHEEP(EntityType.SHEEP),
    SLIME(EntityType.SLIME),
    SLIMES(EntityType.SLIME),
    SLIMETINY(EntityType.SLIME),
    SLIMESTINY(EntityType.SLIME),
    SLIMESMALL(EntityType.SLIME),
    SLIMESSMALL(EntityType.SLIME),
    SLIMEBIG(EntityType.SLIME),
    SLIMESBIG(EntityType.SLIME),
    SLIMEHUGE(EntityType.SLIME),
    SLIMESHUGE(EntityType.SLIME),
    MAGMACUBE(EntityType.MAGMA_CUBE),
    MAGMACUBES(EntityType.MAGMA_CUBE),
    MAGMACUBETINY(EntityType.MAGMA_CUBE),
    MAGMACUBESTINY(EntityType.MAGMA_CUBE),
    MAGMACUBESMALL(EntityType.MAGMA_CUBE),
    MAGMACUBESSMALL(EntityType.MAGMA_CUBE),
    MAGMACUBEBIG(EntityType.MAGMA_CUBE),
    MAGMACUBESBIG(EntityType.MAGMA_CUBE),
    MAGMACUBEHUGE(EntityType.MAGMA_CUBE),
    MAGMACUBESHUGE(EntityType.MAGMA_CUBE);

    private List<DyeColor> colors = Arrays.asList(DyeColor.values());
    private EntityType type;

    private MACreature(EntityType type) {
        this.type = type;
    }

    public EntityType getType() {
        return this.type;
    }

    public static MACreature fromString(String string) {
        return WaveUtils.getEnumFromString(MACreature.class, string.replaceAll("[-_\\.]", ""));
    }

    public LivingEntity spawn(Arena arena, World world, Location loc) {
        LivingEntity e = (LivingEntity)world.spawnEntity(loc, this.type);
        switch (this) {
            case SHEEP: {
                ((Sheep)e).setColor(this.colors.get(MobArena.random.nextInt(this.colors.size())));
                break;
            }
            case EXPLODINGSHEEP: {
                arena.getMonsterManager().addExplodingSheep(e);
                ((Sheep)e).setColor(DyeColor.RED);
                break;
            }
            case POWEREDCREEPERS: {
                ((Creeper)e).setPowered(true);
                break;
            }
            case ANGRYWOLVES: {
                ((Wolf)e).setAngry(true);
                break;
            }
            case SLIME: 
            case SLIMES: 
            case MAGMACUBE: 
            case MAGMACUBES: {
                ((Slime)e).setSize(1 + MobArena.random.nextInt(3));
                break;
            }
            case SLIMETINY: 
            case SLIMESTINY: 
            case MAGMACUBETINY: 
            case MAGMACUBESTINY: {
                ((Slime)e).setSize(1);
                break;
            }
            case SLIMESMALL: 
            case SLIMESSMALL: 
            case MAGMACUBESMALL: 
            case MAGMACUBESSMALL: {
                ((Slime)e).setSize(2);
                break;
            }
            case SLIMEBIG: 
            case SLIMESBIG: 
            case MAGMACUBEBIG: 
            case MAGMACUBESBIG: {
                ((Slime)e).setSize(3);
                break;
            }
            case SLIMEHUGE: 
            case SLIMESHUGE: 
            case MAGMACUBEHUGE: 
            case MAGMACUBESHUGE: {
                ((Slime)e).setSize(4);
                break;
            }
        }
        if (e instanceof Creature) {
            Creature c = (Creature)e;
            c.setTarget((LivingEntity)WaveUtils.getClosestPlayer(arena, (Entity)e));
        }
        return e;
    }
}

