/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.MAUtils;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.enums.WaveBranch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WaveUtils {
    public static List<Location> getValidSpawnpoints(Arena arena, List<Location> spawnpoints, Collection<Player> players) {
        MobArena plugin = arena.getPlugin();
        ArrayList<Location> result = new ArrayList<Location>();
        if (spawnpoints == null || spawnpoints.isEmpty()) {
            spawnpoints = arena.getRegion().getSpawnpointList();
        }
        block0: for (Location l : spawnpoints) {
            for (Player p : players) {
                if (MAUtils.distanceSquared(plugin, p, l) >= 225.0) continue;
                result.add(l);
                continue block0;
            }
        }
        if (result.isEmpty()) {
            Messenger.warning("Spawnpoints of arena '" + arena.configName() + "' may be too far apart!");
            return spawnpoints;
        }
        return result;
    }

    public static Player getClosestPlayer(Arena arena, Entity e) {
        double dist = 0.0;
        double current = Double.POSITIVE_INFINITY;
        Player result = null;
        for (Player p : arena.getPlayersInArena()) {
            if (!arena.getWorld().equals(p.getWorld())) {
                Messenger.info("Player '" + p.getName() + "' is not in the right world. Kicking...");
                p.kickPlayer("[MobArena] Cheater! (Warped out of the arena world.)");
                continue;
            }
            dist = p.getLocation().distanceSquared(e.getLocation());
            if (!(dist < current) || !(dist < 225.0)) continue;
            current = dist;
            result = p;
        }
        return result;
    }

    public static Comparator<Wave> getComparator(WaveBranch branch) {
        if (branch == WaveBranch.SINGLE) {
            return WaveUtils.getSingleComparator();
        }
        if (branch == WaveBranch.RECURRENT) {
            return WaveUtils.getRecurrentComparator();
        }
        return null;
    }

    public static Comparator<Wave> getSingleComparator() {
        return new Comparator<Wave>(){

            @Override
            public int compare(Wave w1, Wave w2) {
                if (w1.getFirstWave() < w2.getFirstWave()) {
                    return -1;
                }
                if (w1.getFirstWave() > w2.getFirstWave()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static Comparator<Wave> getRecurrentComparator() {
        return new Comparator<Wave>(){

            @Override
            public int compare(Wave w1, Wave w2) {
                if (w1.getPriority() < w2.getPriority()) {
                    return -1;
                }
                if (w1.getPriority() > w2.getPriority()) {
                    return 1;
                }
                return w1.getName().compareTo(w2.getName());
            }
        };
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string, T def) {
        if (c != null && string != null) {
            try {
                return Enum.valueOf(c, string.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return def;
    }

    public static <T extends Enum<T>> T getEnumFromString(Class<T> c, String string) {
        if (c != null && string != null) {
            try {
                return Enum.valueOf(c, string.trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T extends Enum<T>> T getEnumFromStringCaseSensitive(Class<T> c, String string) {
        if (c != null && string != null) {
            try {
                return Enum.valueOf(c, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }
}

