/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.ability;

import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.util.FileUtils;
import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.ability.AbilityInfo;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class AbilityManager {
    private static final String jarpath = "." + File.separator + "plugins" + File.separator + "MobArena.jar";
    private static final String classpath = jarpath + ";" + System.getProperty("java.class.path");
    private static Map<String, Ability> abilities;

    public static Ability fromString(String name) {
        return abilities.get(name.toLowerCase().replaceAll("[-_.]", ""));
    }

    public static void loadAbilities(File classDir) {
        String[] files;
        abilities = new HashMap<String, Ability>();
        File javaDir = new File(classDir, "src");
        if (javaDir.exists()) {
            if (ToolProvider.getSystemJavaCompiler() != null) {
                AbilityManager.compileAbilities(javaDir, classDir);
            } else {
                Messenger.warning("Found plugins/MobArena/abilites/src/ folder, but no Java compiler. The source files will not be compiled!");
            }
        }
        if ((files = classDir.list()).length == 0 || files.length == 1 && files[0].equals("src")) {
            Messenger.info("No boss abilities found. Extracting defaults...");
            AbilityManager.extractDefaultAbilities(classDir);
        }
        AbilityManager.loadClasses(classDir);
    }

    private static void extractDefaultAbilities(File classDir) {
        List<String> resources = FileUtils.listFilesOnPath("res/abilities/", ".class");
        if (resources == null || resources.isEmpty()) {
            Messenger.severe("Couldn't extract the default boss abilities!");
            return;
        }
        List<File> files = FileUtils.extractResources(classDir, "abilities/", resources);
        Messenger.info("Extracted abilities: " + AbilityManager.fileListToString(files, "$"));
    }

    private static void compileAbilities(File javaDir, File classDir) {
        if (!javaDir.exists()) {
            return;
        }
        List<File> toCompile = AbilityManager.getSourceFilesToCompile(javaDir, classDir);
        if (toCompile.isEmpty()) {
            return;
        }
        Messenger.info("Compiling abilities: " + AbilityManager.fileListToString(toCompile));
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        try {
            Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(toCompile);
            List<String> options = Arrays.asList("-classpath", classpath, "-d", classDir.getPath());
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, options, null, compilationUnits);
            task.call();
            fileManager.close();
        }
        catch (Exception e) {
            Messenger.severe("Compilation step failed...");
            e.printStackTrace();
        }
    }

    private static List<File> getSourceFilesToCompile(File javaDir, File classDir) {
        ArrayList<File> result = new ArrayList<File>();
        if (javaDir == null || !javaDir.exists()) {
            return result;
        }
        File[] classFiles = classDir.listFiles();
        for (File javaFile : javaDir.listFiles()) {
            if (!javaFile.getName().endsWith(".java")) {
                Messenger.info("Found invalid ability file: " + javaFile.getName());
                continue;
            }
            File classFile = AbilityManager.findClassFile(javaFile, classFiles);
            if (AbilityManager.isClassFileNewer(javaFile, classFile)) continue;
            result.add(javaFile);
        }
        return result;
    }

    private static File findClassFile(File javaFile, File[] classFiles) {
        String javaFileName = javaFile.getName();
        String classFileName = javaFileName.substring(0, javaFileName.lastIndexOf(".")) + ".class";
        for (File classFile : classFiles) {
            if (!classFile.getName().equals(classFileName)) continue;
            return classFile;
        }
        return null;
    }

    private static boolean isClassFileNewer(File javaFile, File classFile) {
        if (classFile == null) {
            return false;
        }
        return classFile.lastModified() > javaFile.lastModified();
    }

    private static void loadClasses(File classDir) {
        ClassLoader loader = AbilityManager.getLoader(classDir);
        if (loader == null) {
            return;
        }
        StringBuffer buffy = new StringBuffer();
        for (File file : classDir.listFiles()) {
            String abilityName;
            String name;
            Ability ability;
            String filename = file.getName();
            int dot = filename.lastIndexOf(".class");
            if (dot < 0 || (ability = AbilityManager.makeAbility(loader, name = filename.substring(0, file.getName().lastIndexOf(".")))) == null || (abilityName = AbilityManager.loadAbility(ability)) == null) continue;
            buffy.append(", " + abilityName);
        }
    }

    private static String loadAbility(Ability ability) {
        AbilityInfo info = ability.getClass().getAnnotation(AbilityInfo.class);
        if (info == null) {
            return null;
        }
        for (String name : info.aliases()) {
            abilities.put(name, ability);
        }
        return info.aliases()[0];
    }

    private static Ability makeAbility(ClassLoader loader, String name) {
        try {
            Class<?> c = loader.loadClass(name);
            Object o = c.newInstance();
            if (o instanceof Ability) {
                return (Ability)o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static ClassLoader getLoader(File dir) {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{dir.toURI().toURL()}, Ability.class.getClassLoader());
            return loader;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String fileListToString(List<File> list) {
        return AbilityManager.fileListToString(list, null);
    }

    private static String fileListToString(List<File> list, String exclude) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer buffy = new StringBuffer();
        for (File file : list) {
            String name = file.getName();
            int dot = name.lastIndexOf(".");
            if (exclude != null && name.contains(exclude)) continue;
            buffy.append(", " + name.substring(0, dot));
        }
        return buffy.substring(2);
    }
}

