/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.enums;

import com.garbagemule.MobArena.waves.WaveUtils;

public enum WaveGrowth {
    OLD(0.0),
    SLOW(0.5),
    MEDIUM(0.65),
    FAST(0.8),
    PSYCHO(1.2);

    private double exp;

    private WaveGrowth(double exp) {
        this.exp = exp;
    }

    public static WaveGrowth fromString(String string) {
        return WaveUtils.getEnumFromString(WaveGrowth.class, string, OLD);
    }

    public int getAmount(int wave, int playerCount) {
        if (this == OLD) {
            return wave + playerCount;
        }
        double pc = playerCount;
        double w = wave;
        double base = Math.min(Math.ceil(pc / 2.0) + 1.0, 13.0);
        return (int)(base * Math.pow(w, this.exp));
    }
}

