/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.types;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.AbstractWave;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.enums.WaveType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;

public class SpecialWave
extends AbstractWave {
    private SortedMap<Integer, MACreature> monsterMap;

    public SpecialWave(SortedMap<Integer, MACreature> monsterMap) {
        this.monsterMap = monsterMap;
        this.setType(WaveType.SPECIAL);
    }

    @Override
    public Map<MACreature, Integer> getMonstersToSpawn(int wave, int playerCount, Arena arena) {
        Random random = new Random();
        int value = random.nextInt(this.monsterMap.lastKey());
        HashMap<MACreature, Integer> result = new HashMap<MACreature, Integer>();
        for (Map.Entry<Integer, MACreature> entry : this.monsterMap.entrySet()) {
            int amount;
            if (value > entry.getKey()) continue;
            switch (entry.getValue()) {
                case POWEREDCREEPERS: 
                case ZOMBIEPIGMEN: 
                case ANGRYWOLVES: {
                    amount = playerCount * 2;
                    break;
                }
                case SLIMES: {
                    amount = playerCount * 4;
                    break;
                }
                case GIANTS: 
                case GHASTS: {
                    amount = 2;
                }
                default: {
                    amount = playerCount + 1;
                }
            }
            amount = (int)Math.max(1.0, (double)amount * super.getAmountMultiplier());
            result.put(entry.getValue(), amount);
            break;
        }
        return result;
    }
}

