/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.types;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.AbstractWave;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.enums.SwarmAmount;
import com.garbagemule.MobArena.waves.enums.WaveType;
import java.util.HashMap;
import java.util.Map;

public class SwarmWave
extends AbstractWave {
    private MACreature monster;
    private SwarmAmount amount;

    public SwarmWave(MACreature monster) {
        this.monster = monster;
        this.amount = SwarmAmount.LOW;
        this.setType(WaveType.SWARM);
    }

    @Override
    public Map<MACreature, Integer> getMonstersToSpawn(int wave, int playerCount, Arena arena) {
        HashMap<MACreature, Integer> result = new HashMap<MACreature, Integer>();
        int toSpawn = (int)Math.max(1.0, (double)this.amount.getAmount(playerCount) * super.getAmountMultiplier());
        result.put(this.monster, toSpawn);
        return result;
    }

    public SwarmAmount getAmount() {
        return this.amount;
    }

    public void setAmount(SwarmAmount amount) {
        this.amount = amount;
    }
}

