/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class TileAlvearyHygroregulator
extends TileAlveary
implements IInventory,
ILiquidTankContainer {
    public static final int BLOCK_META = 5;
    private HygroregulatorRecipe[] recipes;
    InventoryAdapter canInventory = new InventoryAdapter(1, "CanInv");
    private TankSlot liquidTank = new TankSlot(10000);
    private HygroregulatorRecipe currentRecipe;
    private int transferTime;

    public TileAlvearyHygroregulator() {
        super(5);
        this.recipes = new HygroregulatorRecipe[]{new HygroregulatorRecipe(new LiquidStack(Block.field_71943_B, 1), 1, 0.01f, -0.005f), new HygroregulatorRecipe(new LiquidStack(Block.field_71938_D, 1), 10, -0.01f, 0.005f), new HygroregulatorRecipe(new LiquidStack(ForestryItem.liquidIce, 1), 10, 0.02f, -0.01f)};
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.HygroregulatorGUI.ordinal(), this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public String func_70303_b() {
        return "tile.alveary.5";
    }

    private HygroregulatorRecipe getRecipe(LiquidStack liquid) {
        HygroregulatorRecipe recipe = null;
        for (HygroregulatorRecipe rec : this.recipes) {
            if (!rec.liquid.isLiquidEqual(liquid)) continue;
            recipe = rec;
            break;
        }
        return recipe;
    }

    @Override
    protected void updateServerSide() {
        LiquidContainerData container;
        super.updateServerSide();
        if (this.transferTime <= 0 && this.liquidTank.quantity > 0) {
            this.currentRecipe = this.getRecipe(this.liquidTank.getLiquid());
            if (this.currentRecipe != null) {
                this.liquidTank.drain(this.currentRecipe.liquid.amount, true);
                this.transferTime = this.currentRecipe.transferTime;
            }
        }
        if (this.transferTime > 0) {
            --this.transferTime;
            if (this.currentRecipe != null) {
                IAlvearyComponent component = (IAlvearyComponent)this.getCentralTE();
                if (component != null) {
                    component.addHumidityChange(this.currentRecipe.humidChange, 0.0f, 1.0f);
                    component.addTemperatureChange(this.currentRecipe.tempChange, 0.0f, 2.0f);
                }
            } else {
                this.transferTime = 0;
            }
        }
        if (this.field_70331_k.func_72820_D() % 20L * 10L != 0L) {
            return;
        }
        if (this.canInventory.func_70301_a(0) != null && (container = LiquidHelper.getLiquidContainer(this.canInventory.func_70301_a(0))) != null && (container.stillLiquid.itemID == Block.field_71943_B.field_71990_ca || container.stillLiquid.itemID == Block.field_71938_D.field_71990_ca)) {
            this.canInventory.func_70299_a(0, StackUtils.replenishByContainer(this, this.canInventory.func_70301_a(0), container, this.liquidTank));
            if (this.canInventory.func_70301_a((int)0).field_77994_a <= 0) {
                this.canInventory.func_70299_a(0, null);
            }
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.canInventory.readFromNBT(nbttagcompound);
        this.liquidTank = new TankSlot(10000);
        if (nbttagcompound.func_74764_b("LiquidTank")) {
            this.liquidTank.readFromNBT(nbttagcompound.func_74775_l("LiquidTank"));
        }
        this.transferTime = nbttagcompound.func_74762_e("TransferTime");
        if (nbttagcompound.func_74764_b("CurrentLiquid")) {
            LiquidStack liquid = LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)nbttagcompound.func_74775_l("CurrentLiquid"));
            this.currentRecipe = this.getRecipe(liquid);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        this.canInventory.writeToNBT(nbttagcompound);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.liquidTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("LiquidTank", (NBTBase)NBTresourceSlot);
        nbttagcompound.func_74768_a("TransferTime", this.transferTime);
        if (this.currentRecipe != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.currentRecipe.liquid.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("CurrentLiquid", (NBTBase)subcompound);
        }
    }

    @Override
    public int getBlockTexture(int side, int metadata) {
        return 11;
    }

    @Override
    public IInventory getInventory() {
        return this.canInventory;
    }

    public int func_70302_i_() {
        if (this.canInventory != null) {
            return this.canInventory.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (this.canInventory != null) {
            return this.canInventory.func_70301_a(slotIndex);
        }
        return null;
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.canInventory != null) {
            return this.canInventory.func_70298_a(slotIndex, amount);
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.canInventory != null) {
            return this.canInventory.func_70304_b(slotIndex);
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        if (this.canInventory == null && !Proxies.common.isSimulating(this.field_70331_k)) {
            this.createInventory();
        }
        if (this.canInventory != null) {
            this.canInventory.func_70299_a(slotIndex, itemstack);
        }
    }

    public int func_70297_j_() {
        if (this.canInventory != null) {
            return this.canInventory.func_70297_j_();
        }
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.liquidTank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.liquidTank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.liquidTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.liquidTank;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.liquidTank.liquidId = j;
                break;
            }
            case 1: {
                this.liquidTank.quantity = j;
                break;
            }
            case 2: {
                this.liquidTank.liquidMeta = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.liquidTank.liquidId);
        iCrafting.func_71112_a(container, 1, this.liquidTank.quantity);
        iCrafting.func_71112_a(container, 2, this.liquidTank.liquidMeta);
    }

    private static class HygroregulatorRecipe {
        public final LiquidStack liquid;
        public final int transferTime;
        public final float humidChange;
        public final float tempChange;

        public HygroregulatorRecipe(LiquidStack liquid, int transferTime, float humidChange, float tempChange) {
            this.liquid = liquid;
            this.transferTime = transferTime;
            this.humidChange = humidChange;
            this.tempChange = tempChange;
        }
    }
}

