/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.core.EnumErrorCode;
import forestry.core.genetics.Allele;
import forestry.core.genetics.EffectData;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;
import forestry.plugins.PluginApiculture;
import net.minecraft.util.AxisAlignedBB;

public abstract class AlleleEffectThrottled
extends Allele
implements IAlleleBeeEffect {
    private String name;
    private boolean isCombinable = false;
    private int throttle;
    private boolean requiresWorkingQueen = false;

    public AlleleEffectThrottled(String uid, String name, boolean isDominant, int throttle, boolean requiresWorking, boolean isCombinable) {
        super(uid, isDominant);
        this.name = "apiculture.effect." + name;
        this.throttle = throttle;
        this.isCombinable = isCombinable;
        this.requiresWorkingQueen = requiresWorking;
    }

    @Override
    public String getIdentifier() {
        return StringUtil.localize(this.name);
    }

    public int getThrottle() {
        return this.throttle;
    }

    @Override
    public boolean isCombinable() {
        return this.isCombinable;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData) {
            return storedData;
        }
        return new EffectData(1, 0);
    }

    public boolean isHalted(IEffectData storedData, IBeeHousing housing) {
        if (this.requiresWorkingQueen && housing.getErrorOrdinal() != EnumErrorCode.OK.ordinal()) {
            return true;
        }
        int throttle = storedData.getInteger(0);
        storedData.setInteger(0, ++throttle);
        if (throttle < this.getThrottle()) {
            return true;
        }
        storedData.setInteger(0, 0);
        return false;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = this.getModifiedArea(genome, housing);
        PluginApiculture.proxy.addBeeHiveFX("particles/swarm_bee", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimary().getIconColour(0), area[0], area[1], area[2]);
        return storedData;
    }

    protected int[] getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        area[0] = (int)((float)area[0] * (housing.getTerritoryModifier(genome, 1.0f) * 3.0f));
        area[1] = (int)((float)area[1] * (housing.getTerritoryModifier(genome, 1.0f) * 3.0f));
        area[2] = (int)((float)area[2] * (housing.getTerritoryModifier(genome, 1.0f) * 3.0f));
        if (area[0] < 1) {
            area[0] = 1;
        }
        if (area[1] < 1) {
            area[1] = 1;
        }
        if (area[2] < 1) {
            area[2] = 1;
        }
        return area;
    }

    protected AxisAlignedBB getBounding(IBeeGenome genome, IBeeHousing housing, float modifier) {
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(modifier);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        Vect min = new Vect(housing.getXCoord() + offset.x, housing.getYCoord() + offset.y, housing.getZCoord() + offset.z);
        Vect max = new Vect(housing.getXCoord() + offset.x + area.x, housing.getYCoord() + offset.y + area.y, housing.getZCoord() + offset.z + area.z);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }
}

