/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.plugins.PluginApiculture;
import java.util.ArrayList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class Mutation
implements IBeeMutation {
    private int chance;
    boolean requiresDay = false;
    boolean requiresNight = false;
    boolean isSecret = false;
    IAllele allele0;
    IAllele allele1;
    IAllele[] template;
    private ArrayList restrictBiomeTypes = new ArrayList();
    private boolean strictBiomeCheck = false;
    private float minTemperature = 0.0f;
    private float maxTemperature = 2.0f;
    private float minRainfall = 0.0f;
    private float maxRainfall = 2.0f;

    public Mutation(IAllele allele0, IAllele allele1, IAllele[] template, int chance) {
        this.allele0 = allele0;
        this.allele1 = allele1;
        this.template = template;
        this.chance = chance;
        PluginApiculture.beeInterface.registerMutation(this);
    }

    public Mutation enableStrictBiomeCheck() {
        this.strictBiomeCheck = true;
        return this;
    }

    public Mutation restrictBiomeType(BiomeDictionary.Type type) {
        this.restrictBiomeTypes.add(type);
        return this;
    }

    public Mutation setTemperature(float minTemperature, float maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        return this;
    }

    public Mutation setRainfall(float minRainfall, float maxRainfall) {
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        return this;
    }

    public Mutation setTemperatureRainfall(float minTemperature, float maxTemperature, float minRainfall, float maxRainfall) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
        this.minRainfall = minRainfall;
        this.maxRainfall = maxRainfall;
        return this;
    }

    public Mutation setIsSecret() {
        this.isSecret = true;
        return this;
    }

    public Mutation requireDay() {
        this.requiresDay = true;
        this.requiresNight = false;
        return this;
    }

    public Mutation requireNight() {
        this.requiresDay = false;
        this.requiresNight = true;
        return this;
    }

    @Override
    public IAllele getAllele0() {
        return this.allele0;
    }

    @Override
    public IAllele getAllele1() {
        return this.allele1;
    }

    @Override
    public float getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        World world;
        block9: {
            boolean noneMatched;
            block11: {
                BiomeGenBase biome;
                block10: {
                    world = housing.getWorld();
                    if (this.requiresDay && !world.func_72935_r()) {
                        return 0.0f;
                    }
                    if (this.requiresNight && world.func_72935_r()) {
                        return 0.0f;
                    }
                    if (this.restrictBiomeTypes.size() <= 0) break block9;
                    noneMatched = true;
                    biome = BiomeGenBase.field_76773_a[housing.getBiomeId()];
                    if (!this.strictBiomeCheck) break block10;
                    BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
                    if (types.length != 1 || !this.restrictBiomeTypes.contains(types[0])) break block11;
                    noneMatched = false;
                    break block11;
                }
                for (BiomeDictionary.Type type : this.restrictBiomeTypes) {
                    if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)type)) continue;
                    noneMatched = false;
                    break;
                }
            }
            if (noneMatched) {
                return 0.0f;
            }
        }
        BiomeGenBase biome = world.func_72959_q().func_76935_a(housing.getXCoord(), housing.getZCoord());
        if (biome.field_76750_F < this.minTemperature || biome.field_76750_F > this.maxTemperature) {
            return 0.0f;
        }
        if (biome.field_76751_G < this.minRainfall || biome.field_76751_G > this.maxRainfall) {
            return 0.0f;
        }
        float processedChance = (float)this.chance * housing.getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, 1.0f) * PluginApiculture.beeInterface.getBeekeepingMode(world).getMutationModifier((IBeeGenome)genome0, (IBeeGenome)genome1, 1.0f);
        if (processedChance <= 0.0f) {
            return 0.0f;
        }
        if (this.allele0.getUID().equals(allele0.getUID()) && this.allele1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.allele1.getUID().equals(allele0.getUID()) && this.allele0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }

    @Override
    public float getBaseChance() {
        return this.chance;
    }

    @Override
    public IAllele[] getTemplate() {
        return this.template;
    }

    @Override
    public boolean isPartner(IAllele allele) {
        return this.allele0.getUID().equals(allele.getUID()) || this.allele1.getUID().equals(allele.getUID());
    }

    @Override
    public IAllele getPartner(IAllele allele) {
        if (this.allele0.getUID().equals(allele.getUID())) {
            return this.allele1;
        }
        return this.allele0;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }
}

