/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.genetics.Bee;
import forestry.core.genetics.ItemGE;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginApiculture;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;

public class ItemBeeGE
extends ItemGE {
    EnumBeeType type;

    public ItemBeeGE(int i, EnumBeeType type) {
        super(i);
        this.type = type;
        this.func_77637_a(Tabs.tabApiculture);
        if (type != EnumBeeType.DRONE) {
            this.func_77625_d(1);
        }
    }

    @Override
    protected IIndividual getIndividual(ItemStack itemstack) {
        return new Bee(itemstack.func_77978_p());
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0xFFFFFF;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 16768022;
    }

    public String func_77628_j(ItemStack itemstack) {
        if (itemstack.func_77978_p() == null) {
            return StringUtil.localize(this.type.getName());
        }
        Bee individual = new Bee(itemstack.func_77978_p());
        String name = individual.getDisplayName() + StringUtil.localize(this.type.getName() + ".adj.add") + " " + StringUtil.localize(this.type.getName());
        if (individual.isNatural()) {
            return name;
        }
        return name + " [-]";
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        if (this.type == EnumBeeType.QUEEN) {
            return;
        }
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (IBee individual : PluginApiculture.beeInterface.getIndividualTemplates()) {
            if (hideSecrets && individual.isSecret()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            ItemStack someStack = new ItemStack((Item)this);
            individual.writeToNBT(nbttagcompound);
            someStack.func_77982_d(nbttagcompound);
            itemList.add(someStack);
        }
    }

    @Override
    public int func_82790_a(ItemStack itemstack, int renderPass) {
        if (!itemstack.func_77942_o()) {
            return super.func_82790_a(itemstack, renderPass);
        }
        return this.getColourFromSpecies(PluginApiculture.beeInterface.getMember(itemstack).getGenome().getPrimary(), renderPass);
    }

    @Override
    public int getColourFromSpecies(IAlleleSpecies species, int renderPass) {
        if (species != null && species instanceof IAlleleBeeSpecies) {
            return ((IAlleleBeeSpecies)species).getIconColour(renderPass);
        }
        return 0xFFFFFF;
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 3;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            ((IAlleleBeeSpecies)allele).getIconProvider().registerItemIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(ItemStack itemstack, int renderPass) {
        return this.getIconFromSpecies(PluginApiculture.beeInterface.getMember(itemstack).getGenome().getPrimary(), renderPass);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIconFromSpecies(IAlleleBeeSpecies species, int renderPass) {
        if (species == null) {
            species = (IAlleleBeeSpecies)PluginApiculture.beeInterface.getDefaultTemplate()[EnumBeeChromosome.SPECIES.ordinal()];
        }
        return species.getIcon(this.type, renderPass);
    }
}

