/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.core.render.TextureManager;
import forestry.core.utils.BlockUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockCocoa;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFruitPod
extends BlockCocoa {
    @SideOnly(value=Side.CLIENT)
    private static Icon defaultIcon;

    public BlockFruitPod(int id) {
        super(id);
    }

    public static TileFruitPod getPodTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileFruitPod)) {
            return null;
        }
        return (TileFruitPod)tile;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (!this.func_71854_d(world, x, y, z)) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_72832_d(x, y, z, 0, 0, 2);
            return;
        }
        TileFruitPod tile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return;
        }
        tile.onBlockTick();
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        TileFruitPod tile = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return new ArrayList();
        }
        return new ArrayList<ItemStack>(Arrays.asList(tile.getDrop()));
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return BlockUtil.getDirectionalMetadata(world, x, y, z) >= 0;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        world.func_72932_q(x, y, z);
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileFruitPod();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        defaultIcon = TextureManager.getInstance().registerTerrainTex("pods/papaya.2");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        Icon podIcon;
        TileFruitPod pod = BlockFruitPod.getPodTile(world, x, y, z);
        if (pod != null && (podIcon = pod.getBlockTexture(world.func_72805_g(x, y, z), side)) != null) {
            return podIcon;
        }
        return defaultIcon;
    }

    public int func_71857_b() {
        return PluginArboriculture.modelIdPods;
    }
}

