/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.arboriculture.gadgets.BlockFruitPod;
import forestry.arboriculture.gadgets.TileFruitPod;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.genetics.ArboristTracker;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Chromosome;
import forestry.core.utils.BlockUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class TreeHelper
implements ITreeRoot {
    private static final String uid = "rootTrees";
    ArrayList treekeepingModes = new ArrayList();
    public static ITreekeepingMode activeTreekeepingMode;
    public static HashMap speciesTemplates;
    public static ArrayList treeTemplates;
    private static ArrayList treeMutations;
    private LinkedList leafTickHandlers = new LinkedList();

    @Override
    public String getUID() {
        return uid;
    }

    @Override
    public Class getMemberClass() {
        return ITree.class;
    }

    @Override
    public int getSpeciesCount() {
        return 0;
    }

    @Override
    public boolean isMember(ItemStack itemstack) {
        return this.getType(itemstack) != EnumGermlingType.NONE;
    }

    @Override
    public boolean isMember(ItemStack stack, int type) {
        return this.getType(stack).ordinal() == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof ITree;
    }

    @Override
    public EnumGermlingType getType(ItemStack stack) {
        if (stack == null) {
            return EnumGermlingType.NONE;
        }
        if (stack.field_77993_c == ForestryItem.sapling.field_77779_bT) {
            return EnumGermlingType.SAPLING;
        }
        if (stack.field_77993_c == ForestryItem.pollenFertile.field_77779_bT) {
            return EnumGermlingType.POLLEN;
        }
        return EnumGermlingType.NONE;
    }

    @Override
    public ITree getTree(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileSapling)) {
            return null;
        }
        return ((TileSapling)tile).getTree();
    }

    @Override
    public ITree getMember(ItemStack itemstack) {
        if (!this.isMember(itemstack)) {
            return null;
        }
        if (itemstack.func_77978_p() == null) {
            return null;
        }
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    public ITree getMember(NBTTagCompound compound) {
        return new Tree(compound);
    }

    @Override
    public ITree getTree(World world, ITreeGenome genome) {
        return new Tree(genome);
    }

    @Override
    public ItemStack getMemberStack(IIndividual tree, int type) {
        Item germlingItem;
        switch (EnumGermlingType.VALUES[type]) {
            case SAPLING: {
                germlingItem = ForestryItem.sapling;
                break;
            }
            case POLLEN: {
                germlingItem = ForestryItem.pollenFertile;
                break;
            }
            default: {
                return null;
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound("tag");
        tree.writeToNBT(nbttagcompound);
        ItemStack treeStack = new ItemStack(germlingItem);
        treeStack.func_77982_d(nbttagcompound);
        return treeStack;
    }

    @Override
    public boolean plantSapling(World world, ITree tree, String owner, int x, int y, int z) {
        boolean placed = world.func_72832_d(x, y, z, ForestryBlock.saplingGE.field_71990_ca, 0, 2);
        if (!placed) {
            return false;
        }
        if (world.func_72798_a(x, y, z) != ForestryBlock.saplingGE.field_71990_ca) {
            return false;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileSapling)) {
            world.func_72832_d(x, y, z, 0, 0, 2);
            return false;
        }
        TileSapling sapling = (TileSapling)tile;
        sapling.setTree(tree.copy());
        sapling.setOwner(owner);
        world.func_72845_h(x, y, z);
        return true;
    }

    @Override
    public boolean setLeaves(World world, IIndividual tree, String owner, int x, int y, int z) {
        boolean placed = world.func_72832_d(x, y, z, ForestryBlock.leaves.field_71990_ca, 0, 2);
        if (!placed) {
            return false;
        }
        if (world.func_72798_a(x, y, z) != ForestryBlock.leaves.field_71990_ca) {
            return false;
        }
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileLeaves)) {
            world.func_72832_d(x, y, z, 0, 0, 2);
            return false;
        }
        TileLeaves leaves = (TileLeaves)tile;
        leaves.setTree((ITree)tree.copy());
        leaves.setOwner(owner);
        world.func_72845_h(x, y, z);
        return true;
    }

    @Override
    public boolean setFruitBlock(World world, IAlleleFruit allele, float sappiness, short[] indices, int x, int y, int z) {
        int direction = BlockUtil.getDirectionalMetadata(world, x, y, z);
        if (direction < 0) {
            return false;
        }
        boolean placed = world.func_72832_d(x, y, z, ForestryBlock.pods.field_71990_ca, direction, 2);
        if (!placed) {
            return false;
        }
        if (world.func_72798_a(x, y, z) != ForestryBlock.pods.field_71990_ca) {
            return false;
        }
        TileFruitPod pod = BlockFruitPod.getPodTile((IBlockAccess)world, x, y, z);
        if (pod == null) {
            world.func_72832_d(x, y, z, 0, 0, 2);
            return false;
        }
        pod.setFruit(allele, sappiness, indices);
        world.func_72845_h(x, y, z);
        return true;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] template) {
        IChromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        IChromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] template) {
        return new TreeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new TreeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public IIndividual templateAsIndividual(IAllele[] template) {
        return new Tree(this.templateAsGenome(template));
    }

    @Override
    public IIndividual templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Tree(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public IArboristTracker getBreedingTracker(World world, String player) {
        String filename = "ArboristTracker." + player;
        ArboristTracker tracker = (ArboristTracker)world.func_72943_a(ArboristTracker.class, filename);
        if (tracker == null) {
            tracker = new ArboristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        return tracker;
    }

    @Override
    public ArrayList getTreekeepingModes() {
        return this.treekeepingModes;
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(World world) {
        if (activeTreekeepingMode != null) {
            return activeTreekeepingMode;
        }
        IArboristTracker tracker = this.getBreedingTracker(world, "__COMMON_");
        String mode = tracker.getModeName();
        if (mode == null || mode.isEmpty()) {
            mode = PluginArboriculture.treekeepingMode;
        }
        this.setTreekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().fine("Set Treekeeping mode for a world to " + mode);
        return activeTreekeepingMode;
    }

    @Override
    public void registerTreekeepingMode(ITreekeepingMode mode) {
        this.treekeepingModes.add(mode);
    }

    @Override
    public void setTreekeepingMode(World world, String name) {
        activeTreekeepingMode = this.getTreekeepingMode(name);
        this.getBreedingTracker(world, "__COMMON_").setModeName(name);
    }

    @Override
    public ITreekeepingMode getTreekeepingMode(String name) {
        for (ITreekeepingMode mode : this.treekeepingModes) {
            if (!mode.getName().equals(name) && !mode.getName().equals(name.toLowerCase(Locale.ENGLISH))) continue;
            return mode;
        }
        FMLCommonHandler.instance().getFMLLogger().fine("Failed to find a Treekeeping mode called '%s', reverting to fallback.");
        return (ITreekeepingMode)this.treekeepingModes.get(0);
    }

    @Override
    public Map getGenomeTemplates() {
        return speciesTemplates;
    }

    @Override
    public ArrayList getIndividualTemplates() {
        return treeTemplates;
    }

    @Override
    public void registerTemplate(IAllele[] template) {
        this.registerTemplate(template[0].getUID(), template);
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        treeTemplates.add(new Tree(PluginArboriculture.treeInterface.templateAsGenome(template)));
        speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getRandomTemplate(Random rand) {
        return ((IAllele[][])speciesTemplates.values().toArray((T[])new IAllele[0][]))[rand.nextInt(speciesTemplates.values().size())];
    }

    @Override
    public IAllele[] getTemplate(String identifier) {
        return (IAllele[])speciesTemplates.get(identifier);
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return TreeTemplates.getDefaultTemplate();
    }

    @Override
    public ArrayList getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(treeMutations);
        }
        return treeMutations;
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        treeMutations.add((ITreeMutation)mutation);
    }

    @Override
    public Collection getCombinations(IAllele other) {
        ArrayList<ITreeMutation> combinations = new ArrayList<ITreeMutation>();
        for (ITreeMutation mutation : this.getMutations(false)) {
            if (!mutation.isPartner(other)) continue;
            combinations.add(mutation);
        }
        return combinations;
    }

    @Override
    public void registerLeafTickHandler(ILeafTickHandler handler) {
        this.leafTickHandlers.add(handler);
    }

    @Override
    public Collection getLeafTickHandlers() {
        return this.leafTickHandlers;
    }

    static {
        speciesTemplates = new HashMap();
        treeTemplates = new ArrayList();
        treeMutations = new ArrayList();
    }
}

