/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gui;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.gui.ContainerTreealyzer;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Allele;
import forestry.core.genetics.AllelePlantType;
import forestry.core.gui.GuiAlyzer;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.EnumPlantType;

public class GuiTreealyzer
extends GuiAlyzer {
    private ItemStack[] tempProductList;

    public GuiTreealyzer(EntityPlayer player, ItemTreealyzer.TreealyzerInventory inventory) {
        super(AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees"), player, new ContainerTreealyzer(player.field_71071_by, inventory), inventory, 1, inventory.func_70302_i_());
        this.xSize = 196;
        this.ySize = 238;
        ArrayList treeList = new ArrayList();
        ((ItemGermlingGE)ForestryItem.sapling).addCreativeItems(treeList, false);
        for (ItemStack beeStack : treeList) {
            this.iconStacks.put(PluginArboriculture.treeInterface.getMember(beeStack).getIdent(), beeStack);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        this.drawBackground();
        int page = 0;
        ITree tree = null;
        for (int k = 1; k < 7; ++k) {
            if (k == 5 || this.inventory.func_70301_a(k) == null || (tree = PluginArboriculture.treeInterface.getMember(this.inventory.func_70301_a(k))) == null || !tree.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(tree);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(tree);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(tree);
                break;
            }
            case 4: {
                this.drawAnalyticsPage4(tree);
                break;
            }
            case 6: {
                this.drawAnalyticsPageClassification(tree);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsOverview() {
        this.startPage();
        this.newLine();
        String title = StringUtil.localize("gui.treealyzer").toUpperCase();
        this.drawCenteredLine(title, 8, 158);
        this.newLine();
        this.field_73886_k.func_78279_b(StringUtil.localize("gui.treealyzer.help"), (int)((float)(this.guiLeft + 12 + 4) * 1.3333334f), (int)((float)(this.guiTop + 42) * 1.3333334f), 210, this.fontColor.get("gui.screen"));
        this.newLine();
        this.newLine();
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.treealyzer.overview") + ":", 16);
        this.newLine();
        this.drawLine("I  : " + StringUtil.localize("gui.general"), 16);
        this.newLine();
        this.drawLine("II : " + StringUtil.localize("gui.environment"), 16);
        this.newLine();
        this.drawLine("III: " + StringUtil.localize("gui.produce"), 16);
        this.newLine();
        this.drawLine("IV : " + StringUtil.localize("gui.evolution"), 16);
        this.endPage();
    }

    private void drawAnalyticsPage1(ITree tree) {
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.active"), 52);
        this.drawLine(StringUtil.localize("gui.inactive"), 108);
        this.newLine();
        this.newLine();
        this.drawSpeciesRow(StringUtil.localize("gui.species"), tree, EnumTreeChromosome.SPECIES);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.saplings"), 12);
        this.drawLine(Tree.rateFertility(tree.getGenome().getFertility()), 52, tree, EnumTreeChromosome.FERTILITY, false);
        this.drawLine(Tree.rateFertility(((IAlleleFloat)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FERTILITY.ordinal())).getValue()), 108, tree, EnumTreeChromosome.FERTILITY, true);
        this.newLine();
        this.drawRow(StringUtil.localize("gui.maturity"), Tree.rateMaturity(tree.getGenome().getMaturationTime()), Tree.rateMaturity(((IAlleleInteger)tree.getGenome().getInactiveAllele(EnumTreeChromosome.MATURATION.ordinal())).getValue()), tree, EnumTreeChromosome.MATURATION);
        this.drawLine(StringUtil.localize("gui.height"), 12);
        this.drawLine(Tree.rateHeight(tree.getGenome().getHeight()), 52, tree, EnumTreeChromosome.HEIGHT, false);
        this.drawLine(Tree.rateHeight(((IAlleleFloat)tree.getGenome().getInactiveAllele(EnumTreeChromosome.HEIGHT.ordinal())).getValue()), 108, tree, EnumTreeChromosome.HEIGHT, true);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.girth"), 12);
        this.drawLine(String.format("%sx%s", tree.getGenome().getGirth(), tree.getGenome().getGirth()), 52, tree, EnumTreeChromosome.FERTILITY, false);
        int secondGirth = ((IAlleleInteger)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GIRTH.ordinal())).getValue();
        this.drawLine(String.format("%sx%s", secondGirth, secondGirth), 108, tree, EnumTreeChromosome.FERTILITY, true);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.yield"), 12);
        this.drawLine(Tree.rateYield(tree.getGenome().getYield()), 52, tree, EnumTreeChromosome.YIELD, false);
        this.drawLine(Tree.rateYield(((IAlleleFloat)tree.getGenome().getInactiveAllele(EnumTreeChromosome.YIELD.ordinal())).getValue()), 108, tree, EnumTreeChromosome.YIELD, true);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.sappiness"), 12);
        this.drawLine(Tree.rateSappiness(tree.getGenome().getSappiness()), 52, tree, EnumTreeChromosome.SAPPINESS, false);
        IAllele sappiness = tree.getGenome().getInactiveAllele(EnumTreeChromosome.SAPPINESS.ordinal());
        float sap = sappiness instanceof IAlleleFloat ? ((IAlleleFloat)sappiness).getValue() : 0.1f;
        this.drawLine(Tree.rateSappiness(sap), 108, tree, EnumTreeChromosome.SAPPINESS, true);
        this.newLine();
        this.drawRow(StringUtil.localize("gui.effect"), StringUtil.localize(tree.getGenome().getEffect().getIdentifier()), StringUtil.localize(((IAlleleEffect)tree.getGenome().getInactiveAllele(EnumTreeChromosome.EFFECT.ordinal())).getIdentifier()), tree, EnumTreeChromosome.EFFECT);
        this.newLine();
        this.newLine();
        this.endPage();
    }

    private void drawAnalyticsPage2(ITree tree) {
        this.startPage();
        int speciesDominance0 = this.getColorCoding(tree.getGenome().getPrimary().isDominant());
        int speciesDominance1 = this.getColorCoding(tree.getGenome().getSecondary().isDominant());
        this.drawLine(StringUtil.localize("gui.active"), 52);
        this.drawLine(StringUtil.localize("gui.inactive"), 108);
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.growth"), 12);
        this.drawLine(tree.getGenome().getGrowthProvider().getDescription(), 52, tree, EnumTreeChromosome.GROWTH, false);
        this.drawLine(((IAlleleGrowth)tree.getGenome().getInactiveAllele(EnumTreeChromosome.GROWTH.ordinal())).getProvider().getDescription(), 108, tree, EnumTreeChromosome.GROWTH, true);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.native"), 12);
        this.drawLine(StringUtil.localize("gui." + tree.getGenome().getPrimary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 52, speciesDominance0);
        this.drawLine(StringUtil.localize("gui." + tree.getGenome().getSecondary().getPlantType().toString().toLowerCase(Locale.ENGLISH)), 108, speciesDominance1);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.tolerated"), 12);
        EnumPlantType[] tolerated0 = tree.getGenome().getPlantTypes().toArray(new EnumPlantType[0]);
        EnumPlantType[] tolerated1 = new EnumPlantType[]{};
        IAllele allele1 = tree.getGenome().getInactiveAllele(EnumTreeChromosome.PLANT.ordinal());
        if (allele1 instanceof AllelePlantType) {
            tolerated1 = ((AllelePlantType)allele1).getPlantTypes().toArray(new EnumPlantType[0]);
        }
        int max = tolerated0.length > tolerated1.length ? tolerated0.length : tolerated1.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.newLine();
            }
            if (tolerated0.length > i) {
                this.drawLine(StringUtil.localize("gui." + tolerated0[i].toString().toLowerCase(Locale.ENGLISH)), 52, tree, EnumTreeChromosome.PLANT, false);
            }
            if (tolerated1.length <= i) continue;
            this.drawLine(StringUtil.localize("gui." + tolerated1[i].toString().toLowerCase(Locale.ENGLISH)), 108, tree, EnumTreeChromosome.PLANT, true);
        }
        this.newLine();
        this.drawLine(StringUtil.localize("gui.supports"), 12);
        IFruitFamily[] families0 = tree.getGenome().getPrimary().getSuitableFruit().toArray(new IFruitFamily[0]);
        IFruitFamily[] families1 = tree.getGenome().getPrimary().getSuitableFruit().toArray(new IFruitFamily[0]);
        max = families0.length > families1.length ? families0.length : families1.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.newLine();
            }
            if (families0.length > i) {
                this.drawLine(StringUtil.localize(families0[i].getName()), 52, speciesDominance0);
            }
            if (families1.length <= 0) continue;
            this.drawLine(StringUtil.localize(families1[i].getName()), 108, speciesDominance1);
        }
        this.newLine();
        this.newLine();
        int fruitDominance0 = this.getColorCoding(tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS.ordinal()).isDominant());
        int fruitDominance1 = this.getColorCoding(tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS.ordinal()).isDominant());
        this.drawLine(StringUtil.localize("gui.fruits"), 12);
        String strike = "";
        IAllele fruit0 = tree.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS.ordinal());
        if (!tree.canBearFruit() && fruit0 != Allele.fruitNone) {
            strike = "\u00a7m";
        }
        this.drawLine(strike + StringUtil.localize(tree.getGenome().getFruitProvider().getDescription()), 52, fruitDominance0);
        strike = "";
        IAllele fruit1 = tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS.ordinal());
        if (!tree.getGenome().getSecondary().getSuitableFruit().contains(((IAlleleFruit)fruit1).getProvider().getFamily()) && fruit1 != Allele.fruitNone) {
            strike = "\u00a7m";
        }
        this.drawLine(strike + StringUtil.localize(((IAlleleFruit)fruit1).getProvider().getDescription()), 108, fruitDominance1);
        this.newLine();
        this.drawLine(StringUtil.localize("gui.family"), 12);
        IFruitFamily primary = tree.getGenome().getFruitProvider().getFamily();
        IFruitFamily secondary = ((IAlleleFruit)tree.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS.ordinal())).getProvider().getFamily();
        if (primary != null) {
            this.drawLine(StringUtil.localize(primary.getName()), 52, fruitDominance0);
        }
        if (secondary != null) {
            this.drawLine(StringUtil.localize(secondary.getName()), 108, fruitDominance1);
        }
        this.endPage();
    }

    private void drawAnalyticsPage3(ITree tree) {
        this.tempProductList = tree.getProduceList();
        this.startPage(12, 52, 108);
        this.drawLine(StringUtil.localize("gui.beealyzer.produce") + ":", 12);
        this.newLine();
        int x = 12;
        for (ItemStack stack : this.tempProductList) {
            itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, stack, (int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.newLine();
        this.newLine();
        this.drawLine(StringUtil.localize("gui.beealyzer.specialty") + ":", 12);
        this.newLine();
        x = 12;
        for (ItemStack stack : tree.getSpecialtyList()) {
            itemRenderer.func_77015_a(this.field_73886_k, this.field_73882_e.field_71446_o, stack, (int)((float)(this.guiLeft + x) * 1.3333334f), (int)((float)(this.guiTop + this.getLineY()) * 1.3333334f));
            if ((x += 18) <= this.adjustToFactor(148)) continue;
            x = 12;
            this.newLine();
        }
        this.endPage();
    }
}

