/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.ITileStructure;
import forestry.core.CreativeTabForestry;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IOwnable;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class BlockForestry
extends BlockContainer {
    protected static boolean keepInventory = false;
    protected Random furnaceRand;

    public BlockForestry(int i, Material material) {
        super(i, material);
        this.func_71848_c(1.5f);
        this.furnaceRand = new Random();
        this.func_71849_a(CreativeTabForestry.tabForestry);
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        IOwnable tile = (IOwnable)world.func_72796_p(x, y, z);
        if (tile.allowsRemoval(player)) {
            return super.removeBlockByPlayer(world, player, x, y, z);
        }
        return false;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileForestry tile = (TileForestry)world.func_72796_p(x, y, z);
        if (tile instanceof ITileStructure) {
            IInventory inventory = ((ITileStructure)((Object)tile)).getInventory();
            if (inventory != null) {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    if (inventory.func_70301_a(i) == null) continue;
                    StackUtils.dropItemStackAsEntity(inventory.func_70301_a(i), world, x, y, z);
                    inventory.func_70299_a(i, null);
                }
            }
        } else {
            Object inventory = tile instanceof IInventory ? (IInventory)tile : tile.getInternalInventory();
            if (inventory != null) {
                for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
                    ItemStack itemstack = inventory.func_70301_a(slot);
                    if (itemstack == null) continue;
                    float f = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    float f1 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    float f2 = this.furnaceRand.nextFloat() * 0.8f + 0.1f;
                    while (itemstack.field_77994_a > 0) {
                        int stackPartial = this.furnaceRand.nextInt(21) + 10;
                        if (stackPartial > itemstack.field_77994_a) {
                            stackPartial = itemstack.field_77994_a;
                        }
                        ItemStack drop = itemstack.func_77979_a(stackPartial);
                        EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), drop);
                        float accel = 0.05f;
                        entityitem.field_70159_w = (float)this.furnaceRand.nextGaussian() * accel;
                        entityitem.field_70181_x = (float)this.furnaceRand.nextGaussian() * accel + 0.2f;
                        entityitem.field_70179_y = (float)this.furnaceRand.nextGaussian() * accel;
                        world.func_72838_d((Entity)entityitem);
                    }
                    inventory.func_70299_a(slot, null);
                }
            }
        }
        if (tile != null) {
            tile.onRemoval();
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public void func_71860_a(World world, int i, int j, int k, EntityLiving entityliving, ItemStack itemstack) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileForestry tile = (TileForestry)world.func_72796_p(i, j, k);
        if (entityliving instanceof EntityPlayer) {
            tile.owner = ((EntityPlayer)entityliving).field_71092_bJ;
        }
    }
}

