/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.Defaults;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IOwnable;
import forestry.core.network.ForestryPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketTileUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.Vect;
import java.util.LinkedList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileForestry
extends TileEntity
implements INetworkedEntity,
IOwnable,
IErrorSource {
    protected boolean isInited = false;
    protected int energyConsumed;
    protected int energyLast;
    protected int energyReceived;
    private ForgeDirection orientation = ForgeDirection.WEST;
    public EnumErrorCode errorState = EnumErrorCode.OK;
    public String owner = null;
    private EnumAccess access = EnumAccess.SHARED;

    public Vect Coords() {
        return new Vect(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void openGui(EntityPlayer player) {
    }

    public void rotateAfterPlacement(World world, int x, int y, int z, EntityLiving entityliving, ItemStack itemstack) {
        int l = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            this.setOrientation(ForgeDirection.NORTH);
        }
        if (l == 1) {
            this.setOrientation(ForgeDirection.EAST);
        }
        if (l == 2) {
            this.setOrientation(ForgeDirection.SOUTH);
        }
        if (l == 3) {
            this.setOrientation(ForgeDirection.WEST);
        }
    }

    public void func_70316_g() {
        IPowerReceptor receptor;
        if (!this.isInited) {
            this.initialize();
            this.isInited = true;
        }
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        if (this instanceof IPowerReceptor && (receptor = (IPowerReceptor)((Object)this)).getPowerProvider() != null) {
            IPowerProvider powerProvider = receptor.getPowerProvider();
            powerProvider.update(receptor);
        }
    }

    public abstract void initialize();

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.access = nbttagcompound.func_74764_b("Access") ? EnumAccess.values()[nbttagcompound.func_74762_e("Access")] : EnumAccess.SHARED;
        if (nbttagcompound.func_74764_b("Owner")) {
            this.owner = nbttagcompound.func_74779_i("Owner");
        }
        this.orientation = nbttagcompound.func_74764_b("Orientation") ? ForgeDirection.values()[nbttagcompound.func_74762_e("Orientation")] : ForgeDirection.WEST;
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("Access", this.access.ordinal());
        if (this.owner != null) {
            nbttagcompound.func_74778_a("Owner", this.owner);
        }
        if (this.orientation != null) {
            nbttagcompound.func_74768_a("Orientation", this.orientation.ordinal());
        }
    }

    @Override
    public void sendNetworkUpdate() {
        PacketTileUpdate packet = new PacketTileUpdate(this);
        Proxies.net.sendNetworkPacket(packet, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public Packet func_70319_e() {
        PacketTileUpdate packet = new PacketTileUpdate(this);
        return packet.getPacket();
    }

    public abstract PacketPayload getPacketPayload();

    public abstract void fromPacketPayload(PacketPayload var1);

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        PacketTileUpdate packet = (PacketTileUpdate)packetRaw;
        this.orientation = packet.getOrientation();
        this.errorState = packet.getErrorState();
        this.owner = packet.getOwner();
        this.access = packet.getAccess();
        this.fromPacketPayload(packet.payload);
    }

    public LinkedList getCustomTriggers() {
        return null;
    }

    public void onRemoval() {
    }

    public boolean isActivated() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public ForgeDirection getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ForgeDirection orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.sendNetworkUpdate();
    }

    public void setErrorState(EnumErrorCode state) {
        if (this.errorState == state) {
            return;
        }
        this.errorState = state;
        this.sendNetworkUpdate();
    }

    @Override
    public boolean throwsErrors() {
        return true;
    }

    @Override
    public EnumErrorCode getErrorState() {
        return this.errorState;
    }

    @Override
    public boolean allowsRemoval(EntityPlayer player) {
        if (!this.isOwnable()) {
            return true;
        }
        if (!this.isOwned()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (Proxies.common.isOp(player)) {
            return true;
        }
        return this.getAccess() == EnumAccess.SHARED;
    }

    @Override
    public boolean allowsInteraction(EntityPlayer player) {
        if (Config.disablePermissions) {
            return true;
        }
        if (!this.isOwnable()) {
            return true;
        }
        if (!this.isOwned()) {
            return true;
        }
        if (this.isOwner(player)) {
            return true;
        }
        if (Proxies.common.isOp(player)) {
            return true;
        }
        return this.getAccess() == EnumAccess.SHARED || this.getAccess() == EnumAccess.VIEWABLE;
    }

    @Override
    public EnumAccess getAccess() {
        return this.access;
    }

    @Override
    public boolean isOwnable() {
        return false;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null && !this.owner.isEmpty();
    }

    @Override
    public String getOwnerName() {
        return this.owner;
    }

    public EntityPlayer getOwnerEntity() {
        if (this.owner != null) {
            return this.field_70331_k.func_72924_a(this.owner);
        }
        return null;
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player.field_71092_bJ;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        if (this.owner != null) {
            return this.owner.equals(player.field_71092_bJ);
        }
        return false;
    }

    @Override
    public boolean switchAccessRule(EntityPlayer player) {
        if (this.owner != null && !this.owner.isEmpty() && !this.owner.equals(player.field_71092_bJ)) {
            return false;
        }
        this.access = this.access.ordinal() < EnumAccess.values().length - 1 ? EnumAccess.values()[this.access.ordinal() + 1] : EnumAccess.values()[0];
        return true;
    }

    public abstract String func_70303_b();

    public boolean func_94042_c() {
        return true;
    }

    public abstract boolean func_70300_a(EntityPlayer var1);

    protected InventoryAdapter getInternalInventory() {
        return null;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return true;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.canPutStackFromSide(i, itemstack, j);
    }

    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        return this.getAccess() != EnumAccess.PRIVATE;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return this.canTakeStackFromSide(i, itemstack, j);
    }

    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        return this.getAccess() != EnumAccess.PRIVATE;
    }

    public int[] func_94128_d(int side) {
        if (this.getInternalInventory() == null) {
            return Defaults.FACINGS_NONE;
        }
        return this.getInternalInventory().getSizeInventorySide(side);
    }
}

